/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.hud;

import mekanism.api.radiation.IRadiationManager;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.lib.radiation.RadiationManager;
import mekanism.common.registries.MekanismAttachmentTypes;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class RadiationOverlay
implements LayeredDraw.Layer {
    public static final RadiationOverlay INSTANCE = new RadiationOverlay();
    private double prevRadiation = 0.0;
    private int lastTick;

    private RadiationOverlay() {
    }

    public void resetRadiation() {
        this.prevRadiation = 0.0;
    }

    public void render(@NotNull GuiGraphics graphics, @NotNull DeltaTracker delta) {
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player != null && IRadiationManager.INSTANCE.isRadiationEnabled() && MekanismUtils.isPlayingMode((Player)player)) {
            double radiation = (Double)player.getData(MekanismAttachmentTypes.RADIATION);
            double severity = RadiationManager.RadiationScale.getScaledDoseSeverity(radiation) * 0.8;
            if (this.lastTick != minecraft.gui.getGuiTicks()) {
                this.lastTick = minecraft.gui.getGuiTicks();
                if (this.prevRadiation < severity) {
                    this.prevRadiation = Math.min(severity, this.prevRadiation + 0.01);
                }
                if (this.prevRadiation > severity) {
                    this.prevRadiation = Math.max(severity, this.prevRadiation - 0.01);
                }
            }
            if (severity > IRadiationManager.INSTANCE.baselineRadiation()) {
                int effect = (int)(this.prevRadiation * 255.0);
                int color = 1881021952 + effect;
                MekanismRenderer.renderColorOverlay(graphics, 0, 0, color);
            }
        }
    }
}

