/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.data;

import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.client.render.data.FluidRenderData;
import mekanism.common.lib.multiblock.IValveHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

@NothingNullByDefault
public class ValveRenderData
extends FluidRenderData {
    private final Direction side;
    private final int valveFluidHeight;

    private ValveRenderData(FluidRenderData renderData, Direction side, BlockPos valveLocation) {
        super(renderData.location, renderData.width, renderData.height, renderData.length, renderData.fluidType);
        this.side = side;
        this.valveFluidHeight = valveLocation.getY() - this.location.getY();
    }

    public static ValveRenderData get(FluidRenderData renderData, IValveHandler.ValveData valveData) {
        return new ValveRenderData(renderData, valveData.side, valveData.location);
    }

    public int getValveFluidHeight() {
        return this.valveFluidHeight;
    }

    public Direction getSide() {
        return this.side;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object data) {
        if (!(data instanceof ValveRenderData)) return false;
        ValveRenderData other = (ValveRenderData)data;
        if (!super.equals(data)) return false;
        if (this.side != other.side) return false;
        if (this.valveFluidHeight != other.valveFluidHeight) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.side, this.valveFluidHeight);
    }
}

