/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import mekanism.api.chemical.IMekanismChemicalHandler;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeInfo;
import mekanism.client.gui.element.gauge.GaugeOverlay;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiChemicalGauge;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiTankGauge;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerIngredientHelper;
import mekanism.common.capabilities.merged.MergedTank;
import mekanism.common.lib.transmitter.TransmissionType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class GuiMergedTankGauge<HANDLER extends IMekanismFluidHandler & IMekanismChemicalHandler>
extends GuiGauge<Void>
implements IRecipeViewerIngredientHelper {
    private final Supplier<MergedTank> mergedTankSupplier;
    private final Supplier<HANDLER> handlerSupplier;
    private final GuiFluidGauge fluidGauge;
    private final GuiChemicalGauge chemicalGauge;
    private Component label;

    public GuiMergedTankGauge(Supplier<MergedTank> mergedTankSupplier, Supplier<HANDLER> handlerSupplier, GaugeType type, IGuiWrapper gui, int x, int y) {
        this(mergedTankSupplier, handlerSupplier, type, gui, x, y, type.getGaugeOverlay().getWidth() + 2, type.getGaugeOverlay().getHeight() + 2);
    }

    public GuiMergedTankGauge(Supplier<MergedTank> mergedTankSupplier, Supplier<HANDLER> handlerSupplier, GaugeType type, IGuiWrapper gui, int x, int y, int width, int height) {
        super(type, gui, x, y, width, height);
        this.mergedTankSupplier = mergedTankSupplier;
        this.handlerSupplier = handlerSupplier;
        this.fluidGauge = this.addPositionOnlyChild(new GuiFluidGauge(() -> this.mergedTankSupplier.get().getFluidTank(), () -> ((IMekanismFluidHandler)this.handlerSupplier.get()).getFluidTanks(null), type, gui, x, y, width, height));
        this.chemicalGauge = this.addPositionOnlyChild(new GuiChemicalGauge(() -> this.mergedTankSupplier.get().getChemicalTank(), () -> ((IMekanismChemicalHandler)((Object)((IMekanismFluidHandler)this.handlerSupplier.get()))).getChemicalTanks(null), type, gui, x, y, width, height));
    }

    public GuiMergedTankGauge<HANDLER> setLabel(Component label) {
        this.label = label;
        return this;
    }

    @Override
    public GaugeOverlay getGaugeOverlay() {
        return this.getCurrentGauge().getGaugeOverlay();
    }

    @Override
    protected GaugeInfo getGaugeColor() {
        return this.getCurrentGauge().getGaugeColor();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        if (currentGauge == null) {
            return this.fluidGauge.mouseClicked(mouseX, mouseY, button) | this.chemicalGauge.mouseClicked(mouseX, mouseY, button);
        }
        return currentGauge.mouseClicked(mouseX, mouseY, button);
    }

    @Override
    protected void applyRenderColor(GuiGraphics guiGraphics) {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        if (currentGauge != null) {
            currentGauge.applyRenderColor(guiGraphics);
        }
    }

    @Override
    public Optional<?> getIngredient(double mouseX, double mouseY) {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        return currentGauge == null ? Optional.empty() : currentGauge.getIngredient(mouseX, mouseY);
    }

    @Override
    public Rect2i getIngredientBounds(double mouseX, double mouseY) {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        return currentGauge == null ? new Rect2i(this.getX() + 1, this.getY() + 1, this.width - 2, this.height - 2) : currentGauge.getIngredientBounds(mouseX, mouseY);
    }

    @Override
    public int getScaledLevel() {
        GuiTankGauge<?, ?> currentGauge = this.getCurrentGaugeNoFallback();
        return currentGauge == null ? 0 : currentGauge.getScaledLevel();
    }

    @Override
    @Nullable
    public TextureAtlasSprite getIcon() {
        return this.getCurrentGauge().getIcon();
    }

    @Override
    public List<Component> getTooltipText() {
        return this.getCurrentGauge().getTooltipText();
    }

    @Override
    public Component getLabel() {
        return this.label;
    }

    @Override
    public TransmissionType getTransmission() {
        return this.getCurrentGauge().getTransmission();
    }

    private GuiTankGauge<?, ?> getCurrentGauge() {
        GuiFluidGauge currentGauge = this.getCurrentGaugeNoFallback();
        return currentGauge == null ? this.fluidGauge : currentGauge;
    }

    @Nullable
    private GuiTankGauge<?, ?> getCurrentGaugeNoFallback() {
        MergedTank mergedTank = this.mergedTankSupplier.get();
        return switch (mergedTank.getCurrentType()) {
            case MergedTank.CurrentType.FLUID -> this.fluidGauge;
            case MergedTank.CurrentType.CHEMICAL -> this.chemicalGauge;
            default -> null;
        };
    }
}

