/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.custom.module;

import mekanism.api.gear.config.ModuleConfig;
import mekanism.client.gui.element.custom.module.GuiModuleScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

abstract class MiniElement<TYPE> {
    protected final GuiModuleScreen parent;
    protected final Component description;
    protected final int xPos;
    protected final int yPos;
    protected ModuleConfig<TYPE> data;

    protected MiniElement(GuiModuleScreen parent, ModuleConfig<TYPE> data, Component description, int xPos, int yPos) {
        this.parent = parent;
        this.data = data;
        this.description = description;
        this.xPos = xPos;
        this.yPos = yPos;
    }

    protected abstract void renderBackground(GuiGraphics var1, int var2, int var3);

    protected abstract void renderForeground(GuiGraphics var1, int var2, int var3);

    protected abstract void click(double var1, double var3);

    protected void release(double mouseX, double mouseY) {
    }

    protected void onDrag(double mouseX, double mouseY, double deltaX, double deltaY) {
    }

    protected abstract int getNeededHeight();

    protected int getRelativeX() {
        return this.parent.getRelativeX() + this.xPos;
    }

    protected int getRelativeY() {
        return this.parent.getRelativeY() + this.yPos;
    }

    protected int getX() {
        return this.parent.getX() + this.xPos;
    }

    protected int getY() {
        return this.parent.getY() + this.yPos;
    }

    protected boolean mouseOver(double mouseX, double mouseY, int relativeX, int relativeY, int width, int height) {
        int x = this.getX();
        int y = this.getY();
        return mouseX >= (double)(x + relativeX) && mouseX < (double)(x + relativeX + width) && mouseY >= (double)(y + relativeY) && mouseY < (double)(y + relativeY + height);
    }

    protected void setData(TYPE value) {
        this.data = this.data.with(value);
        this.parent.saveCallback.accept(this.data);
    }
}

