/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiScalableElement;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.recipe_viewer.interfaces.IRecipeViewerRecipeArea;
import mekanism.client.recipe_viewer.type.IRecipeViewerRecipeType;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiInnerScreen
extends GuiScalableElement
implements IRecipeViewerRecipeArea<GuiInnerScreen> {
    public static final ResourceLocation SCREEN = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "inner_screen.png");
    public static int SCREEN_SIZE = 32;
    private List<Component> lastInfo = Collections.emptyList();
    @Nullable
    private Tooltip lastTooltip;
    private Supplier<List<Component>> renderStrings;
    private Supplier<List<Component>> tooltipStrings;
    private IRecipeViewerRecipeType<?>[] recipeCategories;
    private boolean centerY;
    private int spacing;
    private int padding = 3;
    private float textScale = 1.0f;

    public GuiInnerScreen(IGuiWrapper gui, int x, int y, int width, int height) {
        super(SCREEN, gui, x, y, width, height, SCREEN_SIZE, SCREEN_SIZE);
    }

    public GuiInnerScreen(IGuiWrapper gui, int x, int y, int width, int height, Supplier<List<Component>> renderStrings) {
        this(gui, x, y, width, height);
        this.renderStrings = renderStrings;
        this.defaultFormat();
    }

    public GuiInnerScreen tooltip(Supplier<List<Component>> tooltipStrings) {
        this.tooltipStrings = tooltipStrings;
        this.active = true;
        return this;
    }

    public GuiInnerScreen spacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public GuiInnerScreen clearSpacing() {
        return this.spacing(0);
    }

    public GuiInnerScreen padding(int padding) {
        this.padding = padding;
        return this;
    }

    public GuiInnerScreen clearScale() {
        return this.textScale(1.0f);
    }

    public GuiInnerScreen textScale(float textScale) {
        this.textScale = textScale;
        return this;
    }

    public GuiInnerScreen centerY() {
        this.centerY = true;
        return this;
    }

    public GuiInnerScreen clearFormat() {
        this.centerY = false;
        return this;
    }

    public GuiInnerScreen defaultFormat() {
        return this.padding(5).spacing(2).textScale(0.8f).centerY();
    }

    protected List<Component> getRenderStrings() {
        return this.renderStrings == null ? Collections.emptyList() : this.renderStrings.get();
    }

    @Override
    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.renderForeground(guiGraphics, mouseX, mouseY);
        List<Component> list = this.getRenderStrings();
        if (!list.isEmpty()) {
            Objects.requireNonNull(this.font());
            int lineHeight = 9;
            int minY = this.relativeY + this.padding;
            int maxY = minY + lineHeight;
            int heightToNextLine = lineHeight + this.spacing;
            if (this.centerY) {
                int totalHeight = heightToNextLine * list.size() - this.spacing;
                float center = (float)(this.getHeight() - totalHeight) / 2.0f;
                minY = this.relativeY + Mth.floor((float)center);
                maxY = this.relativeY + lineHeight + Mth.ceil((float)center);
            }
            int minX = this.relativeX + this.padding;
            int screenTextColor = this.screenTextColor();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Component text = list.get(i);
                int maxX = this.relativeX + this.getMaxTextWidth(i) - this.padding;
                this.drawScaledScrollingString(guiGraphics, text, minX, minY, maxX, maxY, IFancyFontRenderer.TextAlignment.LEFT, screenTextColor, false, this.textScale, this.getTimeOpened());
                minY += heightToNextLine;
                maxY += heightToNextLine;
            }
        }
    }

    @Override
    public void updateTooltip(int mouseX, int mouseY) {
        if (this.tooltipStrings != null) {
            List<Component> list = this.tooltipStrings.get();
            if (!list.equals(this.lastInfo)) {
                this.lastInfo = list;
                this.lastTooltip = TooltipUtils.create(list);
            }
        } else {
            this.lastInfo = Collections.emptyList();
            this.lastTooltip = null;
        }
        this.setTooltip(this.lastTooltip);
    }

    protected int getMaxTextWidth(int row) {
        return this.getWidth();
    }

    @Override
    @NotNull
    public GuiInnerScreen recipeViewerCategories(IRecipeViewerRecipeType<?> ... recipeCategories) {
        this.recipeCategories = recipeCategories;
        return this;
    }

    @Override
    @Nullable
    public IRecipeViewerRecipeType<?>[] getRecipeCategories() {
        return this.recipeCategories;
    }

    @Override
    public boolean isMouseOverRecipeViewerArea(double mouseX, double mouseY) {
        return this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)this.getRight() && mouseY < (double)this.getBottom();
    }
}

