/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.security;

import java.util.UUID;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.security.IOwnerObject;
import mekanism.api.security.ISecurityObject;
import mekanism.api.security.ISecurityUtils;
import mekanism.api.security.SecurityMode;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public interface IBlockSecurityUtils {
    public static final IBlockSecurityUtils INSTANCE = MekanismAPI.getService(IBlockSecurityUtils.class);

    public BlockCapability<IOwnerObject, Void> ownerCapability();

    @Nullable
    default public IOwnerObject ownerCapability(Level level, BlockPos pos) {
        return this.ownerCapability(level, pos, null, null);
    }

    @Nullable
    default public IOwnerObject ownerCapability(Level level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        return this.ownerCapability(level, pos, null, blockEntity);
    }

    @Nullable
    default public IOwnerObject ownerCapability(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity) {
        return (IOwnerObject)level.getCapability(this.ownerCapability(), pos, state, blockEntity, null);
    }

    public BlockCapability<ISecurityObject, Void> securityCapability();

    @Nullable
    default public ISecurityObject securityCapability(Level level, BlockPos pos) {
        return this.securityCapability(level, pos, null, null);
    }

    @Nullable
    default public ISecurityObject securityCapability(Level level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        return this.securityCapability(level, pos, null, blockEntity);
    }

    @Nullable
    default public ISecurityObject securityCapability(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity) {
        return (ISecurityObject)level.getCapability(this.securityCapability(), pos, state, blockEntity, null);
    }

    default public boolean canAccess(Player player, Level level, BlockPos pos) {
        return this.canAccess(player, level, pos, null, null);
    }

    default public boolean canAccess(Player player, Level level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        return this.canAccess(player, level, pos, null, blockEntity);
    }

    public boolean canAccess(Player var1, Level var2, BlockPos var3, @Nullable BlockState var4, @Nullable BlockEntity var5);

    default public boolean canAccess(@Nullable UUID player, Level level, BlockPos pos) {
        return this.canAccess(player, level, pos, null, null);
    }

    default public boolean canAccess(@Nullable UUID player, Level level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        return this.canAccess(player, level, pos, null, blockEntity);
    }

    public boolean canAccess(@Nullable UUID var1, Level var2, BlockPos var3, @Nullable BlockState var4, @Nullable BlockEntity var5);

    @Nullable
    default public UUID getOwnerUUID(Level level, BlockPos pos) {
        return this.getOwnerUUID(level, pos, null, null);
    }

    @Nullable
    default public UUID getOwnerUUID(Level level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        return this.getOwnerUUID(level, pos, null, blockEntity);
    }

    @Nullable
    default public UUID getOwnerUUID(Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity) {
        IOwnerObject ownerObject = (IOwnerObject)level.getCapability(this.ownerCapability(), pos, state, blockEntity, null);
        return ownerObject == null ? null : ownerObject.getOwnerUUID();
    }

    default public SecurityMode getSecurityMode(Level level, BlockPos pos) {
        return this.getSecurityMode(level, pos, null, null);
    }

    default public SecurityMode getSecurityMode(Level level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        return this.getSecurityMode(level, pos, null, blockEntity);
    }

    public SecurityMode getSecurityMode(Level var1, BlockPos var2, @Nullable BlockState var3, @Nullable BlockEntity var4);

    default public boolean canAccessOrDisplayError(Player player, Level level, BlockPos pos) {
        return this.canAccessOrDisplayError(player, level, pos, null, null);
    }

    default public boolean canAccessOrDisplayError(Player player, Level level, BlockPos pos, @Nullable BlockEntity blockEntity) {
        return this.canAccessOrDisplayError(player, level, pos, null, blockEntity);
    }

    default public boolean canAccessOrDisplayError(Player player, Level level, BlockPos pos, @Nullable BlockState state, @Nullable BlockEntity blockEntity) {
        if (this.canAccess(player, level, pos, state, blockEntity)) {
            return true;
        }
        if (!level.isClientSide) {
            ISecurityUtils.INSTANCE.displayNoAccess(player);
        }
        return false;
    }
}

