/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.creator;

import java.util.Arrays;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.providers.IFluidProvider;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.ingredients.creator.IIngredientCreator;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.CompoundFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.DataComponentFluidIngredient;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

@NothingNullByDefault
public interface IFluidStackIngredientCreator
extends IIngredientCreator<Fluid, FluidStack, FluidStackIngredient> {
    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    default public FluidStackIngredient from(IFluidProvider provider, int amount) {
        Objects.requireNonNull(provider, "FluidStackIngredients cannot be created from a null fluid provider.");
        return this.from(provider.getFluidStack(amount));
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public FluidStackIngredient from(int amount, IFluidProvider ... fluids) {
        return this.from(CompoundFluidIngredient.of(Arrays.stream(fluids).map(IFluidProvider::getFluid).map(FluidIngredient::single)), amount);
    }

    @Override
    default public FluidStackIngredient fromHolders(int amount, Holder<Fluid> ... fluids) {
        if (fluids.length == 0) {
            throw new IllegalArgumentException("Attempted to create a FluidStackIngredient with no fluids.");
        }
        return this.from(CompoundFluidIngredient.of(Arrays.stream(fluids).map(FluidIngredient::single)), amount);
    }

    @Override
    @Deprecated(forRemoval=true, since="10.7.11")
    default public FluidStackIngredient from(Fluid instance, int amount) {
        return this.from(SizedFluidIngredient.of((Fluid)instance, (int)amount));
    }

    @Override
    default public FluidStackIngredient fromHolder(Holder<Fluid> instance, int amount) {
        return this.from(FluidIngredient.single(instance), amount);
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    default public FluidStackIngredient from(int amount, Fluid ... fluids) {
        if (fluids.length == 0) {
            throw new IllegalArgumentException("Attempted to create an FluidStackIngredient with no fluids.");
        }
        return this.from(FluidIngredient.of((Fluid[])fluids), amount);
    }

    @Override
    default public FluidStackIngredient from(FluidStack instance) {
        Objects.requireNonNull(instance, "FluidStackIngredients cannot be created from a null FluidStack.");
        if (instance.isEmpty()) {
            throw new IllegalArgumentException("FluidStackIngredients cannot be created using the empty stack.");
        }
        DataComponentPredicate predicate = IngredientCreatorAccess.getComponentPatchPredicate((instance = instance.copy()).getComponentsPatch());
        if (predicate != null) {
            return this.from(DataComponentFluidIngredient.of((boolean)false, (DataComponentPredicate)predicate, (Holder[])new Holder[]{instance.getFluidHolder()}), instance.getAmount());
        }
        return this.from(SizedFluidIngredient.of((FluidStack)instance));
    }

    @Override
    default public FluidStackIngredient from(TagKey<Fluid> tag, int amount) {
        Objects.requireNonNull(tag, "FluidStackIngredients cannot be created from a null tag.");
        return this.from(SizedFluidIngredient.of(tag, (int)amount));
    }

    @Override
    default public FluidStackIngredient from(FluidIngredient ingredient, int amount) {
        Objects.requireNonNull(ingredient, "FluidStackIngredients cannot be created from a null fluid ingredient.");
        return this.from(new SizedFluidIngredient(ingredient, amount));
    }

    @Override
    default public FluidStackIngredient from(SizedFluidIngredient ingredient) {
        return FluidStackIngredient.of(ingredient);
    }
}

