/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Holder;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public non-sealed class DifferenceChemicalIngredient
extends ChemicalIngredient {
    public static final MapCodec<DifferenceChemicalIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)IngredientCreatorAccess.chemical().codecNonEmpty().fieldOf("base").forGetter(DifferenceChemicalIngredient::base), (App)IngredientCreatorAccess.chemical().codecNonEmpty().fieldOf("subtracted").forGetter(DifferenceChemicalIngredient::subtracted)).apply((Applicative)builder, DifferenceChemicalIngredient::new));
    private final ChemicalIngredient base;
    private final ChemicalIngredient subtracted;

    public DifferenceChemicalIngredient(ChemicalIngredient base, ChemicalIngredient subtracted) {
        this.base = base;
        this.subtracted = subtracted;
    }

    @Override
    public final Stream<Holder<Chemical>> generateChemicalHolders() {
        return this.base().generateChemicalHolders().filter(holder -> !this.subtracted().test((Holder<Chemical>)holder));
    }

    @Override
    public MapCodec<? extends ChemicalIngredient> codec() {
        return CODEC;
    }

    @Override
    public final boolean test(Holder<Chemical> chemical) {
        return this.base().test(chemical) && !this.subtracted().test(chemical);
    }

    public final ChemicalIngredient base() {
        return this.base;
    }

    public final ChemicalIngredient subtracted() {
        return this.subtracted;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.base, this.subtracted);
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DifferenceChemicalIngredient other = (DifferenceChemicalIngredient)obj;
        return this.base.equals(other.base) && this.subtracted.equals(other.subtracted);
    }
}

