/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.ingredients.chemical;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.stream.Stream;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.recipes.ingredients.chemical.ChemicalIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import net.minecraft.core.Holder;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public non-sealed class CompoundChemicalIngredient
extends ChemicalIngredient {
    public static final MapCodec<CompoundChemicalIngredient> CODEC = NeoForgeExtraCodecs.aliasedFieldOf(IngredientCreatorAccess.chemical().listCodecMultipleElements(), (String[])new String[]{"children", "ingredients"}).xmap(CompoundChemicalIngredient::new, CompoundChemicalIngredient::children);
    private final List<ChemicalIngredient> children;

    public CompoundChemicalIngredient(List<ChemicalIngredient> children) {
        if (children.size() < 2) {
            throw new IllegalArgumentException("Compound chemical ingredients must have at least two children");
        }
        this.children = children;
    }

    @Override
    public final Stream<Holder<Chemical>> generateChemicalHolders() {
        return this.children().stream().flatMap(ChemicalIngredient::generateChemicalHolders).distinct();
    }

    @Override
    public final boolean test(Holder<Chemical> chemical) {
        for (ChemicalIngredient child : this.children()) {
            if (!child.test(chemical)) continue;
            return true;
        }
        return false;
    }

    public final List<ChemicalIngredient> children() {
        return this.children;
    }

    @Override
    public MapCodec<? extends ChemicalIngredient> codec() {
        return CODEC;
    }

    @Override
    public int hashCode() {
        return this.children.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.children.equals(((CompoundChemicalIngredient)obj).children);
    }
}

