/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.CachedRecipeHelper;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.FluidStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class RotaryCachedRecipe
extends CachedRecipe<RotaryRecipe> {
    private final IOutputHandler<@NotNull ChemicalStack> chemicalOutputHandler;
    private final IOutputHandler<@NotNull FluidStack> fluidOutputHandler;
    private final IInputHandler<@NotNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NotNull ChemicalStack> chemicalInputHandler;
    private final BooleanSupplier modeSupplier;
    private final Consumer<FluidStack> fluidInputSetter;
    private final Consumer<ChemicalStack> chemicalInputSetter;
    private final Consumer<FluidStack> fluidOutputSetter;
    private final Consumer<ChemicalStack> chemicalOutputSetter;
    private final Supplier<FluidStackIngredient> fluidInputGetter;
    private final Supplier<ChemicalStackIngredient> chemicalInputGetter;
    private final Function<ChemicalStack, FluidStack> fluidOutputGetter;
    private final Function<FluidStack, ChemicalStack> chemicalOutputGetter;
    private FluidStack recipeFluid = FluidStack.EMPTY;
    private ChemicalStack recipeChemical = ChemicalStack.EMPTY;
    private FluidStack fluidOutput = FluidStack.EMPTY;
    private ChemicalStack chemicalOutput = ChemicalStack.EMPTY;

    public RotaryCachedRecipe(RotaryRecipe recipe, BooleanSupplier recheckAllErrors, IInputHandler<@NotNull FluidStack> fluidInputHandler, IInputHandler<@NotNull ChemicalStack> chemicalInputHandler, IOutputHandler<@NotNull ChemicalStack> chemicalOutputHandler, IOutputHandler<@NotNull FluidStack> fluidOutputHandler, BooleanSupplier modeSupplier) {
        super(recipe, recheckAllErrors);
        this.fluidInputHandler = Objects.requireNonNull(fluidInputHandler, "Fluid input handler cannot be null.");
        this.chemicalInputHandler = Objects.requireNonNull(chemicalInputHandler, "Chemical input handler cannot be null.");
        this.chemicalOutputHandler = Objects.requireNonNull(chemicalOutputHandler, "Chemical output handler cannot be null.");
        this.fluidOutputHandler = Objects.requireNonNull(fluidOutputHandler, "Fluid output handler cannot be null.");
        this.modeSupplier = Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null.");
        this.fluidInputSetter = input -> {
            this.recipeFluid = input;
        };
        this.chemicalInputSetter = input -> {
            this.recipeChemical = input;
        };
        this.fluidOutputSetter = output -> {
            this.fluidOutput = output;
        };
        this.chemicalOutputSetter = output -> {
            this.chemicalOutput = output;
        };
        this.fluidInputGetter = ((RotaryRecipe)this.recipe)::getFluidInput;
        this.chemicalInputGetter = ((RotaryRecipe)this.recipe)::getChemicalInput;
        this.fluidOutputGetter = ((RotaryRecipe)this.recipe)::getFluidOutput;
        this.chemicalOutputGetter = ((RotaryRecipe)this.recipe)::getChemicalOutput;
    }

    @Override
    protected void calculateOperationsThisTick(CachedRecipe.OperationTracker tracker) {
        super.calculateOperationsThisTick(tracker);
        if (tracker.shouldContinueChecking()) {
            if (this.modeSupplier.getAsBoolean()) {
                if (!((RotaryRecipe)this.recipe).hasFluidToChemical()) {
                    tracker.mismatchedRecipe();
                } else {
                    CachedRecipeHelper.oneInputCalculateOperationsThisTick(tracker, this.fluidInputHandler, this.fluidInputGetter, this.fluidInputSetter, this.chemicalOutputHandler, this.chemicalOutputGetter, this.chemicalOutputSetter, ConstantPredicates.FLUID_EMPTY);
                }
            } else if (!((RotaryRecipe)this.recipe).hasChemicalToFluid()) {
                tracker.mismatchedRecipe();
            } else {
                CachedRecipeHelper.oneInputCalculateOperationsThisTick(tracker, this.chemicalInputHandler, this.chemicalInputGetter, this.chemicalInputSetter, this.fluidOutputHandler, this.fluidOutputGetter, this.fluidOutputSetter, ConstantPredicates.CHEMICAL_EMPTY);
            }
        }
    }

    @Override
    public boolean isInputValid() {
        if (this.modeSupplier.getAsBoolean()) {
            if (!((RotaryRecipe)this.recipe).hasFluidToChemical()) {
                return false;
            }
            FluidStack fluidStack = this.fluidInputHandler.getInput();
            return !fluidStack.isEmpty() && ((RotaryRecipe)this.recipe).test(fluidStack);
        }
        if (!((RotaryRecipe)this.recipe).hasChemicalToFluid()) {
            return false;
        }
        ChemicalStack chemicalStack = this.chemicalInputHandler.getInput();
        return !chemicalStack.isEmpty() && ((RotaryRecipe)this.recipe).test(chemicalStack);
    }

    @Override
    protected void finishProcessing(int operations) {
        if (this.modeSupplier.getAsBoolean()) {
            if (((RotaryRecipe)this.recipe).hasFluidToChemical() && !this.recipeFluid.isEmpty() && !this.chemicalOutput.isEmpty()) {
                this.fluidInputHandler.use(this.recipeFluid, operations);
                this.chemicalOutputHandler.handleOutput(this.chemicalOutput, operations);
            }
        } else if (((RotaryRecipe)this.recipe).hasChemicalToFluid() && !this.recipeChemical.isEmpty() && !this.fluidOutput.isEmpty()) {
            this.chemicalInputHandler.use(this.recipeChemical, operations);
            this.fluidOutputHandler.handleOutput(this.fluidOutput, operations);
        }
    }
}

