/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public class BasicSawmillRecipe
extends SawmillRecipe {
    protected final ItemStackIngredient input;
    protected final ItemStack mainOutput;
    protected final ItemStack secondaryOutput;
    protected final double secondaryChance;

    public BasicSawmillRecipe(ItemStackIngredient input, ItemStack mainOutput, ItemStack secondaryOutput, double secondaryChance) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(mainOutput, "Main output cannot be null.");
        Objects.requireNonNull(secondaryOutput, "Secondary output cannot be null.");
        if (mainOutput.isEmpty() && secondaryOutput.isEmpty()) {
            throw new IllegalArgumentException("At least one output must not be empty.");
        }
        if (secondaryChance < 0.0 || secondaryChance > 1.0) {
            throw new IllegalArgumentException("Secondary output chance must be at least zero and at most one.");
        }
        if (mainOutput.isEmpty()) {
            if (secondaryChance == 0.0 || secondaryChance == 1.0) {
                throw new IllegalArgumentException("Secondary output must have a chance greater than zero and less than one.");
            }
        } else if (secondaryOutput.isEmpty() && secondaryChance != 0.0) {
            throw new IllegalArgumentException("If there is no secondary output, the chance of getting the secondary output should be zero.");
        }
        this.mainOutput = mainOutput.copy();
        this.secondaryOutput = secondaryOutput.copy();
        this.secondaryChance = secondaryChance;
    }

    @Override
    public boolean test(ItemStack stack) {
        return this.input.test(stack);
    }

    @Override
    @Contract(value="_ -> new")
    public SawmillRecipe.ChanceOutput getOutput(ItemStack input) {
        return new BasicChanceOutput(this.secondaryChance > 0.0 ? RANDOM.nextDouble() : 0.0);
    }

    @Override
    public List<ItemStack> getMainOutputDefinition() {
        return this.mainOutput.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.mainOutput);
    }

    @Override
    public List<ItemStack> getSecondaryOutputDefinition() {
        return this.secondaryOutput.isEmpty() ? Collections.emptyList() : Collections.singletonList(this.secondaryOutput);
    }

    @Override
    public double getSecondaryChance() {
        return this.secondaryChance;
    }

    @Override
    public ItemStackIngredient getInput() {
        return this.input;
    }

    public Optional<ItemStack> getMainOutputRaw() {
        return this.mainOutput.isEmpty() ? Optional.empty() : Optional.of(this.mainOutput);
    }

    public Optional<ItemStack> getSecondaryOutputRaw() {
        return this.secondaryOutput.isEmpty() ? Optional.empty() : Optional.of(this.secondaryOutput);
    }

    public RecipeSerializer<BasicSawmillRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.SAWING.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicSawmillRecipe other = (BasicSawmillRecipe)o;
        return this.secondaryChance == other.secondaryChance && this.input.equals(other.input) && ItemStack.matches((ItemStack)this.mainOutput, (ItemStack)other.mainOutput) && ItemStack.matches((ItemStack)this.secondaryOutput, (ItemStack)other.secondaryOutput);
    }

    public int hashCode() {
        int hash = Objects.hash(this.input, this.secondaryChance);
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.mainOutput);
        hash = 31 * hash + this.mainOutput.getCount();
        if (!this.secondaryOutput.isEmpty()) {
            hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.secondaryOutput);
            hash = 31 * hash + this.secondaryOutput.getCount();
        }
        return hash;
    }

    public class BasicChanceOutput
    implements SawmillRecipe.ChanceOutput {
        protected final double rand;

        protected BasicChanceOutput(double rand) {
            this.rand = rand;
        }

        @Override
        public ItemStack getMainOutput() {
            return BasicSawmillRecipe.this.mainOutput.copy();
        }

        @Override
        public ItemStack getMaxSecondaryOutput() {
            return BasicSawmillRecipe.this.secondaryChance > 0.0 ? BasicSawmillRecipe.this.secondaryOutput.copy() : ItemStack.EMPTY;
        }

        @Override
        public ItemStack getSecondaryOutput() {
            if (this.rand <= BasicSawmillRecipe.this.secondaryChance) {
                return BasicSawmillRecipe.this.secondaryOutput.copy();
            }
            return ItemStack.EMPTY;
        }

        @Override
        public ItemStack nextSecondaryOutput() {
            double rand;
            if (BasicSawmillRecipe.this.secondaryChance > 0.0 && (rand = RANDOM.nextDouble()) <= BasicSawmillRecipe.this.secondaryChance) {
                return BasicSawmillRecipe.this.secondaryOutput.copy();
            }
            return ItemStack.EMPTY;
        }
    }
}

