/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.basic.IBasicItemStackOutput;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicNucleosynthesizingRecipe
extends NucleosynthesizingRecipe
implements IBasicItemStackOutput {
    protected final ItemStackIngredient itemInput;
    protected final ChemicalStackIngredient chemicalInput;
    protected final ItemStack output;
    private final int duration;
    private final boolean perTickUsage;

    public BasicNucleosynthesizingRecipe(ItemStackIngredient itemInput, ChemicalStackIngredient chemicalInput, ItemStack output, int duration, boolean perTickUsage) {
        this.itemInput = Objects.requireNonNull(itemInput, "Item input cannot be null.");
        this.chemicalInput = Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
        if (duration <= 0) {
            throw new IllegalArgumentException("Duration must be a number greater than zero.");
        }
        this.duration = duration;
        this.perTickUsage = perTickUsage;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public boolean perTickUsage() {
        return this.perTickUsage;
    }

    @Override
    public ItemStackIngredient getItemInput() {
        return this.itemInput;
    }

    @Override
    public ChemicalStackIngredient getChemicalInput() {
        return this.chemicalInput;
    }

    @Override
    @Contract(value="_, _ -> new", pure=true)
    public ItemStack getOutput(ItemStack inputItem, ChemicalStack inputChemical) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @Override
    public boolean test(ItemStack itemStack, ChemicalStack chemicalStack) {
        return this.itemInput.test(itemStack) && this.chemicalInput.test(chemicalStack);
    }

    @Override
    public List<@NotNull ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public ItemStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicNucleosynthesizingRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.NUCLEOSYNTHESIZING.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicNucleosynthesizingRecipe other = (BasicNucleosynthesizingRecipe)o;
        return this.duration == other.duration && this.perTickUsage == other.perTickUsage && this.itemInput.equals(other.itemInput) && this.chemicalInput.equals(other.chemicalInput) && ItemStack.matches((ItemStack)this.output, (ItemStack)other.output);
    }

    public int hashCode() {
        int hash = Objects.hash(this.itemInput, this.chemicalInput, this.duration, this.perTickUsage);
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.output);
        hash = 31 * hash + this.output.getCount();
        return hash;
    }
}

