/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.basic;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalCrystallizerRecipe;
import mekanism.api.recipes.MekanismRecipeSerializers;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@NothingNullByDefault
public class BasicChemicalCrystallizerRecipe
extends ChemicalCrystallizerRecipe {
    protected final ChemicalStackIngredient input;
    protected final ItemStack output;

    public BasicChemicalCrystallizerRecipe(ChemicalStackIngredient input, ItemStack output) {
        this.input = Objects.requireNonNull(input, "Input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (output.isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = output.copy();
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    public ItemStack getOutput(ChemicalStack input) {
        return this.output.copy();
    }

    @Override
    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    @Override
    public List<ItemStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public boolean test(ChemicalStack stack) {
        return this.input.test(stack);
    }

    @Override
    public boolean testType(ChemicalStack stack) {
        return this.input.testType(stack);
    }

    @Override
    public ChemicalStackIngredient getInput() {
        return this.input;
    }

    public ItemStack getOutputRaw() {
        return this.output;
    }

    public RecipeSerializer<BasicChemicalCrystallizerRecipe> getSerializer() {
        return (RecipeSerializer)MekanismRecipeSerializers.CRYSTALLIZING.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicChemicalCrystallizerRecipe other = (BasicChemicalCrystallizerRecipe)o;
        return this.input.equals(other.input) && ItemStack.matches((ItemStack)this.output, (ItemStack)other.output);
    }

    public int hashCode() {
        int hash = this.input.hashCode();
        hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.output);
        hash = 31 * hash + this.output.getCount();
        return hash;
    }
}

