/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@NothingNullByDefault
public abstract class ItemStackToFluidOptionalItemRecipe
extends MekanismRecipe<SingleRecipeInput>
implements Predicate<ItemStack> {
    @Override
    public abstract boolean test(ItemStack var1);

    public boolean matches(SingleRecipeInput input, Level level) {
        return !this.isIncomplete() && this.test(input.item());
    }

    public abstract ItemStackIngredient getInput();

    @Contract(value="_ -> new", pure=true)
    public abstract FluidOptionalItemOutput getOutput(ItemStack var1);

    public abstract List<FluidOptionalItemOutput> getOutputDefinition();

    @Override
    public boolean isIncomplete() {
        return this.getInput().hasNoMatchingInstances();
    }

    public record FluidOptionalItemOutput(FluidStack fluid, ItemStack optionalItem) {
        public static final Codec<FluidOptionalItemOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)FluidStack.CODEC.fieldOf("fluid").forGetter(FluidOptionalItemOutput::fluid), (App)ItemStack.CODEC.optionalFieldOf("item", (Object)ItemStack.EMPTY).forGetter(FluidOptionalItemOutput::optionalItem)).apply((Applicative)instance, FluidOptionalItemOutput::new));

        public FluidOptionalItemOutput {
            Objects.requireNonNull(fluid, "Fluid output cannot be null.");
            Objects.requireNonNull(optionalItem, "Item output cannot be null.");
            if (fluid.isEmpty()) {
                throw new IllegalArgumentException("Fluid output cannot be empty.");
            }
        }

        public FluidOptionalItemOutput copy() {
            return new FluidOptionalItemOutput(this.fluid.copy(), this.optionalItem.copy());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FluidOptionalItemOutput other = (FluidOptionalItemOutput)o;
            return FluidStack.matches((FluidStack)this.fluid, (FluidStack)other.fluid) && ItemStack.matches((ItemStack)this.optionalItem, (ItemStack)other.optionalItem);
        }

        @Override
        public int hashCode() {
            int hash = FluidStack.hashFluidAndComponents((FluidStack)this.fluid);
            hash = 31 * hash + this.fluid.getAmount();
            if (!this.optionalItem.isEmpty()) {
                hash = 31 * hash + ItemStack.hashItemAndComponents((ItemStack)this.optionalItem);
                hash = 31 * hash + this.optionalItem.getCount();
            }
            return hash;
        }
    }
}

