/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api;

import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.structure.Structure;

@NothingNullByDefault
public class MekanismAPITags {
    private static final ResourceLocation HIDDEN_RL = ResourceLocation.fromNamespaceAndPath((String)"c", (String)"hidden_from_recipe_viewers");

    private MekanismAPITags() {
    }

    private static ResourceLocation rl(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"mekanism", (String)path);
    }

    public static class Structures {
        public static final TagKey<Structure> BLACKLIST_BABY_BOGGED = Structures.additionsTag("blacklist_baby_bogged");
        public static final TagKey<Structure> BLACKLIST_BABY_CREEPERS = Structures.additionsTag("blacklist_baby_creepers");
        public static final TagKey<Structure> BLACKLIST_BABY_ENDERMEN = Structures.additionsTag("blacklist_baby_endermen");
        public static final TagKey<Structure> BLACKLIST_BABY_SKELETONS = Structures.additionsTag("blacklist_baby_skeletons");
        public static final TagKey<Structure> BLACKLIST_BABY_STRAYS = Structures.additionsTag("blacklist_baby_strays");
        public static final TagKey<Structure> BLACKLIST_BABY_WITHER_SKELETONS = Structures.additionsTag("blacklist_baby_wither_skeletons");

        private Structures() {
        }

        private static TagKey<Structure> additionsTag(String name) {
            return TagKey.create((ResourceKey)Registries.STRUCTURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanismadditions", (String)name));
        }
    }

    public static class MobEffects {
        public static final TagKey<MobEffect> SPEED_UP_BLACKLIST = MobEffects.tag("speed_up_blacklist");

        private MobEffects() {
        }

        private static TagKey<MobEffect> tag(String name) {
            return TagKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class Items {
        public static final TagKey<Item> MEKA_UNITS = Items.tag("unit");

        private Items() {
        }

        private static TagKey<Item> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class Entities {
        public static final TagKey<EntityType<?>> RADIATION_IMMUNE = Entities.commonTag("radiation_immune");
        public static final TagKey<EntityType<?>> MEK_RADIATION_IMMUNE = Entities.tag("radiation_immune");

        private Entities() {
        }

        private static TagKey<EntityType<?>> commonTag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        private static TagKey<EntityType<?>> tag(String name) {
            return TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class DimensionTypes {
        public static final TagKey<DimensionType> NO_WIND = DimensionTypes.commonTag("no_wind");

        private DimensionTypes() {
        }

        private static TagKey<DimensionType> commonTag(String name) {
            return TagKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class DamageTypes {
        public static final TagKey<DamageType> MEKASUIT_ALWAYS_SUPPORTED = DamageTypes.tag("mekasuit_always_supported");
        public static final TagKey<DamageType> IS_PREVENTABLE_MAGIC = DamageTypes.tag("is_preventable_magic");

        private DamageTypes() {
        }

        private static TagKey<DamageType> tag(String name) {
            return TagKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class Chemicals {
        public static final TagKey<Chemical> HIDDEN_FROM_RECIPE_VIEWERS = TagKey.create(MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)HIDDEN_RL);
        public static final TagKey<Chemical> WASTE_BARREL_DECAY_BLACKLIST = Chemicals.tag("waste_barrel_decay_blacklist");
        public static final TagKey<Chemical> GASEOUS = Chemicals.tag("gaseous");
        public static final TagKey<Chemical> CARBON = Chemicals.tag("carbon");
        public static final TagKey<Chemical> REDSTONE = Chemicals.tag("redstone");
        public static final TagKey<Chemical> DIAMOND = Chemicals.tag("diamond");
        public static final TagKey<Chemical> REFINED_OBSIDIAN = Chemicals.tag("refined_obsidian");
        public static final TagKey<Chemical> BIO = Chemicals.tag("bio");
        public static final TagKey<Chemical> FUNGI = Chemicals.tag("fungi");
        public static final TagKey<Chemical> GOLD = Chemicals.tag("gold");
        public static final TagKey<Chemical> TIN = Chemicals.tag("tin");
        public static final TagKey<Chemical> DIRTY = Chemicals.tag("dirty");
        public static final TagKey<Chemical> CLEAN = Chemicals.tag("clean");
        public static final TagKey<Chemical> FRAMEDBLOCKS_BLACKLISTED = Chemicals.tag("framedblocks_blacklisted");

        private Chemicals() {
        }

        private static TagKey<Chemical> tag(String name) {
            return TagKey.create(MekanismAPI.CHEMICAL_REGISTRY_NAME, (ResourceLocation)MekanismAPITags.rl(name));
        }
    }

    public static class Biomes {
        public static final TagKey<Biome> BLACKLIST_BABY_BOGGED = Biomes.additionsTag("blacklist_baby_bogged");
        public static final TagKey<Biome> BLACKLIST_BABY_CREEPERS = Biomes.additionsTag("blacklist_baby_creepers");
        public static final TagKey<Biome> BLACKLIST_BABY_ENDERMEN = Biomes.additionsTag("blacklist_baby_endermen");
        public static final TagKey<Biome> BLACKLIST_BABY_SKELETONS = Biomes.additionsTag("blacklist_baby_skeletons");
        public static final TagKey<Biome> BLACKLIST_BABY_STRAYS = Biomes.additionsTag("blacklist_baby_strays");
        public static final TagKey<Biome> BLACKLIST_BABY_WITHER_SKELETONS = Biomes.additionsTag("blacklist_baby_wither_skeletons");

        private Biomes() {
        }

        private static TagKey<Biome> additionsTag(String name) {
            return TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"mekanismadditions", (String)name));
        }
    }
}

