/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.network.UpdateLidControllerMessage;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.puzzleslib.api.container.v1.ListBackedContainer;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.gameevent.GameEvent;

public class LinkedChestOpenersCounter {
    private final Predicate<NonNullList<ItemStack>> containerChecker;
    private int openCount;
    private boolean scheduleRecheck;

    public LinkedChestOpenersCounter(Predicate<NonNullList<ItemStack>> containerChecker) {
        this.containerChecker = containerChecker;
    }

    protected void openerCountChanged(DyeChannel dyeChannel, MinecraftServer server, int openCount) {
        LinkedChests.NETWORK.sendMessage(PlayerSet.ofAll((MinecraftServer)server), (ClientboundMessage)new UpdateLidControllerMessage(dyeChannel, openCount > 0));
    }

    protected boolean isOwnContainer(Player player) {
        ListBackedContainer container;
        ChestMenu chestMenu;
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        return abstractContainerMenu instanceof ChestMenu && (abstractContainerMenu = (chestMenu = (ChestMenu)abstractContainerMenu).getContainer()) instanceof ListBackedContainer && this.containerChecker.test((NonNullList<ItemStack>)(container = (ListBackedContainer)abstractContainerMenu).getContainerItems());
    }

    public void incrementOpeners(DyeChannel dyeChannel, ServerPlayer serverPlayer) {
        this.incrementOpeners(dyeChannel, serverPlayer, serverPlayer.blockPosition(), serverPlayer.getSoundSource());
    }

    public void incrementOpeners(DyeChannel dyeChannel, ServerPlayer serverPlayer, BlockPos pos, SoundSource soundSource) {
        ServerLevel serverLevel = serverPlayer.serverLevel();
        if (this.openCount++ == 0) {
            serverLevel.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENDER_CHEST_OPEN, soundSource, 0.5f, serverLevel.random.nextFloat() * 0.1f + 0.9f);
            serverLevel.gameEvent((Entity)serverPlayer, (Holder)GameEvent.CONTAINER_OPEN, pos);
            this.scheduleRecheck = true;
        }
        this.openerCountChanged(dyeChannel, serverLevel.getServer(), this.openCount);
    }

    public void decrementOpeners(DyeChannel dyeChannel, ServerPlayer serverPlayer) {
        this.decrementOpeners(dyeChannel, serverPlayer, serverPlayer.blockPosition(), serverPlayer.getSoundSource());
    }

    public void decrementOpeners(DyeChannel dyeChannel, ServerPlayer serverPlayer, BlockPos pos, SoundSource soundSource) {
        ServerLevel serverLevel = serverPlayer.serverLevel();
        if (--this.openCount == 0) {
            serverLevel.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.ENDER_CHEST_CLOSE, soundSource, 0.5f, serverLevel.random.nextFloat() * 0.1f + 0.9f);
            serverLevel.gameEvent((Entity)serverPlayer, (Holder)GameEvent.CONTAINER_CLOSE, pos);
        }
        this.openerCountChanged(dyeChannel, serverLevel.getServer(), this.openCount);
    }

    public void recheckOpeners(DyeChannel dyeChannel, MinecraftServer server) {
        if (this.scheduleRecheck) {
            this.scheduleRecheck = false;
            int playersWithContainerOpen = this.getPlayersWithContainerOpen(server).size();
            if (this.openCount != playersWithContainerOpen) {
                this.openCount = playersWithContainerOpen;
                this.openerCountChanged(dyeChannel, server, playersWithContainerOpen);
            }
            if (this.openCount > 0) {
                this.scheduleRecheck = true;
            }
        }
    }

    private List<? extends Player> getPlayersWithContainerOpen(MinecraftServer server) {
        return server.getPlayerList().getPlayers().stream().filter(this::isOwnContainer).toList();
    }
}

