/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.config.ServerConfig;
import fuzs.linkedchests.world.level.block.entity.DyeChannelStorage;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public record DyeChannel(DyeColor leftColor, DyeColor middleColor, DyeColor rightColor, Optional<UUID> uuid) {
    public static final DyeChannel DEFAULT = new DyeChannel(DyeColor.WHITE);
    public static final Codec<DyeChannel> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DyeColor.CODEC.listOf().validate(list -> Util.fixedSize((List)list, (int)3)).fieldOf("colors").forGetter(dyeChannel -> List.of(dyeChannel.leftColor, dyeChannel.middleColor, dyeChannel.rightColor)), (App)UUIDUtil.CODEC.optionalFieldOf("uuid").forGetter(DyeChannel::uuid)).apply((Applicative)instance, (colors, uuid) -> new DyeChannel((DyeColor)colors.get(0), (DyeColor)colors.get(1), (DyeColor)colors.get(2), (Optional<UUID>)uuid)));
    public static final StreamCodec<ByteBuf, DyeChannel> STREAM_CODEC = StreamCodec.composite((StreamCodec)DyeColor.STREAM_CODEC, DyeChannel::leftColor, (StreamCodec)DyeColor.STREAM_CODEC, DyeChannel::middleColor, (StreamCodec)DyeColor.STREAM_CODEC, DyeChannel::rightColor, (StreamCodec)UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), DyeChannel::uuid, DyeChannel::new);

    public DyeChannel(DyeColor dyeColor) {
        this(dyeColor, dyeColor, dyeColor, Optional.empty());
    }

    public DyeChannel withColorAt(int index, DyeColor dyeColor) {
        return switch (index) {
            case 0 -> this.withLeftColor(dyeColor);
            case 1 -> this.withMiddleColor(dyeColor);
            case 2 -> this.withRightColor(dyeColor);
            default -> throw new RuntimeException();
        };
    }

    public DyeChannel withLeftColor(DyeColor leftColor) {
        if (leftColor != this.leftColor) {
            return new DyeChannel(leftColor, this.middleColor, this.rightColor, this.uuid);
        }
        return this;
    }

    public DyeChannel withMiddleColor(DyeColor middleColor) {
        if (middleColor != this.middleColor) {
            return new DyeChannel(this.leftColor, middleColor, this.rightColor, this.uuid);
        }
        return this;
    }

    public DyeChannel withRightColor(DyeColor rightColor) {
        if (rightColor != this.rightColor) {
            return new DyeChannel(this.leftColor, this.middleColor, rightColor, this.uuid);
        }
        return this;
    }

    public DyeChannel withUUID(@Nullable UUID uuid) {
        return new DyeChannel(this.leftColor, this.middleColor, this.rightColor, Optional.ofNullable(uuid));
    }

    public DyeChannelStorage createStorage() {
        return new DyeChannelStorage(DyeChannel.getContainerSize(this.uuid.isPresent()));
    }

    public static int getContainerSize(boolean personalChannel) {
        int inventoryRows = personalChannel ? ((ServerConfig)LinkedChests.CONFIG.get(ServerConfig.class)).personalInventoryRows : ((ServerConfig)LinkedChests.CONFIG.get(ServerConfig.class)).inventoryRows;
        return inventoryRows * 9;
    }

    public static DyeColor getDyeColor(Item item) {
        DyeColor dyeColor;
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            dyeColor = dyeItem.getDyeColor();
        } else {
            dyeColor = DyeColor.WHITE;
        }
        return dyeColor;
    }
}

