/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.level.block;

import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.level.block.HighlightShapeProvider;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.LinkedChestBlockEntity;
import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.puzzleslib.api.shape.v1.ShapesHelper;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LinkedChestBlock
extends EnderChestBlock
implements HighlightShapeProvider {
    public static final MapCodec<EnderChestBlock> CODEC = LinkedChestBlock.simpleCodec(LinkedChestBlock::new);
    static final VoxelShape LEFT_BUTTON_SHAPE = Block.box((double)4.0, (double)14.0, (double)6.0, (double)6.0, (double)15.0, (double)10.0);
    static final Map<Direction, VoxelShape> LEFT_BUTTON_SHAPES = ShapesHelper.rotateHorizontally((VoxelShape)LEFT_BUTTON_SHAPE);
    static final VoxelShape MIDDLE_BUTTON_SHAPE = Block.box((double)7.0, (double)14.0, (double)6.0, (double)9.0, (double)15.0, (double)10.0);
    static final Map<Direction, VoxelShape> MIDDLE_BUTTON_SHAPES = ShapesHelper.rotateHorizontally((VoxelShape)MIDDLE_BUTTON_SHAPE);
    static final VoxelShape RIGHT_BUTTON_SHAPE = Block.box((double)10.0, (double)14.0, (double)6.0, (double)12.0, (double)15.0, (double)10.0);
    static final Map<Direction, VoxelShape> RIGHT_BUTTON_SHAPES = ShapesHelper.rotateHorizontally((VoxelShape)RIGHT_BUTTON_SHAPE);
    static final VoxelShape LATCH_SHAPE = Block.box((double)7.0, (double)7.0, (double)15.0, (double)9.0, (double)11.0, (double)16.0);
    static final Map<Direction, VoxelShape> LATCH_SHAPES = ShapesHelper.rotateHorizontally((VoxelShape)LATCH_SHAPE);
    static final Map<Direction, VoxelShape> SHAPES = (Map)Direction.Plane.HORIZONTAL.stream().collect(Maps.toImmutableEnumMap(Function.identity(), direction -> Shapes.or((VoxelShape)EnderChestBlock.SHAPE, (VoxelShape[])new VoxelShape[]{LEFT_BUTTON_SHAPES.get(direction), MIDDLE_BUTTON_SHAPES.get(direction), RIGHT_BUTTON_SHAPES.get(direction), LATCH_SHAPES.get(direction)})));

    public LinkedChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MapCodec<EnderChestBlock> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES.get(state.getValue((Property)FACING));
    }

    protected VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return EnderChestBlock.SHAPE;
    }

    @Override
    public VoxelShape getHighlightShape(BlockState state, BlockGetter level, BlockPos pos, Vec3 hitVector) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        hitVector = hitVector.subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        List<Map<Direction, VoxelShape>> shapes = List.of(LEFT_BUTTON_SHAPES, MIDDLE_BUTTON_SHAPES, RIGHT_BUTTON_SHAPES, LATCH_SHAPES);
        for (Map<Direction, VoxelShape> map : shapes) {
            VoxelShape voxelShape = map.get(direction);
            if (!voxelShape.bounds().inflate(0.001).contains(hitVector)) continue;
            return voxelShape;
        }
        return EnderChestBlock.SHAPE;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected ItemInteractionResult useItemOn(ItemStack itemInHand, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        MenuProvider menuProvider;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LinkedChestBlockEntity) {
            LinkedChestBlockEntity blockEntity2 = (LinkedChestBlockEntity)blockEntity;
            DyeChannel dyeChannel = blockEntity2.getDyeChannel();
            Direction direction = (Direction)state.getValue((Property)FACING);
            Vec3 hitVector = hitResult.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            if (itemInHand.is(ModRegistry.DYE_CHANNEL_COLOR_PROVIDERS_ITEM_TAG)) {
                DyeColor dyeColor = DyeChannel.getDyeColor(itemInHand.getItem());
                DyeChannel newDyeChannel = dyeChannel;
                if (LEFT_BUTTON_SHAPES.get(direction).bounds().inflate(0.001).contains(hitVector)) {
                    newDyeChannel = dyeChannel.withLeftColor(dyeColor);
                } else if (MIDDLE_BUTTON_SHAPES.get(direction).bounds().inflate(0.001).contains(hitVector)) {
                    newDyeChannel = dyeChannel.withMiddleColor(dyeColor);
                } else if (RIGHT_BUTTON_SHAPES.get(direction).bounds().inflate(0.001).contains(hitVector)) {
                    newDyeChannel = dyeChannel.withRightColor(dyeColor);
                }
                if (dyeChannel != newDyeChannel) {
                    if (!level.isClientSide) {
                        blockEntity2.setDyeChannel(newDyeChannel);
                        level.playSound(null, pos, SoundEvents.CHISELED_BOOKSHELF_INSERT, SoundSource.BLOCKS, 1.0f, 1.0f);
                        itemInHand.consume(1, (LivingEntity)player);
                        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            } else if (LATCH_SHAPES.get(direction).bounds().inflate(0.001).contains(hitVector)) {
                if (dyeChannel.uuid().isPresent()) {
                    if (itemInHand.isEmpty() && player.isShiftKeyDown()) {
                        if (!level.isClientSide) {
                            blockEntity2.setDyeChannel(dyeChannel.withUUID(null));
                            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                            ItemStack itemStack = blockEntity2.removeLatchItem();
                            if (!player.getInventory().add(itemStack)) {
                                player.drop(itemStack, false);
                            }
                            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                        }
                        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                    }
                } else if (itemInHand.is(ModRegistry.PERSONAL_CHANNEL_PROVIDERS_ITEM_TAG)) {
                    if (!level.isClientSide) {
                        blockEntity2.setDyeChannel(dyeChannel.withUUID(player.getUUID()));
                        level.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
                        blockEntity2.setLatchItem(itemInHand.copyWithCount(1));
                        itemInHand.consume(1, (LivingEntity)player);
                        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
            }
        }
        if (!level.getBlockState(pos.above()).isRedstoneConductor((BlockGetter)level, pos.above()) && !level.isClientSide && (menuProvider = this.getMenuProvider(state, level, pos)) != null) {
            player.openMenu(menuProvider);
            PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState blockState) {
        ItemStack itemStack = super.getCloneItemStack(level, pos, blockState);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof LinkedChestBlockEntity) {
            LinkedChestBlockEntity blockEntity2 = (LinkedChestBlockEntity)blockEntity;
            itemStack.set((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)blockEntity2.getDyeChannel());
        }
        return itemStack;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines(this.getDescriptionComponent()));
    }

    public Component getDescriptionComponent() {
        return Component.translatable((String)(this.getDescriptionId() + ".description")).withStyle(ChatFormatting.GOLD);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LinkedChestBlockEntity(pos, state);
    }
}

