/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.item.crafting;

import com.mojang.serialization.MapCodec;
import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class ShapedDyeChannelRecipe
extends ShapedRecipe {
    private static final Map<Item, DyeColor> DYE_BY_ITEM = Sheep.ITEM_BY_DYE.entrySet().stream().collect(Collectors.toMap(entry -> ((ItemLike)entry.getValue()).asItem(), Map.Entry::getKey, (o1, o2) -> o1, IdentityHashMap::new));

    public ShapedDyeChannelRecipe(ShapedRecipe shapedRecipe) {
        super(shapedRecipe.getGroup(), shapedRecipe.category(), shapedRecipe.pattern, shapedRecipe.getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY), shapedRecipe.showNotification());
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider registries) {
        ItemStack itemStack = super.assemble(craftingInput, registries);
        for (ItemStack input : craftingInput.items()) {
            DyeColor dyeColor = DYE_BY_ITEM.get(input.getItem());
            if (dyeColor == null) continue;
            itemStack.set((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)new DyeChannel(dyeColor));
            break;
        }
        return itemStack;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.SHAPED_DYE_CHANNEL_RECIPE_SERIALIZER.value();
    }

    public static class Serializer
    implements RecipeSerializer<ShapedDyeChannelRecipe> {
        public MapCodec<ShapedDyeChannelRecipe> codec() {
            return ShapedRecipe.Serializer.SHAPED_RECIPE.codec().xmap(ShapedDyeChannelRecipe::new, Function.identity());
        }

        public StreamCodec<RegistryFriendlyByteBuf, ShapedDyeChannelRecipe> streamCodec() {
            return ShapedRecipe.Serializer.SHAPED_RECIPE.streamCodec().map(ShapedDyeChannelRecipe::new, Function.identity());
        }
    }
}

