/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.item.crafting;

import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ObjIntConsumer;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class DyeChannelRecipe
extends CustomRecipe {
    public DyeChannelRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        PositionedItem positionedItem = this.getDyeChannelItem(craftingInput);
        if (positionedItem != null) {
            DyeChannel dyeChannel = (DyeChannel)positionedItem.itemStack().getOrDefault((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)DyeChannel.DEFAULT);
            MutableBoolean mutableBoolean = new MutableBoolean();
            List<PositionedItem> items = this.iterateDyeItems(craftingInput, positionedItem.posX(), positionedItem.posY(), (dyeColor, value) -> {
                if (dyeChannel.withColorAt(value, (DyeColor)dyeColor) != dyeChannel) {
                    mutableBoolean.setTrue();
                }
            });
            if (mutableBoolean.isTrue()) {
                items.add(positionedItem);
                IntSet set = (IntSet)items.stream().map(item -> item.index(craftingInput.width())).collect(Collectors.toCollection(IntArraySet::new));
                for (int i = 0; i < craftingInput.size(); ++i) {
                    if (set.contains(i) || craftingInput.getItem(i).isEmpty()) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Nullable
    private PositionedItem getDyeChannelItem(CraftingInput craftingInput) {
        for (int width = 0; width < craftingInput.width(); ++width) {
            for (int height = 0; height < craftingInput.height(); ++height) {
                ItemStack itemStack = craftingInput.getItem(width, height);
                if (!itemStack.has((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value())) continue;
                return new PositionedItem(itemStack, width, height);
            }
        }
        return null;
    }

    private List<PositionedItem> iterateDyeItems(CraftingInput craftingInput, int posX, int posY, ObjIntConsumer<DyeColor> consumer) {
        ArrayList<PositionedItem> dyeItems = new ArrayList<PositionedItem>();
        --posX;
        --posY;
        int i = 0;
        while (i < 3) {
            ItemStack itemStack;
            if (posX >= 0 && posX < craftingInput.width() && posY >= 0 && posY < craftingInput.height() && (itemStack = craftingInput.getItem(posX, posY)).is(ModRegistry.DYE_CHANNEL_COLOR_PROVIDERS_ITEM_TAG)) {
                consumer.accept(DyeChannel.getDyeColor(itemStack.getItem()), i);
                dyeItems.add(new PositionedItem(itemStack, posX, posY));
            }
            ++i;
            ++posX;
        }
        return dyeItems;
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider registries) {
        PositionedItem positionedItem = this.getDyeChannelItem(craftingInput);
        if (positionedItem != null) {
            ItemStack itemStack = positionedItem.itemStack().copy();
            this.iterateDyeItems(craftingInput, positionedItem.posX(), positionedItem.posY(), (dyeColor, value) -> {
                DyeChannel dyeChannel = (DyeChannel)itemStack.getOrDefault((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)DyeChannel.DEFAULT);
                itemStack.set((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)dyeChannel.withColorAt(value, (DyeColor)dyeColor));
            });
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.DYE_CHANNEL_RECIPE_SERIALIZER.value();
    }

    record PositionedItem(ItemStack itemStack, int posX, int posY) {
        public int index(int width) {
            return this.posX + this.posY * width;
        }
    }
}

