/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.world.item;

import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.inventory.DyeChannelContainer;
import fuzs.linkedchests.world.inventory.LinkedMenu;
import fuzs.linkedchests.world.level.block.LinkedChestBlock;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.LinkedChestBlockEntity;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class LinkedPouchItem
extends Item {
    public LinkedPouchItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockEntity blockEntity;
        Level level = context.getLevel();
        if (context.getPlayer().isShiftKeyDown() && (blockEntity = level.getBlockEntity(context.getClickedPos())) instanceof LinkedChestBlockEntity) {
            LinkedChestBlockEntity blockEntity2 = (LinkedChestBlockEntity)blockEntity;
            if (!level.isClientSide) {
                context.getItemInHand().set((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)blockEntity2.getDyeChannel());
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useOn(context);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemInHand = player.getItemInHand(interactionHand);
        if (!level.isClientSide) {
            DyeChannel dyeChannel = (DyeChannel)itemInHand.getOrDefault((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)DyeChannel.DEFAULT);
            player.openMenu((MenuProvider)new SimpleMenuProvider((containerId, inventory, player1) -> {
                DyeChannelContainer container = new DyeChannelContainer(dyeChannel);
                return new LinkedMenu(containerId, inventory, (Container)container, dyeChannel.uuid().isPresent(), true);
            }, this.getDescription()));
        }
        return InteractionResultHolder.sidedSuccess((Object)itemInHand, (boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        Component component = ((LinkedChestBlock)ModRegistry.LINKED_CHEST_BLOCK.value()).getDescriptionComponent();
        tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines(component));
    }
}

