/*
 * Decompiled with CFR 0.152.
 */
package fuzs.linkedchests.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fuzs.linkedchests.LinkedChests;
import fuzs.linkedchests.client.handler.DyeChannelLidController;
import fuzs.linkedchests.client.model.LinkedChestModel;
import fuzs.linkedchests.client.renderer.blockentity.LinkedChestRenderer;
import fuzs.linkedchests.init.ModRegistry;
import fuzs.linkedchests.world.level.block.HighlightShapeProvider;
import fuzs.linkedchests.world.level.block.entity.DyeChannel;
import fuzs.linkedchests.world.level.block.entity.LinkedChestBlockEntity;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BlockEntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.core.v1.context.ColorProvidersContext;
import fuzs.puzzleslib.api.client.core.v1.context.ItemModelPropertiesContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.puzzleslib.api.client.event.v1.ClientTickEvents;
import fuzs.puzzleslib.api.client.event.v1.entity.player.ClientPlayerNetworkEvents;
import fuzs.puzzleslib.api.client.event.v1.renderer.RenderHighlightCallback;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LinkedChestsClient
implements ClientModConstructor {
    public static final ResourceLocation ITEM_MODEL_PROPERTY_OPEN = LinkedChests.id("open");
    public static final ResourceLocation ITEM_MODEL_PROPERTY_PERSONAL = LinkedChests.id("personal");

    public void onConstructMod() {
        LinkedChestsClient.registerEventHandlers();
    }

    private static void registerEventHandlers() {
        ClientTickEvents.END.register(DyeChannelLidController::onEndClientTick);
        ClientPlayerNetworkEvents.LOGGED_IN.register(DyeChannelLidController::onLoggedIn);
        RenderHighlightCallback.EVENT.register((levelRenderer, camera, gameRenderer, hitResult, deltaTracker, poseStack, multiBufferSource, level) -> {
            Block patt0$temp;
            BlockPos blockPos;
            BlockState blockState;
            if (hitResult.getType() == HitResult.Type.BLOCK && !(blockState = level.getBlockState(blockPos = ((BlockHitResult)hitResult).getBlockPos())).isAir() && level.getWorldBorder().isWithinBounds(blockPos) && (patt0$temp = blockState.getBlock()) instanceof HighlightShapeProvider) {
                HighlightShapeProvider block = (HighlightShapeProvider)patt0$temp;
                VoxelShape voxelShape = block.getHighlightShape(blockState, (BlockGetter)level, blockPos, hitResult.getLocation());
                VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.lines());
                Vec3 cameraPosition = camera.getPosition();
                double posX = (double)blockPos.getX() - cameraPosition.x();
                double posY = (double)blockPos.getY() - cameraPosition.y();
                double posZ = (double)blockPos.getZ() - cameraPosition.z();
                LevelRenderer.renderVoxelShape((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (VoxelShape)voxelShape, (double)posX, (double)posY, (double)posZ, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f, (boolean)true);
                return EventResult.INTERRUPT;
            }
            return EventResult.PASS;
        });
    }

    public void onRegisterItemModelProperties(ItemModelPropertiesContext context) {
        context.registerItemProperty(ITEM_MODEL_PROPERTY_OPEN, (itemStack, clientLevel, entity, seed) -> {
            DyeChannel dyeChannel = (DyeChannel)itemStack.getOrDefault((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)DyeChannel.DEFAULT);
            return Mth.ceil((float)DyeChannelLidController.getChestLidController(dyeChannel).getOpenness(1.0f));
        }, new ItemLike[]{(ItemLike)ModRegistry.LINKED_POUCH_ITEM.value()});
        context.registerItemProperty(ITEM_MODEL_PROPERTY_PERSONAL, (itemStack, clientLevel, entity, seed) -> {
            DyeChannel dyeChannel = (DyeChannel)itemStack.getOrDefault((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)DyeChannel.DEFAULT);
            return dyeChannel.uuid().isPresent() ? 1.0f : 0.0f;
        }, new ItemLike[]{(ItemLike)ModRegistry.LINKED_POUCH_ITEM.value()});
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.LINKED_CHEST_MENU_TYPE.value(), ContainerScreen::new);
        context.registerMenuScreen((MenuType)ModRegistry.LINKED_POUCH_MENU_TYPE.value(), ContainerScreen::new);
        context.registerMenuScreen((MenuType)ModRegistry.PERSONAL_LINKED_CHEST_MENU_TYPE.value(), ContainerScreen::new);
        context.registerMenuScreen((MenuType)ModRegistry.PERSONAL_LINKED_POUCH_MENU_TYPE.value(), ContainerScreen::new);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(LinkedChestModel.MODEL_LAYER_LOCATION, LinkedChestModel::createSingleBodyLayer);
    }

    public void onRegisterBlockEntityRenderers(BlockEntityRenderersContext context) {
        context.registerBlockEntityRenderer((BlockEntityType)ModRegistry.LINKED_CHEST_BLOCK_ENTITY.value(), LinkedChestRenderer::new);
    }

    public void onRegisterItemColorProviders(ColorProvidersContext<Item, ItemColor> context) {
        context.registerColorProvider((itemStack, layer) -> {
            DyeChannel dyeChannel = (DyeChannel)itemStack.getOrDefault((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)DyeChannel.DEFAULT);
            DyeColor dyeColor = switch (layer) {
                case 1 -> dyeChannel.leftColor();
                case 2 -> dyeChannel.middleColor();
                case 3 -> dyeChannel.rightColor();
                default -> DyeColor.WHITE;
            };
            return FastColor.ARGB32.opaque((int)dyeColor.getMapColor().col);
        }, (Object[])new Item[]{(Item)ModRegistry.LINKED_CHEST_ITEM.value(), (Item)ModRegistry.LINKED_POUCH_ITEM.value()});
    }

    public void onRegisterBuiltinModelItemRenderers(BuiltinModelItemRendererContext context) {
        LinkedChestBlockEntity blockEntity = new LinkedChestBlockEntity(BlockPos.ZERO, ((Block)ModRegistry.LINKED_CHEST_BLOCK.value()).defaultBlockState());
        context.registerItemRenderer((itemStack, itemDisplayContext, poseStack, multiBufferSource, packedLight, packedOverlay) -> {
            DyeChannel dyeChannel = (DyeChannel)itemStack.getOrDefault((DataComponentType)ModRegistry.DYE_CHANNEL_DATA_COMPONENT_TYPE.value(), (Object)DyeChannel.DEFAULT);
            blockEntity.setDyeChannel(dyeChannel);
            poseStack.pushPose();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            Minecraft.getInstance().getBlockEntityRenderDispatcher().renderItem((BlockEntity)blockEntity, poseStack, multiBufferSource, packedLight, packedOverlay);
            poseStack.popPose();
        }, new ItemLike[]{(ItemLike)ModRegistry.LINKED_CHEST_BLOCK.value()});
    }

    public static ModelLayerLocation id(String path) {
        return new ModelLayerLocation(LinkedChests.id(path), "main");
    }
}

