/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.util;

import com.github.L_Ender.cataclysm.util.EntityExcludedDamageSource;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CMDamageTypes {
    public static final ResourceKey<DamageType> LASER = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"laser"));
    public static final ResourceKey<DamageType> DEATHLASER = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"deathlaser"));
    public static final ResourceKey<DamageType> EMP = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"emp"));
    public static final ResourceKey<DamageType> ABYSSAL_BURN = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"abyssal_burn"));
    public static final ResourceKey<DamageType> SHREDDER = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"shredder"));
    public static final ResourceKey<DamageType> SWORD_DANCE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"sword_dance"));
    public static final ResourceKey<DamageType> MALEDICTIO = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"maledictio"));
    public static final ResourceKey<DamageType> MALEDICTIO_SAGITTA = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"maledictio_sagitta"));
    public static final ResourceKey<DamageType> MALEDICTIO_MAGICAE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"maledictio_magicae"));
    public static final ResourceKey<DamageType> PENETRATE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"penetrate"));
    public static final ResourceKey<DamageType> MALEDICTIO_ANIMA = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"cataclysm", (String)"maledictio_anima"));

    public static DamageSource causeLaserDamage(Entity attacker, Entity caster) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(LASER), attacker, caster);
    }

    public static DamageSource getDamageSource(Level level, ResourceKey<DamageType> type, EntityType<?> ... toIgnore) {
        return CMDamageTypes.getEntityDamageSource(level, type, null, toIgnore);
    }

    public static DamageSource getEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, EntityType<?> ... toIgnore) {
        return CMDamageTypes.getIndirectEntityDamageSource(level, type, attacker, attacker, toIgnore);
    }

    public static DamageSource getIndirectEntityDamageSource(Level level, ResourceKey<DamageType> type, @Nullable Entity attacker, @Nullable Entity indirectAttacker, EntityType<?> ... toIgnore) {
        return toIgnore.length > 0 ? new EntityExcludedDamageSource((Holder<DamageType>)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type), toIgnore) : new DamageSource((Holder)level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(type), attacker, indirectAttacker);
    }

    public static DamageSource causeDeathLaserDamage(Entity attacker, LivingEntity caster) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(DEATHLASER), attacker, (Entity)caster);
    }

    public static DamageSource causeShredderDamage(LivingEntity attacker) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(SHREDDER), (Entity)attacker);
    }

    public static DamageSource causeSwordDanceDamage(LivingEntity attacker) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(SWORD_DANCE), (Entity)attacker);
    }

    public static DamageSource causeMaledictioDamage(LivingEntity attacker) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(MALEDICTIO), (Entity)attacker);
    }

    public static DamageSource causeMaledictioSoulDamage(LivingEntity attacker) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(MALEDICTIO_ANIMA), (Entity)attacker);
    }

    public static DamageSource causeMaledictioSagittaDamage(Entity attacker, Entity caster) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(MALEDICTIO_SAGITTA), attacker, caster);
    }

    public static DamageSource causeMaledictioMagicaeDamage(Entity attacker, Entity caster) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(MALEDICTIO_MAGICAE), attacker, caster);
    }

    public static DamageSource causePenetrateDamage(LivingEntity attacker) {
        return new DamageSource((Holder)((Registry)attacker.level().registryAccess().registry(Registries.DAMAGE_TYPE).get()).getHolderOrThrow(PENETRATE), (Entity)attacker);
    }
}

