/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.IABossMonsters;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.InternalAnimationMonster.Internal_Animation_Monster;
import com.github.L_Ender.cataclysm.init.ModTag;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class IABoss_monster
extends Internal_Animation_Monster
implements Enemy {
    private int reducedDamageTicks;
    private int homeTicks;
    public static final int HOME_COOLDOWN = CMConfig.Return_Home * 20;
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.defineId(IABoss_monster.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_POS);

    public IABoss_monster(EntityType entity, Level world) {
        super(entity, world);
    }

    public void setHomePos(BlockPos homePos) {
        this.entityData.set(HOME_POS, (Object)homePos);
    }

    BlockPos getHomePos() {
        return (BlockPos)this.entityData.get(HOME_POS);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HOME_POS, (Object)BlockPos.ZERO);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("HomePosX", this.getHomePos().getX());
        compound.putInt("HomePosY", this.getHomePos().getY());
        compound.putInt("HomePosZ", this.getHomePos().getZ());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        int i = compound.getInt("HomePosX");
        int j = compound.getInt("HomePosY");
        int k = compound.getInt("HomePosZ");
        this.setHomePos(new BlockPos(i, j, k));
        super.readAdditionalSaveData(compound);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.homeTicks = HOME_COOLDOWN;
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    public boolean hurt(DamageSource source, float damage) {
        if (source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            return super.hurt(source, damage);
        }
        damage = Math.min(this.DamageCap(), damage);
        if (this.ReducedDamage(source) && this.reducedDamageTicks > 0) {
            float reductionFactor = 1.0f - (float)this.reducedDamageTicks / (float)this.DamageTime();
            damage *= reductionFactor;
        }
        boolean flag = super.hurt(source, damage);
        if (this.ReducedDamage(source) && flag) {
            this.reducedDamageTicks = this.DamageTime();
        }
        return flag;
    }

    public boolean ReducedDamage(DamageSource damageSource) {
        return !damageSource.is(ModTag.BYPASSES_HURT_TIME) && this.DamageTime() > 0;
    }

    @Override
    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            if (this.reducedDamageTicks > 0) {
                --this.reducedDamageTicks;
            }
            if (this.homeTicks > 0) {
                --this.homeTicks;
            }
            LivingEntity target = this.getTarget();
            if (CMConfig.Return_Home > 0) {
                if (this.homeTicks > 0) {
                    --this.homeTicks;
                }
                if (!this.isNoAi()) {
                    if (target != null) {
                        this.homeTicks = HOME_COOLDOWN;
                    }
                    if (this.homeTicks <= 0 && this.getHomePos() != BlockPos.ZERO && !this.getHomePos().closerToCenterThan((Position)this.position(), 16.0)) {
                        this.moveTo((double)this.getHomePos().getX() + 0.5, this.getHomePos().getY(), (double)this.getHomePos().getZ() + 0.5, this.getYRot(), this.getXRot());
                        this.homeTicks = HOME_COOLDOWN;
                    }
                }
            }
        }
    }

    public float DamageCap() {
        return Float.MAX_VALUE;
    }

    public int DamageTime() {
        return 40;
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return true;
    }

    public boolean canBeAffected(MobEffectInstance p_34192_) {
        return p_34192_.getEffect().getDelegate().is(ModTag.EFFECTIVE_FOR_BOSSES) && super.canBeAffected(p_34192_);
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    protected boolean canRide(Entity p_31508_) {
        return false;
    }
}

