/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.client.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;

public class CustomExplodeParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;
    private boolean hasFadeColor = false;
    private float fadeR;
    private float fadeG;
    private float fadeB;

    protected CustomExplodeParticle(ClientLevel world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet sprites, boolean shortLifespan, int color1) {
        super(world, x, y, z, xSpeed, ySpeed, zSpeed);
        this.xd = xSpeed;
        this.yd = ySpeed;
        this.zd = zSpeed;
        this.setSize(0.5f, 0.5f);
        this.quadSize = (shortLifespan ? 1.0f : 0.8f) + world.random.nextFloat() * 0.3f;
        this.lifetime = shortLifespan ? 5 + world.random.nextInt(3) : 15 + world.random.nextInt(10);
        this.friction = 0.96f;
        float randCol = world.random.nextFloat() * 0.05f;
        this.sprites = sprites;
        this.setColor(Math.min((float)FastColor.ARGB32.red((int)color1) / 255.0f + randCol, 1.0f), Math.min(1.0f, (float)FastColor.ARGB32.green((int)color1) / 255.0f + randCol), Math.min(1.0f, (float)FastColor.ARGB32.blue((int)color1) / 255.0f + randCol));
    }

    public void setFadeColor(int i) {
        this.hasFadeColor = true;
        this.fadeR = (float)((i & 0xFF0000) >> 16) / 255.0f;
        this.fadeG = (float)((i & 0xFF00) >> 8) / 255.0f;
        this.fadeB = (float)((i & 0xFF) >> 0) / 255.0f;
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.setSpriteFromAge(this.sprites);
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            if (this.hasFadeColor) {
                this.rCol += (this.fadeR - this.rCol) * 0.2f;
                this.gCol += (this.fadeG - this.gCol) * 0.2f;
                this.bCol += (this.fadeB - this.bCol) * 0.2f;
            } else {
                this.rCol *= 0.95f;
                this.gCol *= 0.95f;
                this.bCol *= 0.95f;
            }
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)this.friction;
            this.yd *= (double)this.friction;
            this.zd *= (double)this.friction;
        }
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_LIT;
    }

    public float getQuadSize(float scaleFactor) {
        return super.getQuadSize(scaleFactor);
    }

    public int getLightColor(float partialTicks) {
        return 240;
    }

    public static class FlareFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public FlareFactory(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            CustomExplodeParticle particle = new CustomExplodeParticle(worldIn, x, y, z, xSpeed, ySpeed, zSpeed, this.spriteSet, false, 0xFFFFFF);
            particle.setSpriteFromAge(this.spriteSet);
            particle.scale(1.0f + worldIn.random.nextFloat() * 0.9f);
            particle.setFadeColor(12803843);
            return particle;
        }
    }
}

