/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category;

import giselle.jei_mekanism_multiblocks.client.gui.CheckBoxWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import giselle.jei_mekanism_multiblocks.common.JEI_MekanismMultiblocks;
import giselle.jei_mekanism_multiblocks.common.util.VolumeTextHelper;
import java.util.function.Consumer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.common.util.text.TextUtils;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class EvaporationPlantCategory
extends MultiblockCategory<EvaporationPlantWidget> {
    public EvaporationPlantCategory(IGuiHelper helper) {
        super(helper, Mekanism.rl((String)"evaporation_plant"), EvaporationPlantWidget.class, (Component)MekanismLang.EVAPORATION_PLANT.translate(), new ItemStack((ItemLike)MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER));
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(new ItemStack((ItemLike)MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER));
        consumer.accept(new ItemStack((ItemLike)MekanismBlocks.THERMAL_EVAPORATION_VALVE));
        consumer.accept(new ItemStack((ItemLike)MekanismBlocks.THERMAL_EVAPORATION_BLOCK));
        consumer.accept(new ItemStack((ItemLike)MekanismBlocks.STRUCTURAL_GLASS));
        if (JEI_MekanismMultiblocks.MekanismGeneratorsLoaded) {
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR));
        }
    }

    public static class EvaporationPlantWidget
    extends MultiblockWidget {
        protected CheckBoxWidget useAdvancedSolarGeneratorCheckBox;
        protected IntSliderWithButtons valvesWidget;

        @Override
        public int getSideBlocks() {
            return super.getSideBlocks() - 5;
        }

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            if (JEI_MekanismMultiblocks.MekanismGeneratorsLoaded) {
                this.useAdvancedSolarGeneratorCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.translatable((String)"text.jei_mekanism_multiblocks.specs.use_things", (Object[])new Object[]{new ItemStack((ItemLike)GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR).getHoverName()}), true);
                consumer.accept((AbstractWidget)this.useAdvancedSolarGeneratorCheckBox);
                this.useAdvancedSolarGeneratorCheckBox.addSelectedChangedHandler(this::onUseAdvancedSolarGeneratorChanged);
            } else {
                this.useAdvancedSolarGeneratorCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.empty(), false);
                this.useAdvancedSolarGeneratorCheckBox.addSelectedChangedHandler(this::onUseAdvancedSolarGeneratorChanged);
            }
            this.valvesWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.valves", 0, 2, 0);
            consumer.accept(this.valvesWidget);
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).addValueChangeHanlder(this::onValvesChanged);
            this.updateValveSliderLimit();
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updateValveSliderLimit();
        }

        public void updateValveSliderLimit() {
            IntSliderWidget valvesSlider = (IntSliderWidget)((Object)this.valvesWidget.getSlider());
            int minValves = valvesSlider.getMinValue();
            int valves = valvesSlider.getValue();
            valvesSlider.setMinValue(this.useAdvancedSolarGeneratorCheckBox.isSelected() ? 2 : 3);
            valvesSlider.setMaxValue(this.getSideBlocks());
            valvesSlider.setValue(valves + (valvesSlider.getMinValue() - minValves));
        }

        protected void onValvesChanged(int valves) {
            this.markNeedUpdate();
        }

        @Override
        protected void onUseGlassChanged(boolean useGlass) {
            super.onUseGlassChanged(useGlass);
        }

        protected void onUseAdvancedSolarGeneratorChanged(boolean useAdvancedSolarGenerator) {
            this.markNeedUpdate();
            this.updateValveSliderLimit();
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int valves = this.getValveCount();
            sides -= valves;
            int casing = 0;
            int glasses = 0;
            int advancedSolarGenerators = 0;
            if (this.isUseGlass()) {
                casing = corners;
                glasses = sides;
                if (this.isUseAdvancedSolarGenerator()) {
                    casing -= 4;
                    advancedSolarGenerators += 4;
                } else {
                    casing -= 8;
                    glasses += 8;
                }
            } else {
                casing = corners + sides - 4;
                if (this.isUseAdvancedSolarGenerator()) {
                    advancedSolarGenerators += 4;
                }
            }
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, 1));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.THERMAL_EVAPORATION_VALVE, valves));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.THERMAL_EVAPORATION_BLOCK, casing));
            consumer.accept(new ItemStack((ItemLike)this.getGlassBlock(), glasses));
            if (JEI_MekanismMultiblocks.MekanismGeneratorsLoaded) {
                consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.ADVANCED_SOLAR_GENERATOR, advancedSolarGenerators));
            }
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            long dimHeight = this.getDimensionHeight();
            long inputCapacity = dimHeight * 4L * (long)MekanismConfig.general.evaporationFluidPerTank.get();
            long outputCapacity = MekanismConfig.general.evaporationOutputTankCapacity.get();
            double maxTemp = 3000.0;
            double maxSpeed = (maxTemp - 300.0) * MekanismConfig.general.evaporationTempMultiplier.get() * ((double)dimHeight / (double)this.getDimensionHeightMax());
            ResultWidget speedWidget = new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.max_speed"), (Component)Component.literal((String)("x" + TextUtils.format((double)maxSpeed))));
            speedWidget.setJeiTooltip(new Component[]{Component.translatable((String)"text.jei_mekanism_multiblocks.tooltip.when_temp_ge", (Object[])new Object[]{MekanismUtils.getTemperatureDisplay((double)maxTemp, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false)})});
            consumer.accept(speedWidget);
            consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.input_tank"), VolumeTextHelper.formatMB(inputCapacity)));
            consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.output_tank"), VolumeTextHelper.formatMB(outputCapacity)));
        }

        public int getValveCount() {
            return ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).getValue();
        }

        public void setValveCount(int valveCount) {
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).setValue(valveCount);
        }

        public boolean isUseAdvancedSolarGenerator() {
            return JEI_MekanismMultiblocks.MekanismGeneratorsLoaded && this.useAdvancedSolarGeneratorCheckBox.isSelected();
        }

        public void setUseAdvancedSolarGenerator(boolean useAdvancedSolarGenerator) {
            this.useAdvancedSolarGeneratorCheckBox.setSelected(useAdvancedSolarGenerator);
        }

        @Override
        public int getDimensionWidthMin() {
            return 4;
        }

        @Override
        public int getDimensionWidthMax() {
            return 4;
        }

        @Override
        public int getDimensionLengthMin() {
            return 4;
        }

        @Override
        public int getDimensionLengthMax() {
            return 4;
        }

        @Override
        public int getDimensionHeightMin() {
            return 3;
        }

        @Override
        public int getDimensionHeightMax() {
            return 18;
        }

        @Override
        public Block getGlassBlock() {
            return (Block)MekanismBlocks.STRUCTURAL_GLASS.get();
        }
    }
}

