/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.Registry;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import snownee.jade.api.config.IgnoreList;
import snownee.jade.api.theme.TextSetting;
import snownee.jade.api.theme.Theme;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Color;
import snownee.jade.api.ui.ColorPalette;

public class JadeCodecs {
    public static final Codec<TextSetting> TEXT_SETTING = RecordCodecBuilder.create(i -> i.group((App)ColorPalette.CODEC.optionalFieldOf("colors", (Object)ColorPalette.DEFAULT).forGetter(TextSetting::colors), (App)Codec.BOOL.optionalFieldOf("shadow", (Object)true).forGetter(TextSetting::shadow), (App)Style.Serializer.CODEC.optionalFieldOf("modNameStyle").forGetter($ -> Optional.ofNullable($.modNameStyle())), (App)Color.CODEC.optionalFieldOf("itemAmountColor", (Object)-1).forGetter(TextSetting::itemAmountColor)).apply((Applicative)i, TextSetting::new));
    public static final Codec<Theme> THEME = RecordCodecBuilder.create(i -> i.group((App)BoxStyle.CODEC.fieldOf("tooltipStyle").forGetter($ -> $.tooltipStyle), (App)BoxStyle.CODEC.optionalFieldOf("nestedBoxStyle", (Object)BoxStyle.GradientBorder.DEFAULT_NESTED_BOX).forGetter($ -> $.nestedBoxStyle), (App)BoxStyle.CODEC.optionalFieldOf("viewGroupStyle", (Object)BoxStyle.GradientBorder.DEFAULT_VIEW_GROUP).forGetter($ -> $.viewGroupStyle), (App)TEXT_SETTING.optionalFieldOf("text", (Object)TextSetting.DEFAULT).forGetter($ -> $.text), (App)Codec.BOOL.optionalFieldOf("changeRoundCorner").forGetter($ -> Optional.ofNullable($.changeRoundCorner)), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("changeOpacity", (Object)Float.valueOf(0.0f)).forGetter($ -> Float.valueOf($.changeOpacity)), (App)Codec.BOOL.optionalFieldOf("lightColorScheme", (Object)false).forGetter($ -> $.lightColorScheme), (App)Codec.BOOL.optionalFieldOf("hidden", (Object)false).forGetter($ -> $.hidden), (App)ResourceLocation.CODEC.optionalFieldOf("iconSlotSprite").forGetter($ -> Optional.ofNullable($.iconSlotSprite)), (App)Codec.INT.optionalFieldOf("iconSlotInflation", (Object)0).forGetter($ -> $.iconSlotInflation)).apply((Applicative)i, Theme::new));
    public static final Codec<OptionalInt> OPTIONAL_INT = new Codec<OptionalInt>(){

        public <T> DataResult<Pair<OptionalInt, T>> decode(DynamicOps<T> ops, T input) {
            return DataResult.success((Object)((Pair)ops.getNumberValue(input).mapOrElse(number -> Pair.of((Object)OptionalInt.of(number.intValue()), (Object)ops.empty()), ignored -> Pair.of((Object)OptionalInt.empty(), (Object)ops.empty()))));
        }

        public <T> DataResult<T> encode(OptionalInt input, DynamicOps<T> ops, T prefix) {
            if (input.isPresent()) {
                return DataResult.success((Object)ops.createInt(input.getAsInt()));
            }
            return DataResult.success((Object)ops.empty());
        }
    };

    public static <T> Codec<IgnoreList<T>> ignoreList(ResourceKey<? extends Registry<T>> registryKey) {
        return RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("__comment", (Object)"").forGetter($ -> Language.getInstance().getOrDefault("jade.ignore_list.comment", "This is an ignore list for the target of Jade. You can add registry ids to the \"values\" list.")), (App)Codec.STRING.listOf().fieldOf("values").forGetter($ -> $.values), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("version", (Object)1).forGetter($ -> $.version)).apply((Applicative)i, (comment, values, version) -> {
            IgnoreList ignoreList = new IgnoreList();
            ignoreList.values = values;
            ignoreList.version = version;
            return ignoreList;
        }));
    }

    public static Codec<int[]> intArrayCodec(int size, Codec<Integer> codec) {
        return Codec.list(codec).flatXmap($ -> {
            if ($.size() != size) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + $.size());
            }
            int[] array = new int[size];
            for (int i = 0; i < array.length; ++i) {
                array[i] = (Integer)$.get(i);
            }
            return DataResult.success((Object)array);
        }, $ -> {
            if (((int[])$).length != size) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + ((int[])$).length);
            }
            IntArrayList list = new IntArrayList(size);
            for (int i : $) {
                list.add(i);
            }
            return DataResult.success((Object)list);
        });
    }

    public static Codec<float[]> floatArrayCodec(int size, Codec<Float> codec) {
        return Codec.list(codec).flatXmap($ -> {
            if ($.size() != size) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + $.size());
            }
            float[] array = new float[size];
            for (int i = 0; i < array.length; ++i) {
                array[i] = ((Float)$.get(i)).floatValue();
            }
            return DataResult.success((Object)array);
        }, $ -> {
            if (((float[])$).length != size) {
                return DataResult.error(() -> "Expected array of length " + size + ", got " + ((float[])$).length);
            }
            FloatArrayList list = new FloatArrayList(size);
            for (float f : $) {
                list.add(f);
            }
            return DataResult.success((Object)list);
        });
    }

    public static Optional<int[]> nullableClone(int[] array) {
        if (array == null) {
            return Optional.empty();
        }
        return Optional.of((int[])array.clone());
    }

    public static Optional<float[]> nullableClone(float[] array) {
        if (array == null) {
            return Optional.empty();
        }
        return Optional.of((float[])array.clone());
    }

    public static <T> T createFromEmptyMap(Codec<T> codec) {
        return (T)codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)JsonOps.INSTANCE.emptyMap())).getOrThrow();
    }
}

