/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.util;

import com.google.common.base.MoreObjects;
import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.UsernameCache;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;
import snownee.jade.Jade;
import snownee.jade.addon.harvest.HarvestToolProvider;
import snownee.jade.addon.universal.ItemCollector;
import snownee.jade.addon.universal.ItemIterator;
import snownee.jade.addon.universal.ItemStorageProvider;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.fluid.JadeFluidObject;
import snownee.jade.api.view.EnergyView;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.command.JadeServerCommand;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.impl.config.PluginConfig;
import snownee.jade.impl.lookup.WrappedHierarchyLookup;
import snownee.jade.mixin.CanItemPerformAbilityAccess;
import snownee.jade.network.ReceiveDataPacket;
import snownee.jade.network.RequestBlockPacket;
import snownee.jade.network.RequestEntityPacket;
import snownee.jade.network.ServerPingPacket;
import snownee.jade.network.ShowOverlayPacket;
import snownee.jade.util.ClientProxy;
import snownee.jade.util.JadeForgeUtils;
import snownee.jade.util.WailaExceptionHandler;

@Mod(value="jade")
public final class CommonProxy {
    public CommonProxy(IEventBus modBus) {
        modBus.addListener(this::loadComplete);
        modBus.addListener(this::registerPayloadHandlers);
        NeoForge.EVENT_BUS.addListener(CommonProxy::playerJoin);
        NeoForge.EVENT_BUS.addListener(CommonProxy::registerServerCommand);
        if (CommonProxy.isPhysicallyClient()) {
            ClientProxy.init(modBus);
        }
    }

    public static <T> T getDefaultStorage(Accessor<?> accessor, BlockCapability<T, ?> blockCapability, EntityCapability<T, ?> entityCapability) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return (T)accessor.getLevel().getCapability(blockCapability, blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null);
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor entityAccessor = (EntityAccessor)accessor;
            return (T)entityAccessor.getEntity().getCapability(entityCapability, null);
        }
        return null;
    }

    public static <T> boolean hasDefaultStorage(Accessor<?> accessor, BlockCapability<T, ?> blockCapability, EntityCapability<T, ?> entityCapability) {
        if (accessor instanceof BlockAccessor || accessor instanceof EntityAccessor) {
            return CommonProxy.getDefaultStorage(accessor, blockCapability, entityCapability) != null;
        }
        return true;
    }

    public static boolean hasDefaultItemStorage(Accessor<?> accessor) {
        BlockAccessor blockAccessor;
        if (accessor.getTarget() == null && accessor instanceof BlockAccessor && (blockAccessor = (BlockAccessor)accessor).getBlock() instanceof WorldlyContainerHolder) {
            return true;
        }
        return CommonProxy.hasDefaultStorage(accessor, Capabilities.ItemHandler.BLOCK, Capabilities.ItemHandler.ENTITY);
    }

    public static boolean hasDefaultFluidStorage(Accessor<?> accessor) {
        return CommonProxy.hasDefaultStorage(accessor, Capabilities.FluidHandler.BLOCK, Capabilities.FluidHandler.ENTITY);
    }

    public static boolean hasDefaultEnergyStorage(Accessor<?> accessor) {
        return CommonProxy.hasDefaultStorage(accessor, Capabilities.EnergyStorage.BLOCK, Capabilities.EnergyStorage.ENTITY);
    }

    public static long bucketVolume() {
        return 1000L;
    }

    public static long blockVolume() {
        return 1000L;
    }

    public static boolean isCorrectConditions(List<LootItemCondition> conditions, ItemStack toolItem) {
        if (conditions.size() != 1) {
            return false;
        }
        LootItemCondition condition = conditions.getFirst();
        if (condition instanceof MatchTool) {
            MatchTool matchTool = (MatchTool)condition;
            ItemPredicate itemPredicate = matchTool.predicate().orElse(null);
            return itemPredicate != null && itemPredicate.test(toolItem);
        }
        if (condition instanceof AnyOfCondition) {
            AnyOfCondition anyOfCondition = (AnyOfCondition)condition;
            for (LootItemCondition child : anyOfCondition.terms) {
                if (!CommonProxy.isCorrectConditions(List.of(child), toolItem)) continue;
                return true;
            }
        } else if (condition instanceof CanItemPerformAbilityAccess) {
            CanItemPerformAbilityAccess canItemPerformAbility = (CanItemPerformAbilityAccess)condition;
            return canItemPerformAbility.getAbility() == ItemAbilities.SHEARS_DIG;
        }
        return false;
    }

    private void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
        event.registrar("jade").versioned("5").optional().playToClient(ReceiveDataPacket.TYPE, ReceiveDataPacket.CODEC, (payload, context) -> ReceiveDataPacket.handle(payload, arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0))).playToClient(ServerPingPacket.TYPE, ServerPingPacket.CODEC, (payload, context) -> ServerPingPacket.handle(payload, arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0))).playToServer(RequestEntityPacket.TYPE, RequestEntityPacket.CODEC, (payload, context) -> RequestEntityPacket.handle(payload, () -> (ServerPlayer)context.player())).playToServer(RequestBlockPacket.TYPE, RequestBlockPacket.CODEC, (payload, context) -> RequestBlockPacket.handle(payload, () -> (ServerPlayer)context.player())).playToClient(ShowOverlayPacket.TYPE, ShowOverlayPacket.CODEC, (payload, context) -> ShowOverlayPacket.handle(payload, arg_0 -> ((IPayloadContext)context).enqueueWork(arg_0)));
    }

    public static int showOrHideFromServer(Collection<ServerPlayer> players, boolean show) {
        ShowOverlayPacket msg = new ShowOverlayPacket(show);
        for (ServerPlayer player : players) {
            player.connection.send((CustomPacketPayload)msg);
        }
        return players.size();
    }

    private static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        String configs = PluginConfig.INSTANCE.getServerConfigs();
        List<Block> shearableBlocks = HarvestToolProvider.INSTANCE.getShearableBlocks();
        if (!configs.isEmpty()) {
            Jade.LOGGER.debug("Syncing config to {} ({})", (Object)event.getEntity().getGameProfile().getName(), (Object)event.getEntity().getGameProfile().getId());
        }
        List<ResourceLocation> blockProviderIds = WailaCommonRegistration.instance().blockDataProviders.mappedIds();
        List<ResourceLocation> entityProviderIds = WailaCommonRegistration.instance().entityDataProviders.mappedIds();
        player.connection.send((CustomPacketPayload)new ServerPingPacket(configs, shearableBlocks, blockProviderIds, entityProviderIds));
    }

    @Nullable
    public static String getLastKnownUsername(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        Optional optional = SkullBlockEntity.fetchGameProfile((UUID)uuid).getNow(Optional.empty());
        if (optional.isPresent()) {
            return ((GameProfile)optional.get()).getName();
        }
        return UsernameCache.getLastKnownUsername((UUID)uuid);
    }

    public static File getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get().toFile();
    }

    public static boolean isCorrectToolForDrops(BlockState state, Player player, Level level, BlockPos pos) {
        return EventHooks.doPlayerHarvestCheck((Player)player, (BlockState)state, (BlockGetter)level, (BlockPos)pos);
    }

    public static String getModIdFromItem(ItemStack stack) {
        String key;
        CustomModelData modelData;
        if (CommonProxy.isPhysicallyClient() && !CustomModelData.DEFAULT.equals((Object)(modelData = (CustomModelData)stack.getOrDefault(DataComponents.CUSTOM_MODEL_DATA, (Object)CustomModelData.DEFAULT))) && I18n.exists((String)(key = "jade.customModelData.%s.namespace".formatted(modelData.value())))) {
            return I18n.get((String)key, (Object[])new Object[0]);
        }
        return stack.getItem().getCreatorModId(stack);
    }

    public static boolean isPhysicallyClient() {
        return FMLEnvironment.dist.isClient();
    }

    private static void registerServerCommand(RegisterCommandsEvent event) {
        JadeServerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static ItemCollector<?> createItemCollector(Accessor<?> accessor, Cache<Object, ItemCollector<?>> containerCache) {
        Container container;
        Object target = accessor.getTarget();
        if (!(target instanceof Entity) || target instanceof AbstractChestedHorse) {
            try {
                IItemHandler itemHandler = CommonProxy.findItemHandler(accessor);
                if (itemHandler != null) {
                    return (ItemCollector)containerCache.get((Object)itemHandler, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler(itemHandler, target instanceof AbstractChestedHorse ? 2 : 0)));
                }
            }
            catch (Throwable e) {
                WailaExceptionHandler.handleErr(e, null, null);
            }
        }
        if ((container = CommonProxy.findContainer(accessor)) != null) {
            if (container instanceof ChestBlockEntity) {
                return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(a -> {
                    Object patt0$temp = a.getTarget();
                    if (patt0$temp instanceof ChestBlockEntity) {
                        ChestBlock chestBlock;
                        Container compound;
                        ChestBlockEntity be = (ChestBlockEntity)patt0$temp;
                        Block patt1$temp = be.getBlockState().getBlock();
                        if (patt1$temp instanceof ChestBlock && (compound = ChestBlock.getContainer((ChestBlock)(chestBlock = (ChestBlock)patt1$temp), (BlockState)be.getBlockState(), (Level)Objects.requireNonNull(be.getLevel()), (BlockPos)be.getBlockPos(), (boolean)false)) != null) {
                            return compound;
                        }
                        return be;
                    }
                    return null;
                }, 0));
            }
            return new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(0));
        }
        return ItemCollector.EMPTY;
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> containerGroup(Container container, Accessor<?> accessor) {
        return CommonProxy.containerGroup(container, accessor, CommonProxy::findContainer);
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> containerGroup(Container container, Accessor<?> accessor, Function<Accessor<?>, Container> containerFinder) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get((Object)container, () -> new ItemCollector<Container>(new ItemIterator.ContainerItemIterator(containerFinder, 0)))).update(accessor);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> storageGroup(Object storage, Accessor<?> accessor) {
        return CommonProxy.storageGroup(storage, accessor, CommonProxy::findItemHandler);
    }

    @Nullable
    public static List<ViewGroup<ItemStack>> storageGroup(Object storage, Accessor<?> accessor, Function<Accessor<?>, Object> storageFinder) {
        try {
            return ((ItemCollector)ItemStorageProvider.containerCache.get(storage, () -> new ItemCollector<IItemHandler>(JadeForgeUtils.fromItemHandler((IItemHandler)storage, 0, storageFinder)))).update(accessor);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static IItemHandler findItemHandler(Accessor<?> accessor) {
        if (accessor instanceof BlockAccessor) {
            BlockAccessor blockAccessor = (BlockAccessor)accessor;
            return (IItemHandler)accessor.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, blockAccessor.getPosition(), blockAccessor.getBlockState(), blockAccessor.getBlockEntity(), null);
        }
        if (accessor instanceof EntityAccessor) {
            EntityAccessor entityAccessor = (EntityAccessor)accessor;
            return (IItemHandler)entityAccessor.getEntity().getCapability(Capabilities.ItemHandler.ENTITY);
        }
        return null;
    }

    @Nullable
    public static Container findContainer(Accessor<?> accessor) {
        BlockAccessor blockAccessor;
        Block block;
        Object target = accessor.getTarget();
        if (target == null && accessor instanceof BlockAccessor && (block = (blockAccessor = (BlockAccessor)accessor).getBlock()) instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            return holder.getContainer(blockAccessor.getBlockState(), (LevelAccessor)accessor.getLevel(), blockAccessor.getPosition());
        }
        if (target instanceof Container) {
            Container container = (Container)target;
            return container;
        }
        return null;
    }

    @Nullable
    public static List<ViewGroup<CompoundTag>> wrapFluidStorage(Accessor<?> accessor) {
        IFluidHandler fluidHandler = (IFluidHandler)CommonProxy.getDefaultStorage(accessor, Capabilities.FluidHandler.BLOCK, Capabilities.FluidHandler.ENTITY);
        if (fluidHandler != null) {
            return JadeForgeUtils.fromFluidHandler(fluidHandler);
        }
        return null;
    }

    @Nullable
    public static List<ViewGroup<CompoundTag>> wrapEnergyStorage(Accessor<?> accessor) {
        IEnergyStorage energyStorage = (IEnergyStorage)CommonProxy.getDefaultStorage(accessor, Capabilities.EnergyStorage.BLOCK, Capabilities.EnergyStorage.ENTITY);
        if (energyStorage != null) {
            ViewGroup<CompoundTag> group = new ViewGroup<CompoundTag>(List.of(EnergyView.of(energyStorage.getEnergyStored(), energyStorage.getMaxEnergyStored())));
            group.getExtraData().putString("Unit", "FE");
            return List.of(group);
        }
        return null;
    }

    public static boolean isDevEnv() {
        return !FMLEnvironment.production;
    }

    public static float getEnchantPowerBonus(BlockState state, Level world, BlockPos pos) {
        if (WailaClientRegistration.instance().customEnchantPowers.containsKey(state.getBlock())) {
            return WailaClientRegistration.instance().customEnchantPowers.get(state.getBlock()).getEnchantPowerBonus(state, world, pos);
        }
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public static ResourceLocation getId(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getId(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static ResourceLocation getId(BlockEntityType<?> blockEntityType) {
        return BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey(blockEntityType);
    }

    public static String getPlatformIdentifier() {
        return "neoforge";
    }

    public static MutableComponent getProfessionName(VillagerProfession profession) {
        ResourceLocation profName = BuiltInRegistries.VILLAGER_PROFESSION.getKey((Object)profession);
        return Component.translatable((String)(EntityType.VILLAGER.getDescriptionId() + "." + (String)(!"minecraft".equals(profName.getNamespace()) ? profName.getNamespace() + "." : "") + profName.getPath()));
    }

    public static boolean isBoss(Entity entity) {
        EntityType entityType = entity.getType();
        return entityType.is(Tags.EntityTypes.BOSSES) || entityType == EntityType.ENDER_DRAGON || entityType == EntityType.WITHER;
    }

    public static boolean isModLoaded(String modid) {
        try {
            return ModList.get().isLoaded(modid);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static ItemStack getBlockPickedResult(BlockState state, Player player, BlockHitResult hitResult) {
        return state.getCloneItemStack((HitResult)hitResult, (LevelReader)player.level(), hitResult.getBlockPos(), player);
    }

    public static ItemStack getEntityPickedResult(Entity entity, Player player, EntityHitResult hitResult) {
        return (ItemStack)MoreObjects.firstNonNull((Object)entity.getPickedResult((HitResult)hitResult), (Object)ItemStack.EMPTY);
    }

    public static Component getFluidName(JadeFluidObject fluid) {
        return CommonProxy.toFluidStack(fluid).getHoverName();
    }

    public static FluidStack toFluidStack(JadeFluidObject fluid) {
        int id = BuiltInRegistries.FLUID.getId((Object)fluid.getType());
        Optional holder = BuiltInRegistries.FLUID.getHolder(id);
        return holder.isEmpty() ? FluidStack.EMPTY : new FluidStack((Holder)holder.get(), (int)fluid.getAmount(), fluid.getComponents());
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        List<String> classNames = ModList.get().getAllScanData().stream().flatMap($ -> $.getAnnotations().stream()).filter($ -> {
            if ($.annotationType().getClassName().equals(WailaPlugin.class.getName())) {
                String required = $.annotationData().getOrDefault("value", "");
                return required.isEmpty() || ModList.get().isLoaded(required);
            }
            return false;
        }).map(ModFileScanData.AnnotationData::memberName).toList();
        for (String className : classNames) {
            Jade.LOGGER.info("Start loading plugin from %s".formatted(className));
            try {
                Class<?> clazz = Class.forName(className);
                if (!IWailaPlugin.class.isAssignableFrom(clazz)) continue;
                IWailaPlugin plugin = (IWailaPlugin)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                Stopwatch stopwatch = null;
                if (CommonProxy.isDevEnv()) {
                    stopwatch = Stopwatch.createStarted();
                }
                WailaCommonRegistration common = WailaCommonRegistration.instance();
                common.startSession();
                plugin.register(common);
                if (CommonProxy.isPhysicallyClient()) {
                    WailaClientRegistration client = WailaClientRegistration.instance();
                    client.startSession();
                    plugin.registerClient(client);
                    if (stopwatch != null) {
                        Jade.LOGGER.info("Bootstrapped plugin from %s in %s".formatted(className, stopwatch));
                    }
                    client.endSession();
                }
                common.endSession();
                if (stopwatch == null) continue;
                Jade.LOGGER.info("Loaded plugin from %s in %s".formatted(className, stopwatch.stop()));
            }
            catch (Throwable e) {
                Jade.LOGGER.error("Error loading plugin at %s".formatted(className), e);
                Throwables.throwIfInstanceOf((Throwable)e, IllegalStateException.class);
                if (!className.startsWith("snownee.jade.")) continue;
                ExceptionUtils.wrapAndThrow((Throwable)e);
            }
        }
        Jade.loadComplete();
    }

    public static boolean isMultipartEntity(Entity target) {
        return target.isMultipartEntity();
    }

    public static Entity wrapPartEntityParent(Entity target) {
        if (target instanceof PartEntity) {
            PartEntity part = (PartEntity)target;
            return part.getParent();
        }
        return target;
    }

    public static int getPartEntityIndex(Entity entity) {
        if (!(entity instanceof PartEntity)) {
            return -1;
        }
        PartEntity part = (PartEntity)entity;
        Entity parent = CommonProxy.wrapPartEntityParent(entity);
        PartEntity[] parts = parent.getParts();
        if (parts == null) {
            return -1;
        }
        return List.of(parts).indexOf(part);
    }

    public static Entity getPartEntity(Entity parent, int index) {
        if (parent == null) {
            return null;
        }
        if (index < 0) {
            return parent;
        }
        PartEntity[] parts = parent.getParts();
        if (parts == null || index >= parts.length) {
            return parent;
        }
        return parts[index];
    }

    public static void registerTagsUpdatedListener(BiConsumer<RegistryAccess, Boolean> listener) {
        NeoForge.EVENT_BUS.addListener(event -> listener.accept(event.getRegistryAccess(), event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED));
    }

    @Nullable
    public static <T> Map.Entry<ResourceLocation, List<ViewGroup<T>>> getServerExtensionData(Accessor<?> accessor, WrappedHierarchyLookup<IServerExtensionProvider<T>> lookup) {
        for (IServerExtensionProvider<T> provider : lookup.wrappedGet(accessor)) {
            List<ViewGroup<T>> groups;
            try {
                groups = provider.getGroups(accessor);
            }
            catch (Exception e) {
                WailaExceptionHandler.handleErr(e, provider, null);
                continue;
            }
            if (groups == null) continue;
            return Map.entry(provider.getUid(), groups);
        }
        return null;
    }
}

