/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum CropProgressProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (accessor.getBlock() == Blocks.WHEAT) {
            return IElementHelper.get().item(new ItemStack((ItemLike)Items.WHEAT));
        }
        if (accessor.getBlock() == Blocks.BEETROOTS) {
            return IElementHelper.get().item(new ItemStack((ItemLike)Items.BEETROOT));
        }
        return null;
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        BlockState state = accessor.getBlockState();
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            CropBlock crop = (CropBlock)block;
            CropProgressProvider.addMaturityTooltip(tooltip, (float)crop.getAge(state) / (float)crop.getMaxAge());
        } else if (block instanceof BushBlock || block instanceof BonemealableBlock) {
            if (state.hasProperty((Property)BlockStateProperties.AGE_2)) {
                CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)BlockStateProperties.AGE_2)).intValue() / 2.0f);
            } else if (state.hasProperty((Property)BlockStateProperties.AGE_3)) {
                CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)BlockStateProperties.AGE_3)).intValue() / 3.0f);
            } else if (state.hasProperty((Property)BlockStateProperties.AGE_4)) {
                CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)BlockStateProperties.AGE_4)).intValue() / 4.0f);
            } else if (state.hasProperty((Property)BlockStateProperties.AGE_5)) {
                CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)BlockStateProperties.AGE_5)).intValue() / 5.0f);
            } else if (state.hasProperty((Property)BlockStateProperties.AGE_7)) {
                CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)BlockStateProperties.AGE_7)).intValue() / 7.0f);
            } else if (state.hasProperty((Property)BlockStateProperties.AGE_15)) {
                CropProgressProvider.addMaturityTooltip(tooltip, (float)((Integer)state.getValue((Property)BlockStateProperties.AGE_15)).intValue() / 15.0f);
            } else if (state.is(BlockTags.MAINTAINS_FARMLAND) && accessor.getLevel().getBlockState(accessor.getPosition().below()).getBlock() instanceof FarmBlock) {
                CropProgressProvider.addMaturityTooltip(tooltip, 1.0f);
            }
        }
    }

    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        MutableComponent component = growthValue < 1.0f ? IThemeHelper.get().info(String.format("%.0f%%", Float.valueOf(growthValue * 100.0f))) : IThemeHelper.get().success(Component.translatable((String)"tooltip.jade.crop_mature"));
        tooltip.add((Component)Component.translatable((String)"tooltip.jade.crop_growth", (Object[])new Object[]{component}));
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.MC_CROP_PROGRESS;
    }
}

