/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.GuiButtonManualLink;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.links.Link;
import blusunrize.lib.manual.utils.ManualLogger;
import blusunrize.lib.manual.utils.ManualRecipeRef;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;
import org.joml.Matrix4f;

public class ManualUtils {
    public static final String THIS = "this";
    private static final Map<String, ResourceLocation> resourceMap = new HashMap<String, ResourceLocation>();

    public static boolean stackMatchesObject(ItemStack stack, ItemStack o) {
        return ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)o);
    }

    public static String getTitleForNode(Tree.AbstractNode<ResourceLocation, ManualEntry> node, ManualInstance inst) {
        if (node.isLeaf()) {
            return inst.formatEntryName(node.getLeafData().getTitle());
        }
        return inst.formatCategoryName(node.getNodeData());
    }

    public static void drawTexturedRect(GuiGraphics graphics, ResourceLocation texture, int x, int y, int w, int h, float ... uv) {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        Matrix4f mat = graphics.pose().last().pose();
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex(mat, (float)x, (float)(y + h), 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(uv[0], uv[3]);
        buffer.addVertex(mat, (float)(x + w), (float)(y + h), 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(uv[1], uv[3]);
        buffer.addVertex(mat, (float)(x + w), (float)y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(uv[1], uv[2]);
        buffer.addVertex(mat, (float)x, (float)y, 0.0f).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(uv[0], uv[2]);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    public static <T> List<T> getPrimitiveSpellingCorrections(String query, Iterable<T> valid, int maxDistance, Function<T, String> getTitle) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (T node : valid) {
            String s2 = getTitle.apply(node);
            if (s2 == null || s2.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s2) >= maxDistance) continue;
            ret.add(node);
        }
        ret.sort(Comparator.comparingInt(s -> ManualUtils.getSpellingDistanceBetweenStrings(query, (String)getTitle.apply(s))));
        return ret;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase(Locale.ENGLISH);
        target = target.toLowerCase(Locale.ENGLISH);
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += Math.abs(targetWords[iWord].length() - queryWords[iWord].length());
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static void addLinkButtons(ManualEntry entry, ManualInstance manual, ManualScreen gui, List<List<SplitResult.Token>> text, int x, int y, List<Button> pageButtons) {
        IdentityHashMap partButtons = new IdentityHashMap();
        MutableInt lineId = new MutableInt(0);
        for (List<SplitResult.Token> line : text) {
            MutableObject textUpToHere = new MutableObject((Object)"");
            for (SplitResult.Token token : line) {
                token.getContent().ifRight(arg_0 -> ManualUtils.lambda$addLinkButtons$2(manual, (Mutable)textUpToHere, lineId, entry, gui, x, y, partButtons, arg_0));
                textUpToHere.setValue((Object)((String)textUpToHere.getValue() + token.getText()));
            }
            lineId.increment();
        }
        for (List<SplitResult.Token> parts : partButtons.values()) {
            for (GuiButtonManualLink guiButtonManualLink : parts) {
                guiButtonManualLink.otherParts = parts;
                pageButtons.add(guiButtonManualLink);
            }
        }
    }

    public static String attemptStringTranslation(String tranlationKey, String arg) {
        String translated;
        String untranslated = String.format(tranlationKey, arg);
        if (!untranslated.equals(translated = I18n.get((String)untranslated, (Object[])new Object[0]))) {
            return translated;
        }
        return arg;
    }

    public static Tesselator tes() {
        return Tesselator.getInstance();
    }

    public static Minecraft mc() {
        return Minecraft.getInstance();
    }

    @Deprecated
    public static void bindTexture(ResourceLocation path) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)path);
    }

    public static void drawSplitString(GuiGraphics graphics, Font fontRenderer, List<String> text, int x, int y, int colour) {
        for (String s : text) {
            graphics.drawString(fontRenderer, s, x, y, colour, false);
            Objects.requireNonNull(fontRenderer);
            y += 9;
        }
    }

    private static void parseSpecial(JsonObject obj, String anchor, ManualInstance instance, List<ManualEntry.SpecialElementData> out) {
        String type = GsonHelper.getAsString((JsonObject)obj, (String)"type");
        int offset = GsonHelper.getAsInt((JsonObject)obj, (String)"offset", (int)0);
        ResourceLocation resLoc = ManualUtils.getLocationForManual(type, instance);
        try {
            Function<JsonObject, SpecialManualElement> createElement = instance.getElementFactory(resLoc);
            out.add(new ManualEntry.SpecialElementData(anchor, offset, () -> (SpecialManualElement)createElement.apply(obj)));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public static void parseSpecials(JsonObject data, ManualInstance instance, List<ManualEntry.SpecialElementData> out) {
        for (Map.Entry entry : data.entrySet()) {
            JsonElement currData = (JsonElement)entry.getValue();
            if (currData.isJsonObject()) {
                ManualUtils.parseSpecial(currData.getAsJsonObject(), (String)entry.getKey(), instance, out);
                continue;
            }
            for (JsonElement inner : currData.getAsJsonArray()) {
                ManualUtils.parseSpecial(inner.getAsJsonObject(), (String)entry.getKey(), instance, out);
            }
        }
    }

    public static ResourceLocation getLocationForManual(String s, ManualInstance instance) {
        if (s.indexOf(58) >= 0) {
            return ResourceLocation.parse((String)s);
        }
        return ResourceLocation.fromNamespaceAndPath((String)instance.getDefaultResourceDomain(), (String)s);
    }

    public static boolean isNumber(JsonObject main, String name) {
        return main.has(name) && main.get(name).isJsonPrimitive() && main.get(name).getAsJsonPrimitive().isNumber();
    }

    @Nullable
    public static PositionedItemStack parsePosItemStack(JsonElement ele) {
        JsonObject json = ele.getAsJsonObject();
        if (!ManualUtils.isNumber(json, "x")) {
            return null;
        }
        int x = GsonHelper.getAsInt((JsonObject)json, (String)"x");
        if (!ManualUtils.isNumber(json, "y")) {
            return null;
        }
        int y = GsonHelper.getAsInt((JsonObject)json, (String)"y");
        if (GsonHelper.isStringValue((JsonObject)json, (String)"id")) {
            return new PositionedItemStack(ManualUtils.readItemStack(json), x, y);
        }
        if (GsonHelper.isArrayNode((JsonObject)json, (String)"stacks")) {
            JsonArray arr = json.getAsJsonArray("stacks");
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(arr.size());
            for (JsonElement stack : arr) {
                stacks.add(ManualUtils.readItemStack(stack.getAsJsonObject()));
            }
            return new PositionedItemStack(stacks, x, y);
        }
        try {
            return new PositionedItemStack((Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().get()).getFirst(), x, y);
        }
        catch (JsonSyntaxException xcp) {
            return null;
        }
    }

    public static ItemStack getItemStackFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonPrimitive()) {
            ResourceLocation itemName = ManualUtils.getLocationForManual(jsonEle.getAsString(), m);
            return new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemName));
        }
        return ManualUtils.readItemStack(jsonEle.getAsJsonObject());
    }

    public static ManualRecipeRef getRecipeObjFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonObject()) {
            JsonObject json = jsonEle.getAsJsonObject();
            if (GsonHelper.isStringValue((JsonObject)json, (String)"recipe")) {
                return new ManualRecipeRef(ManualUtils.getLocationForManual(GsonHelper.getAsString((JsonObject)json, (String)"recipe"), m));
            }
            if (GsonHelper.isStringValue((JsonObject)json, (String)"id")) {
                return new ManualRecipeRef(ManualUtils.readItemStack(json));
            }
        } else {
            if (jsonEle.isJsonArray()) {
                JsonArray json = jsonEle.getAsJsonArray();
                PositionedItemStack[] stacks = new PositionedItemStack[json.size()];
                for (int i = 0; i < json.size(); ++i) {
                    PositionedItemStack posStack = ManualUtils.parsePosItemStack(json.get(i));
                    if (posStack == null) {
                        throw new RuntimeException("Failed to load positional item stack from " + String.valueOf(json.get(i)));
                    }
                    stacks[i] = posStack;
                }
                return new ManualRecipeRef(stacks);
            }
            if (jsonEle.isJsonPrimitive() && jsonEle.getAsJsonPrimitive().isString()) {
                return new ManualRecipeRef(ManualUtils.getLocationForManual(jsonEle.getAsString(), m));
            }
        }
        throw new RuntimeException("Could not find recipe for " + String.valueOf(jsonEle));
    }

    public static boolean listStack(String search, ItemStack stack) {
        return stack.getHoverName().getString().toLowerCase(Locale.ENGLISH).contains(search);
    }

    public static void renderItemStack(GuiGraphics graphics, ItemStack stack, int x, int y, boolean overlay) {
        ManualUtils.renderItemStack(graphics, stack, x, y, overlay, null);
    }

    public static void renderItemStack(GuiGraphics graphics, ItemStack stack, int x, int y, boolean overlay, String count) {
        if (stack.isEmpty()) {
            return;
        }
        graphics.renderItem(stack, x, y);
        if (overlay) {
            Font font = IClientItemExtensions.of((Item)stack.getItem()).getFont(stack, IClientItemExtensions.FontContext.ITEM_COUNT);
            font = font != null ? font : Minecraft.getInstance().font;
            graphics.renderItemDecorations(font, stack, x, y, count);
        }
    }

    private static ItemStack readItemStack(JsonObject json) {
        return (ItemStack)((Pair)ItemStack.OPTIONAL_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).result().get()).getFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <S extends AutoCloseable, R> R loadFromStream(StreamSupplier<S> streamProvider, StreamHandler<S, R> streamHandler, Supplier<String> exceptionMessage) {
        try (S stream = streamProvider.get();){
            R r = streamHandler.apply(stream);
            return r;
        }
        catch (Exception e) {
            throw new RuntimeException(exceptionMessage.get(), e);
        }
    }

    private static /* synthetic */ void lambda$addLinkButtons$2(ManualInstance manual, Mutable textUpToHere, MutableInt lineId, ManualEntry entry, ManualScreen gui, int x, int y, Map partButtons, SplitResult.LinkPart linkPart) {
        ManualInstance.ManualLink outputLink;
        int bx = manual.fontRenderer().width((String)textUpToHere.getValue());
        int n = lineId.intValue();
        Objects.requireNonNull(manual.fontRenderer());
        int by = n * 9;
        Link link = linkPart.getParent();
        String linkText = linkPart.getText();
        ResourceLocation bkey = link.getTarget(entry);
        int bw = manual.fontRenderer().width(linkText);
        ManualEntry bEntry = manual.getEntry(bkey);
        if (bEntry != null && bEntry.hasAnchor(link.getTargetAnchor())) {
            outputLink = new ManualInstance.ManualLink(bEntry, link.getTargetAnchor(), link.getTargetOffset());
        } else {
            if (bEntry == null) {
                ManualLogger.LOGGER.error("Unknown manual entry: {} (link from {})", (Object)bkey, (Object)entry.getLocation());
            } else if (!bEntry.hasAnchor(link.getTargetAnchor())) {
                ManualLogger.LOGGER.error("Unknown anchor {} in entry {} (link from {})", (Object)link.getTargetAnchor(), (Object)bkey, (Object)entry.getLocation());
            }
            outputLink = null;
        }
        Objects.requireNonNull(manual.fontRenderer());
        GuiButtonManualLink btn = new GuiButtonManualLink(gui, x + bx, y + by, bw, (int)(9.0 * 1.5), outputLink, linkText);
        partButtons.computeIfAbsent(link, l -> new ArrayList()).add(btn);
    }

    @FunctionalInterface
    public static interface StreamSupplier<S extends AutoCloseable> {
        public S get() throws Exception;
    }

    @FunctionalInterface
    public static interface StreamHandler<S extends AutoCloseable, R> {
        public R apply(S var1) throws Exception;
    }
}

