/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.sound;

import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.mixin.accessors.client.GuiSubtitleOverlayAccess;
import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class MultiblockSound
extends AbstractTickableSoundInstance {
    private final BooleanSupplier active;
    private final BooleanSupplier valid;
    private final float maxVolume;
    private long subtitleMillis;

    public MultiblockSound(BooleanSupplier active, BooleanSupplier valid, Vec3 pos, SoundEvent sound, boolean loop, float maxVolume) {
        super(sound, SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.active = active;
        this.valid = valid;
        this.x = pos.x;
        this.y = pos.y;
        this.z = pos.z;
        this.looping = loop;
        this.volume = 0.0f;
        this.maxVolume = maxVolume;
        this.subtitleMillis = Util.getMillis();
    }

    public static BooleanSupplier startSound(BooleanSupplier active, BooleanSupplier valid, Vec3 pos, Holder<SoundEvent> sound, float maxVolume) {
        return MultiblockSound.startSound(active, valid, pos, sound, true, maxVolume);
    }

    public static BooleanSupplier startSound(BooleanSupplier active, BooleanSupplier valid, Vec3 pos, Holder<SoundEvent> sound, boolean loop, float maxVolume) {
        MultiblockSound instance = new MultiblockSound(active, valid, pos, (SoundEvent)sound.value(), loop, maxVolume);
        SoundManager soundManager = Minecraft.getInstance().getSoundManager();
        soundManager.play((SoundInstance)instance);
        return () -> soundManager.isActive((SoundInstance)instance);
    }

    public boolean canStartSilent() {
        return true;
    }

    public void tick() {
        if (!this.valid.getAsBoolean()) {
            this.stop();
        } else if (this.active.getAsBoolean()) {
            long currentMillis = Util.getMillis();
            if (currentMillis - this.subtitleMillis > 1000L) {
                SoundManager soundManager = Minecraft.getInstance().getSoundManager();
                WeighedSoundEvents weighedsoundevents = this.resolve(soundManager);
                if (weighedsoundevents != null) {
                    ((GuiSubtitleOverlayAccess)ClientUtils.mc().gui).getSubtitleOverlay().onPlaySound((SoundInstance)this, weighedsoundevents, 16.0f);
                }
                this.subtitleMillis = currentMillis;
            }
            this.volume = this.maxVolume;
        } else {
            this.volume = 0.0f;
        }
    }
}

