/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.loot;

import blusunrize.immersiveengineering.common.util.loot.IELootFunctions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.phys.Vec3;

public record LootBlockStateFromLocationPredicate(Holder<Block> block, Optional<StatePropertiesPredicate> properties) implements LootItemCondition
{
    public static final MapCodec<LootBlockStateFromLocationPredicate> CODEC = RecordCodecBuilder.mapCodec(kind -> kind.group((App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("block").forGetter(LootBlockStateFromLocationPredicate::block), (App)StatePropertiesPredicate.CODEC.optionalFieldOf("properties").forGetter(LootBlockStateFromLocationPredicate::properties)).apply((Applicative)kind, LootBlockStateFromLocationPredicate::new)).validate(LootBlockStateFromLocationPredicate::validate);

    private static DataResult<LootBlockStateFromLocationPredicate> validate(LootBlockStateFromLocationPredicate condition) {
        return condition.properties().flatMap(predicate -> predicate.checkState(((Block)condition.block().value()).getStateDefinition())).map(property -> DataResult.error(() -> "Block " + String.valueOf(condition.block()) + " has no property" + property)).orElse(DataResult.success((Object)condition));
    }

    @Nonnull
    public LootItemConditionType getType() {
        return (LootItemConditionType)IELootFunctions.BLOCKSTATE.value();
    }

    public boolean test(LootContext lootContext) {
        Vec3 pos = (Vec3)lootContext.getParamOrNull(LootContextParams.ORIGIN);
        if (pos == null) {
            return false;
        }
        BlockState blockstate = lootContext.getLevel().getBlockState(BlockPos.containing((Position)pos));
        return blockstate.is(this.block) && (this.properties.isEmpty() || this.properties.get().matches(blockstate));
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private final Holder<Block> block;
        private Optional<StatePropertiesPredicate> properties = Optional.empty();

        public Builder(Block block) {
            this.block = block.builtInRegistryHolder();
        }

        public Builder setProperties(StatePropertiesPredicate.Builder statePredicateBuilder) {
            this.properties = statePredicateBuilder.build();
            return this;
        }

        public LootItemCondition build() {
            return new LootBlockStateFromLocationPredicate(this.block, this.properties);
        }
    }
}

