/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei;

import blusunrize.immersiveengineering.client.gui.IEContainerScreen;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.network.MessageSetGhostSlots;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class IEGhostItemHandler
implements IGhostIngredientHandler<IEContainerScreen> {
    public <I> List<IGhostIngredientHandler.Target<I>> getTargetsTyped(IEContainerScreen gui, ITypedIngredient<I> ingredient, boolean doStart) {
        Optional ingr = ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK);
        if (ingr.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Slot s : gui.getMenu().slots) {
            if (!(s instanceof IESlot.ItemHandlerGhost)) continue;
            builder.add((Object)new GhostSlotTarget((IESlot.ItemHandlerGhost)s, gui));
        }
        return builder.build();
    }

    public void onComplete() {
    }

    private static class GhostSlotTarget
    implements IGhostIngredientHandler.Target<ItemStack> {
        final IESlot.ItemHandlerGhost slot;
        final IEContainerScreen<?> gui;
        Rect2i area;
        int lastGuiLeft;
        int lastGuiTop;

        public GhostSlotTarget(IESlot.ItemHandlerGhost slot, IEContainerScreen<?> gui) {
            this.slot = slot;
            this.gui = gui;
            this.initRectangle();
        }

        private void initRectangle() {
            this.area = new Rect2i(this.gui.getGuiLeft() + this.slot.x, this.gui.getGuiTop() + this.slot.y, 16, 16);
            this.lastGuiLeft = this.gui.getGuiLeft();
            this.lastGuiTop = this.gui.getGuiTop();
        }

        public Rect2i getArea() {
            if (this.lastGuiLeft != this.gui.getGuiLeft() || this.lastGuiTop != this.gui.getGuiTop()) {
                this.initRectangle();
            }
            return this.area;
        }

        public void accept(ItemStack ingredient) {
            Int2ObjectOpenHashMap change = new Int2ObjectOpenHashMap();
            change.put(((Slot)this.slot).index, (Object)ingredient);
            PacketDistributor.sendToServer((CustomPacketPayload)new MessageSetGhostSlots((Map<Integer, ItemStack>)change), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

