/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class WorldMap<Key, Value> {
    private final Map<ResourceKey<Level>, Map<Key, Value>> map = new HashMap<ResourceKey<Level>, Map<Key, Value>>();

    @Nullable
    public Value get(Level world, Key key) {
        Preconditions.checkArgument((!world.isClientSide ? 1 : 0) != 0);
        Map<Key, Value> worldMap = this.map.get(world.dimension());
        if (worldMap == null) {
            return null;
        }
        return worldMap.get(key);
    }

    public void put(Level world, Key key, Value value) {
        Preconditions.checkArgument((!world.isClientSide ? 1 : 0) != 0);
        Map worldMap = this.map.computeIfAbsent((ResourceKey<Level>)world.dimension(), $ -> new HashMap());
        worldMap.put(key, value);
    }

    public void clearDimension(Level world) {
        Preconditions.checkArgument((!world.isClientSide ? 1 : 0) != 0);
        this.map.remove(world.dimension());
    }

    public void clear() {
        this.map.clear();
    }
}

