/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class IEBlockCapabilityCaches {
    public static <T, C> IEBlockCapabilityCache<T> create(BlockCapability<T, C> capability, Supplier<BlockPos> getPosition, Supplier<C> getContext, Supplier<@Nullable Level> getLevel) {
        return new IEBlockCapCacheImpl<T, C>(capability, getPosition, getContext, getLevel);
    }

    public static <T> IEBlockCapabilityCache<T> forNeighbor(BlockCapability<T, Direction> capability, BlockEntity be, Supplier<Direction> neighborDirection) {
        return IEBlockCapabilityCaches.create(capability, () -> be.getBlockPos().relative((Direction)neighborDirection.get()), () -> ((Direction)neighborDirection.get()).getOpposite(), () -> ((BlockEntity)be).getLevel());
    }

    public static <T> Map<Direction, IEBlockCapabilityCache<T>> allNeighbors(BlockCapability<T, Direction> capability, BlockEntity be) {
        EnumMap<Direction, IEBlockCapabilityCache<T>> result = new EnumMap<Direction, IEBlockCapabilityCache<T>>(Direction.class);
        for (Direction offset : Direction.values()) {
            result.put(offset, IEBlockCapabilityCaches.forNeighbor(capability, be, () -> offset));
        }
        return result;
    }

    private static class IEBlockCapCacheImpl<T, C>
    implements IEBlockCapabilityCache<T> {
        private final BlockCapability<T, C> capability;
        private final Supplier<BlockPos> getPosition;
        private final Supplier<C> getContext;
        private final Supplier<@Nullable Level> getLevel;
        private BlockCapabilityCache<T, C> cache;

        private IEBlockCapCacheImpl(BlockCapability<T, C> capability, Supplier<BlockPos> getPosition, Supplier<C> getContext, Supplier<@Nullable Level> getLevel) {
            this.capability = capability;
            this.getPosition = getPosition;
            this.getContext = getContext;
            this.getLevel = getLevel;
        }

        @Override
        public T getCapability() {
            C currentCtx = this.getContext.get();
            BlockPos currentPos = this.getPosition.get();
            Level level = this.getLevel.get();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.isCacheInvalid(level, currentPos, currentCtx)) {
                    this.cache = BlockCapabilityCache.create(this.capability, (ServerLevel)serverLevel, (BlockPos)currentPos, currentCtx);
                }
                return (T)this.cache.getCapability();
            }
            if (level == null) {
                return null;
            }
            this.cache = null;
            return (T)level.getCapability(this.capability, currentPos, currentCtx);
        }

        private boolean isCacheInvalid(Level level, BlockPos pos, C context) {
            if (this.cache == null) {
                return true;
            }
            if (!Objects.equals(this.cache.context(), context)) {
                return true;
            }
            if (!Objects.equals(this.cache.pos(), pos)) {
                return true;
            }
            return level != this.cache.level();
        }
    }

    public static interface IEBlockCapabilityCache<T> {
        public T getCapability();
    }
}

