/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.register;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.conveyor.ConveyorHandler;
import blusunrize.immersiveengineering.api.tool.conveyor.IConveyorType;
import blusunrize.immersiveengineering.common.blocks.BlockIESlab;
import blusunrize.immersiveengineering.common.blocks.BlockItemIE;
import blusunrize.immersiveengineering.common.blocks.CrateBlock;
import blusunrize.immersiveengineering.common.blocks.FakeLightBlock;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.blocks.IEDoorBlock;
import blusunrize.immersiveengineering.common.blocks.IEEntityBlock;
import blusunrize.immersiveengineering.common.blocks.IESignBlocks;
import blusunrize.immersiveengineering.common.blocks.IEStairsBlock;
import blusunrize.immersiveengineering.common.blocks.IETrapDoorBlock;
import blusunrize.immersiveengineering.common.blocks.IEWallBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.BalloonBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.BlockItemBalloon;
import blusunrize.immersiveengineering.common.blocks.cloth.CushionBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.StripCurtainBlock;
import blusunrize.immersiveengineering.common.blocks.generic.AnyFacingEntityBlock;
import blusunrize.immersiveengineering.common.blocks.generic.CatwalkBlock;
import blusunrize.immersiveengineering.common.blocks.generic.CatwalkStairsBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.HorizontalFacingBlock;
import blusunrize.immersiveengineering.common.blocks.generic.HorizontalFacingEntityBlock;
import blusunrize.immersiveengineering.common.blocks.generic.PostBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ScaffoldingBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WallmountBlock;
import blusunrize.immersiveengineering.common.blocks.generic.WindowBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BasicConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BlastFurnacePreheaterBlock;
import blusunrize.immersiveengineering.common.blocks.metal.BreakerSwitchBlock;
import blusunrize.immersiveengineering.common.blocks.metal.CagelampBlock;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.CapacitorCreativeBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ChargingStationBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ChuteBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ClocheBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ConveyorBlock;
import blusunrize.immersiveengineering.common.blocks.metal.DynamoBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ElectricLanternBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ElectromagnetBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyMeterBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FloodlightBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPipeBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPlacerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.FluidPumpBlock;
import blusunrize.immersiveengineering.common.blocks.metal.FurnaceHeaterBlock;
import blusunrize.immersiveengineering.common.blocks.metal.LanternBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalLadderBlock;
import blusunrize.immersiveengineering.common.blocks.metal.MetalScaffoldingType;
import blusunrize.immersiveengineering.common.blocks.metal.PipeValveBlock;
import blusunrize.immersiveengineering.common.blocks.metal.PostTransformerBlock;
import blusunrize.immersiveengineering.common.blocks.metal.RazorWireBlock;
import blusunrize.immersiveengineering.common.blocks.metal.SampleDrillBlock;
import blusunrize.immersiveengineering.common.blocks.metal.StructuralArmBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TeslaCoilBlock;
import blusunrize.immersiveengineering.common.blocks.metal.ThermoelectricGenBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.ToolboxBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TransformerBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TransformerBlockItem;
import blusunrize.immersiveengineering.common.blocks.metal.TransformerHVBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TurretBlock;
import blusunrize.immersiveengineering.common.blocks.metal.TurretChemBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.TurretGunBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.WarningSignBlock;
import blusunrize.immersiveengineering.common.blocks.plant.HempBlock;
import blusunrize.immersiveengineering.common.blocks.plant.PottedHempBlock;
import blusunrize.immersiveengineering.common.blocks.stone.CoresampleBlockEntity;
import blusunrize.immersiveengineering.common.blocks.stone.PartialConcreteBlock;
import blusunrize.immersiveengineering.common.blocks.stone.SlagGravelBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.BarrelBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.BlueprintShelfBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.CircuitTableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.CraftingTableBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.DeskBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.FluidSorterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.GunpowderBarrelBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.ItemBatcherBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.LogicUnitBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.MachineInterfaceBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.SawdustBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.blocks.wooden.TreatedWoodStyles;
import blusunrize.immersiveengineering.common.blocks.wooden.TurntableBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.WatermillBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.WindmillBlock;
import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import com.google.common.base.Preconditions;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class IEBlocks {
    public static final DeferredRegister<Block> REGISTER = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"immersiveengineering");
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_PROPS = () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.STONE).requiresCorrectToolForDrops().strength(2.0f, 10.0f);
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_STONE_BRICK_PROPS = () -> BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.75f, 10.0f);
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_LEADED_PROPS = () -> BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 100.0f);
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_REINFORCED_PROPS = () -> BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(20.0f, 1200.0f);
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_PROPS_NOT_SOLID = () -> BlockBehaviour.Properties.of().sound(SoundType.STONE).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(0.5f, 0.5f).noOcclusion();
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_BRICK_PROPS = () -> BlockBehaviour.Properties.of().sound(SoundType.NETHER_BRICKS).mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 8.0f);
    private static final Supplier<BlockBehaviour.Properties> STONE_DECO_GBRICK_PROPS = () -> BlockBehaviour.Properties.of().sound(SoundType.NETHER_BRICKS).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(2.0f, 8.0f);
    private static final Supplier<BlockBehaviour.Properties> SHEETMETAL_PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(2.0f, 2.0f);
    private static final Supplier<BlockBehaviour.Properties> STANDARD_WOOD_PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.WOOD).strength(2.0f, 5.0f);
    private static final Supplier<BlockBehaviour.Properties> STANDARD_WOOD_PROPERTIES_NO_OVERLAY = () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.WOOD).strength(2.0f, 5.0f).isViewBlocking((state, blockReader, pos) -> false);
    private static final Supplier<BlockBehaviour.Properties> STANDARD_WOOD_PROPERTIES_NO_OCCLUSION = () -> STANDARD_WOOD_PROPERTIES_NO_OVERLAY.get().noOcclusion().forceSolidOn();
    private static final Supplier<BlockBehaviour.Properties> DEFAULT_METAL_PROPERTIES = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).requiresCorrectToolForDrops().strength(3.0f, 15.0f);
    private static final Supplier<BlockBehaviour.Properties> METAL_PROPERTIES_NO_OVERLAY = () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(3.0f, 15.0f).requiresCorrectToolForDrops().isViewBlocking((state, blockReader, pos) -> false);
    public static final Supplier<BlockBehaviour.Properties> METAL_PROPERTIES_NO_OCCLUSION = () -> METAL_PROPERTIES_NO_OVERLAY.get().noOcclusion().forceSolidOn();
    private static final Supplier<BlockBehaviour.Properties> METAL_PROPERTIES_DYNAMIC = () -> METAL_PROPERTIES_NO_OCCLUSION.get().dynamicShape();
    public static final Map<ResourceLocation, BlockEntry<SlabBlock>> TO_SLAB = new HashMap<ResourceLocation, BlockEntry<SlabBlock>>();
    public static final Map<ResourceLocation, BlockEntry<IEStairsBlock>> TO_STAIRS = new HashMap<ResourceLocation, BlockEntry<IEStairsBlock>>();
    public static final Map<ResourceLocation, BlockEntry<IEWallBlock>> TO_WALL = new HashMap<ResourceLocation, BlockEntry<IEWallBlock>>();

    private IEBlocks() {
    }

    private static <T extends Block> void registerStairs(BlockEntry<T> fullBlock) {
        TO_STAIRS.put(fullBlock.getId(), new BlockEntry<IEStairsBlock>("stairs_" + fullBlock.getId().getPath(), fullBlock::getProperties, p -> new IEStairsBlock((BlockBehaviour.Properties)p, fullBlock)));
    }

    private static <T extends Block> void registerSlab(BlockEntry<T> fullBlock) {
        TO_SLAB.put(fullBlock.getId(), new BlockEntry<SlabBlock>("slab_" + fullBlock.getId().getPath(), fullBlock::getProperties, p -> new BlockIESlab((BlockBehaviour.Properties)p, fullBlock)));
    }

    private static <T extends Block> void registerWall(BlockEntry<T> fullBlock) {
        TO_WALL.put(fullBlock.getId(), new BlockEntry<IEWallBlock>("wall_" + fullBlock.getId().getPath(), fullBlock::getProperties, p -> new IEWallBlock((BlockBehaviour.Properties)p, fullBlock)));
    }

    private static Supplier<BlockBehaviour.Properties> dynamicShape(Supplier<BlockBehaviour.Properties> baseProps) {
        return () -> ((BlockBehaviour.Properties)baseProps.get()).dynamicShape();
    }

    public static void init(IEventBus modBus) {
        REGISTER.register(modBus);
        StoneDecoration.init();
        Metals.init();
        WoodenDecoration.init();
        WoodenDevices.init();
        MetalDecoration.init();
        MetalDevices.init();
        Connectors.init();
        Cloth.init();
        Misc.init();
        IEBlocks.registerSlab(StoneDecoration.COKEBRICK);
        IEBlocks.registerSlab(StoneDecoration.BLASTBRICK);
        IEBlocks.registerSlab(StoneDecoration.BLASTBRICK_REINFORCED);
        IEBlocks.registerSlab(StoneDecoration.SLAG_BRICK);
        IEBlocks.registerSlab(StoneDecoration.CLINKER_BRICK);
        IEBlocks.registerSlab(StoneDecoration.COKE);
        IEBlocks.registerSlab(StoneDecoration.HEMPCRETE);
        IEBlocks.registerSlab(StoneDecoration.HEMPCRETE_BRICK);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE_BRICK);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE_TILE);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE_LEADED);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE_REINFORCED);
        IEBlocks.registerSlab(StoneDecoration.CONCRETE_REINFORCED_TILE);
        IEBlocks.registerSlab(StoneDecoration.INSULATING_GLASS);
        IEBlocks.registerSlab(StoneDecoration.ALLOYBRICK);
        IEBlocks.registerStairs(StoneDecoration.SLAG_BRICK);
        IEBlocks.registerStairs(StoneDecoration.CLINKER_BRICK);
        IEBlocks.registerStairs(StoneDecoration.HEMPCRETE);
        IEBlocks.registerStairs(StoneDecoration.HEMPCRETE_BRICK);
        IEBlocks.registerStairs(StoneDecoration.CONCRETE);
        IEBlocks.registerStairs(StoneDecoration.CONCRETE_BRICK);
        IEBlocks.registerStairs(StoneDecoration.CONCRETE_TILE);
        IEBlocks.registerStairs(StoneDecoration.CONCRETE_LEADED);
        IEBlocks.registerWall(StoneDecoration.SLAG_BRICK);
        IEBlocks.registerWall(StoneDecoration.CLINKER_BRICK);
        IEBlocks.registerWall(StoneDecoration.HEMPCRETE);
        IEBlocks.registerWall(StoneDecoration.HEMPCRETE_BRICK);
        IEBlocks.registerWall(StoneDecoration.CONCRETE);
        IEBlocks.registerWall(StoneDecoration.CONCRETE_BRICK);
        IEBlocks.registerWall(StoneDecoration.CONCRETE_TILE);
        IEBlocks.registerWall(StoneDecoration.CONCRETE_LEADED);
        for (BlockEntry<?> entry : BlockEntry.ALL_ENTRIES) {
            if (entry == Misc.FAKE_LIGHT || entry == Misc.POTTED_HEMP || entry == StoneDecoration.CORESAMPLE || entry == MetalDevices.TOOLBOX || entry == Cloth.SHADER_BANNER || entry == Cloth.SHADER_BANNER_WALL || WoodenDecoration.SIGN.matchesEntries(entry) || MetalDecoration.STEEL_SIGN.matchesEntries(entry) || MetalDecoration.ALU_SIGN.matchesEntries(entry) || entry == Misc.HEMP_PLANT || entry == Connectors.POST_TRANSFORMER || IEFluids.ALL_FLUID_BLOCKS.contains(entry)) continue;
            Function<Block, BlockItemIE> toItem = entry == Cloth.BALLOON ? BlockItemBalloon::new : (entry == Connectors.TRANSFORMER ? TransformerBlockItem::new : (entry == WoodenDevices.CRATE || entry == WoodenDevices.REINFORCED_CRATE ? b -> new BlockItemIE((Block)b, new Item.Properties().stacksTo(1)) : BlockItemIE::new));
            if (entry == StoneDecoration.COKE) {
                toItem = toItem.andThen(b -> b.setBurnTime(32000));
            }
            Function<Block, BlockItemIE> finalToItem = toItem;
            IEItems.REGISTER.register(entry.getId().getPath(), () -> (BlockItemIE)((Object)((Object)finalToItem.apply((Block)entry.get()))));
        }
        WoodenDecoration.SIGN.registerItems(IEItems.REGISTER);
        MetalDecoration.STEEL_SIGN.registerItems(IEItems.REGISTER);
        MetalDecoration.ALU_SIGN.registerItems(IEItems.REGISTER);
    }

    public static final class BlockEntry<T extends Block>
    implements Supplier<T>,
    ItemLike {
        public static final Collection<BlockEntry<?>> ALL_ENTRIES = new ArrayList();
        private final DeferredHolder<Block, T> regObject;
        private final Supplier<BlockBehaviour.Properties> properties;

        public static BlockEntry<IEBaseBlock> simple(String name, Supplier<BlockBehaviour.Properties> properties, Consumer<IEBaseBlock> extra) {
            return new BlockEntry<IEBaseBlock>(name, properties, p -> (IEBaseBlock)Util.make((Object)new IEBaseBlock((BlockBehaviour.Properties)p), (Consumer)extra));
        }

        public static BlockEntry<IEBaseBlock> simple(String name, Supplier<BlockBehaviour.Properties> properties) {
            return BlockEntry.simple(name, properties, $ -> {});
        }

        public static BlockEntry<IEEntityBlock<?>> barrel(String name, boolean metal) {
            return new BlockEntry(name, () -> BarrelBlock.getProperties(metal), p -> BarrelBlock.make(p, metal));
        }

        public static BlockEntry<ScaffoldingBlock> scaffolding(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<ScaffoldingBlock>(name, props, ScaffoldingBlock::new);
        }

        public static BlockEntry<FenceBlock> fence(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<FenceBlock>(name, props, FenceBlock::new);
        }

        public static BlockEntry<PostBlock> post(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<PostBlock>(name, IEBlocks.dynamicShape(props), PostBlock::new);
        }

        public static BlockEntry<WallmountBlock> wallmount(String name, Supplier<BlockBehaviour.Properties> props) {
            return new BlockEntry<WallmountBlock>(name, props, WallmountBlock::new);
        }

        public BlockEntry(String name, Supplier<BlockBehaviour.Properties> properties, Function<BlockBehaviour.Properties, T> make) {
            this.properties = properties;
            this.regObject = REGISTER.register(name, () -> (Block)make.apply((BlockBehaviour.Properties)properties.get()));
            ALL_ENTRIES.add(this);
        }

        public BlockEntry(T existing) {
            this.properties = () -> BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)existing);
            this.regObject = DeferredHolder.create((ResourceKey)Registries.BLOCK, (ResourceLocation)BuiltInRegistries.BLOCK.getKey(existing));
        }

        public BlockEntry(BlockEntry<? extends T> toCopy) {
            this.properties = toCopy.properties;
            this.regObject = toCopy.regObject;
        }

        @Override
        public T get() {
            return (T)((Block)this.regObject.get());
        }

        public BlockState defaultBlockState() {
            return this.get().defaultBlockState();
        }

        public ResourceLocation getId() {
            return this.regObject.getId();
        }

        public BlockBehaviour.Properties getProperties() {
            return this.properties.get();
        }

        @Nonnull
        public Item asItem() {
            return this.get().asItem();
        }
    }

    public static final class StoneDecoration {
        public static final BlockEntry<IEBaseBlock> COKEBRICK = BlockEntry.simple("cokebrick", STONE_DECO_GBRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> BLASTBRICK = BlockEntry.simple("blastbrick", STONE_DECO_BRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> BLASTBRICK_REINFORCED = BlockEntry.simple("blastbrick_reinforced", () -> BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_RED).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.NETHER_BRICKS).requiresCorrectToolForDrops().strength(2.5f, 12.0f));
        public static final BlockEntry<IEBaseBlock> ALLOYBRICK = BlockEntry.simple("alloybrick", STONE_DECO_GBRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> SLAG_BRICK = BlockEntry.simple("slag_brick", STONE_DECO_GBRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> CLINKER_BRICK = BlockEntry.simple("clinker_brick", STONE_DECO_BRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> CLINKER_BRICK_SILL = BlockEntry.simple("clinker_brick_sill", STONE_DECO_BRICK_PROPS);
        public static final BlockEntry<HorizontalFacingBlock> CLINKER_BRICK_QUOIN = new BlockEntry<HorizontalFacingBlock>("clinker_brick_quoin", STONE_DECO_BRICK_PROPS, HorizontalFacingBlock::new);
        public static final BlockEntry<IEBaseBlock> COKE = BlockEntry.simple("coke", () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.STONE).requiresCorrectToolForDrops().strength(5.0f, 6.0f));
        public static final BlockEntry<SlagGravelBlock> SLAG_GRAVEL = new BlockEntry<SlagGravelBlock>("slag_gravel", () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.SNARE).strength(0.6f).sound(SoundType.GRAVEL), SlagGravelBlock::new);
        public static final BlockEntry<FallingBlock> GRIT_SAND = new BlockEntry<FallingBlock>("grit_sand", () -> BlockBehaviour.Properties.of().mapColor(MapColor.SAND).instrument(NoteBlockInstrument.SNARE).strength(0.6f).sound(SoundType.GRAVEL), SlagGravelBlock::new);
        public static final BlockEntry<IEBaseBlock> HEMPCRETE = BlockEntry.simple("hempcrete", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> HEMPCRETE_BRICK = BlockEntry.simple("hempcrete_brick", STONE_DECO_STONE_BRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> HEMPCRETE_BRICK_CRACKED = BlockEntry.simple("hempcrete_brick_cracked", STONE_DECO_STONE_BRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> HEMPCRETE_CHISELED = BlockEntry.simple("hempcrete_chiseled", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> HEMPCRETE_PILLAR = BlockEntry.simple("hempcrete_pillar", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE = BlockEntry.simple("concrete", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_BRICK = BlockEntry.simple("concrete_brick", STONE_DECO_STONE_BRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_BRICK_CRACKED = BlockEntry.simple("concrete_brick_cracked", STONE_DECO_STONE_BRICK_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_CHISELED = BlockEntry.simple("concrete_chiseled", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_PILLAR = BlockEntry.simple("concrete_pillar", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_TILE = BlockEntry.simple("concrete_tile", STONE_DECO_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_LEADED = BlockEntry.simple("concrete_leaded", STONE_DECO_LEADED_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_REINFORCED = BlockEntry.simple("concrete_reinforced", STONE_DECO_REINFORCED_PROPS);
        public static final BlockEntry<IEBaseBlock> CONCRETE_REINFORCED_TILE = BlockEntry.simple("concrete_reinforced_tile", STONE_DECO_REINFORCED_PROPS);
        public static final BlockEntry<IEBaseBlock> INSULATING_GLASS = BlockEntry.simple("insulating_glass", STONE_DECO_PROPS_NOT_SOLID);
        public static final BlockEntry<IEBaseBlock> SLAG_GLASS = BlockEntry.simple("slag_glass", STONE_DECO_PROPS_NOT_SOLID, shouldHave -> shouldHave.setLightOpacity(8));
        public static final BlockEntry<IEBaseBlock> CONCRETE_SPRAYED = BlockEntry.simple("concrete_sprayed", () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(0.2f, 1.0f).noOcclusion());
        public static final BlockEntry<PartialConcreteBlock> CONCRETE_SHEET = new BlockEntry<PartialConcreteBlock>("concrete_sheet", PartialConcreteBlock::makeProperties, props -> new PartialConcreteBlock((BlockBehaviour.Properties)props, 1));
        public static final BlockEntry<PartialConcreteBlock> CONCRETE_QUARTER = new BlockEntry<PartialConcreteBlock>("concrete_quarter", PartialConcreteBlock::makeProperties, props -> new PartialConcreteBlock((BlockBehaviour.Properties)props, 4));
        public static final BlockEntry<PartialConcreteBlock> CONCRETE_THREE_QUARTER = new BlockEntry<PartialConcreteBlock>("concrete_three_quarter", PartialConcreteBlock::makeProperties, props -> new PartialConcreteBlock((BlockBehaviour.Properties)props, 12));
        public static final BlockEntry<HorizontalFacingEntityBlock<CoresampleBlockEntity>> CORESAMPLE = new BlockEntry<HorizontalFacingEntityBlock>("coresample", IEBlocks.dynamicShape(STONE_DECO_PROPS_NOT_SOLID), p -> new HorizontalFacingEntityBlock(IEBlockEntities.CORE_SAMPLE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEBaseBlock> DUROPLAST = BlockEntry.simple("duroplast", STONE_DECO_PROPS_NOT_SOLID);

        private static void init() {
        }
    }

    public static final class Metals {
        public static final Map<EnumMetals, BlockEntry<Block>> ORES = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<Block>> DEEPSLATE_ORES = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<Block>> RAW_ORES = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<Block>> STORAGE = new EnumMap<EnumMetals, BlockEntry<Block>>(EnumMetals.class);
        public static final Map<EnumMetals, BlockEntry<IEBaseBlock>> SHEETMETAL = new EnumMap<EnumMetals, BlockEntry<IEBaseBlock>>(EnumMetals.class);

        private static void init() {
            for (EnumMetals m : EnumMetals.values()) {
                BlockEntry<Block> storage;
                String name = m.tagName();
                BlockEntry<IEBaseBlock> ore = null;
                BlockEntry<IEBaseBlock> deepslateOre = null;
                BlockEntry<IEBaseBlock> rawOre = null;
                BlockEntry<IEBaseBlock> sheetmetal = BlockEntry.simple("sheetmetal_" + name, SHEETMETAL_PROPERTIES);
                IEBlocks.registerSlab(sheetmetal);
                SHEETMETAL.put(m, sheetmetal);
                if (m.shouldAddOre()) {
                    ore = new BlockEntry<IEBaseBlock>(BlockEntry.simple("ore_" + name, () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(3.0f, 3.0f).requiresCorrectToolForDrops()));
                    deepslateOre = new BlockEntry<IEBaseBlock>(BlockEntry.simple("deepslate_ore_" + name, () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).mapColor(MapColor.DEEPSLATE).sound(SoundType.DEEPSLATE).strength(4.5f, 3.0f).requiresCorrectToolForDrops()));
                    rawOre = new BlockEntry<IEBaseBlock>(BlockEntry.simple("raw_block_" + name, () -> BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).strength(5.0f, 6.0f).requiresCorrectToolForDrops()));
                }
                if (!m.isVanillaMetal()) {
                    BlockEntry<IEBaseBlock> storageIE = BlockEntry.simple("storage_" + name, () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(m == EnumMetals.STEEL ? SoundType.NETHERITE_BLOCK : SoundType.METAL).strength(5.0f, 10.0f).requiresCorrectToolForDrops());
                    IEBlocks.registerSlab(storageIE);
                    storage = new BlockEntry<IEBaseBlock>(storageIE);
                } else if (m == EnumMetals.IRON) {
                    storage = new BlockEntry<Block>(Blocks.IRON_BLOCK);
                    ore = new BlockEntry<Block>(Blocks.IRON_ORE);
                    deepslateOre = new BlockEntry<Block>(Blocks.DEEPSLATE_IRON_ORE);
                    rawOre = new BlockEntry<Block>(Blocks.RAW_IRON_BLOCK);
                } else if (m == EnumMetals.GOLD) {
                    storage = new BlockEntry<Block>(Blocks.GOLD_BLOCK);
                    ore = new BlockEntry<Block>(Blocks.GOLD_ORE);
                    deepslateOre = new BlockEntry<Block>(Blocks.DEEPSLATE_GOLD_ORE);
                    rawOre = new BlockEntry<Block>(Blocks.RAW_GOLD_BLOCK);
                } else if (m == EnumMetals.COPPER) {
                    storage = new BlockEntry<Block>(Blocks.COPPER_BLOCK);
                    ore = new BlockEntry<Block>(Blocks.COPPER_ORE);
                    deepslateOre = new BlockEntry<Block>(Blocks.DEEPSLATE_COPPER_ORE);
                    rawOre = new BlockEntry<Block>(Blocks.RAW_COPPER_BLOCK);
                } else {
                    throw new RuntimeException("Unkown vanilla metal: " + m.name());
                }
                STORAGE.put(m, storage);
                if (ore != null) {
                    ORES.put(m, ore);
                }
                if (deepslateOre != null) {
                    DEEPSLATE_ORES.put(m, deepslateOre);
                }
                if (deepslateOre == null) continue;
                RAW_ORES.put(m, rawOre);
            }
        }
    }

    public static final class WoodenDecoration {
        public static final Map<TreatedWoodStyles, BlockEntry<IEBaseBlock>> TREATED_WOOD = new EnumMap<TreatedWoodStyles, BlockEntry<IEBaseBlock>>(TreatedWoodStyles.class);
        public static final BlockEntry<FenceBlock> TREATED_FENCE = BlockEntry.fence("treated_fence", STANDARD_WOOD_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<FenceGateBlock> TREATED_FENCE_GATE = new BlockEntry<FenceGateBlock>("treated_fence_gate", STANDARD_WOOD_PROPERTIES_NO_OVERLAY, blockProps -> new FenceGateBlock(blockProps, SoundEvents.FENCE_GATE_OPEN, SoundEvents.FENCE_GATE_CLOSE));
        public static final BlockEntry<ScaffoldingBlock> TREATED_SCAFFOLDING = BlockEntry.scaffolding("treated_scaffold", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION);
        public static final BlockEntry<PostBlock> TREATED_POST = BlockEntry.post("treated_post", STANDARD_WOOD_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<SawdustBlock> SAWDUST = new BlockEntry<SawdustBlock>("sawdust", () -> BlockBehaviour.Properties.of().mapColor(MapColor.SAND).ignitedByLava().instrument(NoteBlockInstrument.BASS).sound(SoundType.SAND).strength(0.5f).noCollission().noOcclusion(), SawdustBlock::new);
        public static final BlockEntry<IEBaseBlock> FIBERBOARD = BlockEntry.simple("fiberboard", () -> BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS).strength(1.25f, 1.0f));
        public static final BlockEntry<IEBaseBlock> WINDOW = new BlockEntry<IEBaseBlock>("treated_window", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, WindowBlock::new);
        public static final BlockEntry<IEBaseBlock> CATWALK = new BlockEntry<IEBaseBlock>("treated_catwalk", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, blockProps -> new CatwalkBlock((BlockBehaviour.Properties)blockProps, false));
        public static final BlockEntry<IEBaseBlock> CATWALK_STAIRS = new BlockEntry<IEBaseBlock>("treated_catwalk_stairs", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, blockProps -> new CatwalkStairsBlock((BlockBehaviour.Properties)blockProps, false));
        public static final BlockEntry<DoorBlock> DOOR = new BlockEntry<DoorBlock>("treated_door", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, blockProps -> new IEDoorBlock(Lib.BlockSetTypes.TREATED_WOOD, (BlockBehaviour.Properties)blockProps));
        public static final BlockEntry<DoorBlock> DOOR_FRAMED = new BlockEntry<DoorBlock>("treated_door_framed", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, blockProps -> new IEDoorBlock(Lib.BlockSetTypes.TREATED_WOOD, (BlockBehaviour.Properties)blockProps));
        public static final BlockEntry<TrapDoorBlock> TRAPDOOR = new BlockEntry<TrapDoorBlock>("treated_trapdoor", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, blockProps -> new IETrapDoorBlock(Lib.BlockSetTypes.TREATED_WOOD, (BlockBehaviour.Properties)blockProps));
        public static final BlockEntry<TrapDoorBlock> TRAPDOOR_FRAMED = new BlockEntry<TrapDoorBlock>("treated_trapdoor_framed", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, blockProps -> new IETrapDoorBlock(Lib.BlockSetTypes.TREATED_WOOD, (BlockBehaviour.Properties)blockProps));
        public static final SignHolder SIGN = SignHolder.of(Lib.WoodTypes.TREATED_WOOD, 1.0f, MapColor.WOOD, NoteBlockInstrument.BASS, true);
        public static final BlockEntry<IEBaseBlock> BASIC_ENGINEERING = BlockEntry.simple("basic_engineering", STANDARD_WOOD_PROPERTIES);

        private static void init() {
            for (TreatedWoodStyles style : TreatedWoodStyles.values()) {
                BlockEntry<IEBaseBlock> baseBlock = BlockEntry.simple("treated_wood_" + style.name().toLowerCase(Locale.US), STANDARD_WOOD_PROPERTIES, shouldHave -> shouldHave.setHasFlavour(true));
                TREATED_WOOD.put(style, baseBlock);
                IEBlocks.registerSlab(baseBlock);
                IEBlocks.registerStairs(baseBlock);
            }
        }
    }

    public static final class WoodenDevices {
        public static final BlockEntry<CraftingTableBlock> CRAFTING_TABLE = new BlockEntry<CraftingTableBlock>("craftingtable", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, CraftingTableBlock::new);
        public static final BlockEntry<DeskBlock<ModWorkbenchBlockEntity>> WORKBENCH = new BlockEntry<DeskBlock>("workbench", DeskBlock.PROPERTIES, p -> new DeskBlock(IEBlockEntities.MOD_WORKBENCH, (BlockBehaviour.Properties)p));
        public static final BlockEntry<BlueprintShelfBlock> BLUEPRINT_SHELF = new BlockEntry<BlueprintShelfBlock>("blueprint_shelf", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, BlueprintShelfBlock::new);
        public static final BlockEntry<DeskBlock<CircuitTableBlockEntity>> CIRCUIT_TABLE = new BlockEntry<DeskBlock>("circuit_table", DeskBlock.PROPERTIES, p -> new DeskBlock(IEBlockEntities.CIRCUIT_TABLE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<GunpowderBarrelBlock> GUNPOWDER_BARREL = new BlockEntry<GunpowderBarrelBlock>("gunpowder_barrel", GunpowderBarrelBlock.PROPERTIES, GunpowderBarrelBlock::new);
        public static final BlockEntry<IEEntityBlock<?>> WOODEN_BARREL = BlockEntry.barrel("wooden_barrel", false);
        public static final BlockEntry<TurntableBlock> TURNTABLE = new BlockEntry<TurntableBlock>("turntable", STANDARD_WOOD_PROPERTIES, TurntableBlock::new);
        public static final BlockEntry<IEEntityBlock<WoodenCrateBlockEntity>> CRATE = new BlockEntry<IEEntityBlock>("crate", STANDARD_WOOD_PROPERTIES, CrateBlock::new);
        public static final BlockEntry<IEEntityBlock<WoodenCrateBlockEntity>> REINFORCED_CRATE = new BlockEntry<IEEntityBlock>("reinforced_crate", () -> BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.0f, 1200.0f).mapColor(MapColor.WOOD).ignitedByLava().instrument(NoteBlockInstrument.BASS), CrateBlock::new);
        public static final BlockEntry<IEEntityBlock<SorterBlockEntity>> SORTER = new BlockEntry<IEEntityBlock>("sorter", STANDARD_WOOD_PROPERTIES, p -> new IEEntityBlock(IEBlockEntities.SORTER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<ItemBatcherBlock> ITEM_BATCHER = new BlockEntry<ItemBatcherBlock>("item_batcher", STANDARD_WOOD_PROPERTIES, ItemBatcherBlock::new);
        public static final BlockEntry<IEEntityBlock<FluidSorterBlockEntity>> FLUID_SORTER = new BlockEntry<IEEntityBlock>("fluid_sorter", STANDARD_WOOD_PROPERTIES, p -> new IEEntityBlock(IEBlockEntities.FLUID_SORTER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<WindmillBlock> WINDMILL = new BlockEntry<WindmillBlock>("windmill", IEBlocks.dynamicShape(STANDARD_WOOD_PROPERTIES_NO_OCCLUSION), WindmillBlock::new);
        public static final BlockEntry<WatermillBlock> WATERMILL = new BlockEntry<WatermillBlock>("watermill", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, WatermillBlock::new);
        public static final BlockEntry<WallmountBlock> TREATED_WALLMOUNT = BlockEntry.wallmount("treated_wallmount", STANDARD_WOOD_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<HorizontalFacingEntityBlock<LogicUnitBlockEntity>> LOGIC_UNIT = new BlockEntry<HorizontalFacingEntityBlock>("logic_unit", STANDARD_WOOD_PROPERTIES_NO_OCCLUSION, p -> new HorizontalFacingEntityBlock(IEBlockEntities.LOGIC_UNIT, (BlockBehaviour.Properties)p));
        public static final BlockEntry<HorizontalFacingEntityBlock<MachineInterfaceBlockEntity>> MACHINE_INTERFACE = new BlockEntry<HorizontalFacingEntityBlock>("machine_interface", STANDARD_WOOD_PROPERTIES, p -> new HorizontalFacingEntityBlock(IEBlockEntities.MACHINE_INTERFACE, (BlockBehaviour.Properties)p));

        private static void init() {
        }
    }

    public static final class MetalDecoration {
        public static final BlockEntry<IEBaseBlock> LV_COIL = BlockEntry.simple("coil_lv", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> MV_COIL = BlockEntry.simple("coil_mv", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> HV_COIL = BlockEntry.simple("coil_hv", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> ENGINEERING_RS = BlockEntry.simple("rs_engineering", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> ENGINEERING_HEAVY = BlockEntry.simple("heavy_engineering", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> ENGINEERING_LIGHT = BlockEntry.simple("light_engineering", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> ENGINEERING_RESONANZ = BlockEntry.simple("resonanz_engineering", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> GENERATOR = BlockEntry.simple("generator", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<IEBaseBlock> RADIATOR = BlockEntry.simple("radiator", DEFAULT_METAL_PROPERTIES);
        public static final BlockEntry<FenceBlock> STEEL_FENCE = BlockEntry.fence("steel_fence", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<FenceGateBlock> STEEL_FENCE_GATE = new BlockEntry<FenceGateBlock>("steel_fence_gate", METAL_PROPERTIES_NO_OVERLAY, blockProps -> new FenceGateBlock(blockProps, SoundEvents.COPPER_DOOR_OPEN, SoundEvents.COPPER_DOOR_CLOSE));
        public static final BlockEntry<FenceBlock> ALU_FENCE = BlockEntry.fence("alu_fence", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<FenceGateBlock> ALU_FENCE_GATE = new BlockEntry<FenceGateBlock>("alu_fence_gate", METAL_PROPERTIES_NO_OVERLAY, blockProps -> new FenceGateBlock(blockProps, SoundEvents.COPPER_DOOR_OPEN, SoundEvents.COPPER_DOOR_CLOSE));
        public static final BlockEntry<WallmountBlock> STEEL_WALLMOUNT = BlockEntry.wallmount("steel_wallmount", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<WallmountBlock> ALU_WALLMOUNT = BlockEntry.wallmount("alu_wallmount", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<PostBlock> STEEL_POST = BlockEntry.post("steel_post", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<PostBlock> ALU_POST = BlockEntry.post("alu_post", METAL_PROPERTIES_NO_OVERLAY);
        public static final BlockEntry<LanternBlock> LANTERN = new BlockEntry<LanternBlock>("lantern", LanternBlock.PROPERTIES, LanternBlock::new);
        public static final BlockEntry<CagelampBlock> CAGELAMP = new BlockEntry<CagelampBlock>("cagelamp", CagelampBlock.PROPERTIES, CagelampBlock::new);
        public static final BlockEntry<StructuralArmBlock> STEEL_SLOPE = new BlockEntry<StructuralArmBlock>("steel_slope", METAL_PROPERTIES_DYNAMIC, StructuralArmBlock::new);
        public static final BlockEntry<StructuralArmBlock> ALU_SLOPE = new BlockEntry<StructuralArmBlock>("alu_slope", METAL_PROPERTIES_DYNAMIC, StructuralArmBlock::new);
        public static final Map<MetalLadderBlock.CoverType, BlockEntry<MetalLadderBlock>> METAL_LADDER = new EnumMap<MetalLadderBlock.CoverType, BlockEntry<MetalLadderBlock>>(MetalLadderBlock.CoverType.class);
        public static final Map<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>> STEEL_SCAFFOLDING = new EnumMap<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>>(MetalScaffoldingType.class);
        public static final Map<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>> ALU_SCAFFOLDING = new EnumMap<MetalScaffoldingType, BlockEntry<ScaffoldingBlock>>(MetalScaffoldingType.class);
        public static final Map<DyeColor, BlockEntry<IEBaseBlock>> COLORED_SHEETMETAL = new EnumMap<DyeColor, BlockEntry<IEBaseBlock>>(DyeColor.class);
        public static final BlockEntry<IEBaseBlock> STEEL_WINDOW = new BlockEntry<IEBaseBlock>("steel_window", METAL_PROPERTIES_NO_OCCLUSION, WindowBlock::new);
        public static final BlockEntry<IEBaseBlock> ALU_WINDOW = new BlockEntry<IEBaseBlock>("alu_window", METAL_PROPERTIES_NO_OCCLUSION, WindowBlock::new);
        public static final BlockEntry<IEBaseBlock> REINFORCED_WINDOW = new BlockEntry<IEBaseBlock>("reinforced_window", () -> BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(SoundType.METAL).strength(20.0f, 1200.0f).requiresCorrectToolForDrops().isViewBlocking((state, blockReader, pos) -> false).noOcclusion().forceSolidOn(), WindowBlock::new);
        public static final BlockEntry<IEBaseBlock> STEEL_CATWALK = new BlockEntry<IEBaseBlock>("steel_catwalk", METAL_PROPERTIES_NO_OCCLUSION, blockProps -> new CatwalkBlock((BlockBehaviour.Properties)blockProps, true));
        public static final BlockEntry<IEBaseBlock> STEEL_CATWALK_STAIRS = new BlockEntry<IEBaseBlock>("steel_catwalk_stairs", METAL_PROPERTIES_NO_OCCLUSION, blockProps -> new CatwalkStairsBlock((BlockBehaviour.Properties)blockProps, true));
        public static final BlockEntry<IEBaseBlock> ALU_CATWALK = new BlockEntry<IEBaseBlock>("alu_catwalk", METAL_PROPERTIES_NO_OCCLUSION, blockProps -> new CatwalkBlock((BlockBehaviour.Properties)blockProps, true));
        public static final BlockEntry<IEBaseBlock> ALU_CATWALK_STAIRS = new BlockEntry<IEBaseBlock>("alu_catwalk_stairs", METAL_PROPERTIES_NO_OCCLUSION, blockProps -> new CatwalkStairsBlock((BlockBehaviour.Properties)blockProps, true));
        public static final BlockEntry<DoorBlock> STEEL_DOOR = new BlockEntry<DoorBlock>("steel_door", METAL_PROPERTIES_NO_OCCLUSION, blockProps -> new IEDoorBlock(Lib.BlockSetTypes.STEEL, (BlockBehaviour.Properties)blockProps).setLockedByRedstone());
        public static final BlockEntry<TrapDoorBlock> STEEL_TRAPDOOR = new BlockEntry<TrapDoorBlock>("steel_trapdoor", METAL_PROPERTIES_NO_OCCLUSION, blockProps -> new IETrapDoorBlock(Lib.BlockSetTypes.STEEL, (BlockBehaviour.Properties)blockProps).setLockedByRedstone());
        public static final SignHolder STEEL_SIGN = SignHolder.of(Lib.WoodTypes.STEEL, 3.0f, MapColor.METAL, NoteBlockInstrument.IRON_XYLOPHONE, false);
        public static final SignHolder ALU_SIGN = SignHolder.of(Lib.WoodTypes.ALUMINUM, 3.0f, MapColor.METAL, NoteBlockInstrument.IRON_XYLOPHONE, false);
        public static final Map<WarningSignBlock.WarningSignIcon, BlockEntry<IEBaseBlock>> WARNING_SIGNS = new EnumMap<WarningSignBlock.WarningSignIcon, BlockEntry<IEBaseBlock>>(WarningSignBlock.WarningSignIcon.class);

        private static void init() {
            for (DyeColor dyeColor : DyeColor.values()) {
                BlockEntry<IEBaseBlock> sheetmetal = BlockEntry.simple("sheetmetal_colored_" + dyeColor.getName(), SHEETMETAL_PROPERTIES);
                COLORED_SHEETMETAL.put(dyeColor, sheetmetal);
                IEBlocks.registerSlab(sheetmetal);
            }
            for (MetalLadderBlock.CoverType coverType : MetalLadderBlock.CoverType.values()) {
                METAL_LADDER.put(coverType, new BlockEntry<MetalLadderBlock>("metal_ladder_" + coverType.name().toLowerCase(Locale.US), METAL_PROPERTIES_NO_OCCLUSION, p -> new MetalLadderBlock(coverType, (BlockBehaviour.Properties)p)));
            }
            for (MetalScaffoldingType metalScaffoldingType : MetalScaffoldingType.values()) {
                String name = metalScaffoldingType.name().toLowerCase(Locale.ENGLISH);
                BlockEntry<ScaffoldingBlock> steelBlock = BlockEntry.scaffolding("steel_scaffolding_" + name, METAL_PROPERTIES_NO_OCCLUSION);
                BlockEntry<ScaffoldingBlock> aluBlock = BlockEntry.scaffolding("alu_scaffolding_" + name, METAL_PROPERTIES_NO_OCCLUSION);
                STEEL_SCAFFOLDING.put(metalScaffoldingType, steelBlock);
                ALU_SCAFFOLDING.put(metalScaffoldingType, aluBlock);
                IEBlocks.registerSlab(steelBlock);
                IEBlocks.registerSlab(aluBlock);
                IEBlocks.registerStairs(steelBlock);
                IEBlocks.registerStairs(aluBlock);
            }
            for (WarningSignBlock.WarningSignIcon warningSignIcon : WarningSignBlock.WarningSignIcon.values()) {
                WARNING_SIGNS.put(warningSignIcon, new BlockEntry<IEBaseBlock>("warning_sign_" + warningSignIcon.getSerializedName(), WarningSignBlock.PROPERTIES, blockProps -> new WarningSignBlock(warningSignIcon, (BlockBehaviour.Properties)blockProps)));
            }
        }
    }

    public static final class MetalDevices {
        public static final BlockEntry<RazorWireBlock> RAZOR_WIRE = new BlockEntry<RazorWireBlock>("razor_wire", RazorWireBlock.PROPERTIES, RazorWireBlock::new);
        public static final BlockEntry<HorizontalFacingEntityBlock<ToolboxBlockEntity>> TOOLBOX = new BlockEntry<HorizontalFacingEntityBlock>("toolbox_block", IEBlocks.dynamicShape(METAL_PROPERTIES_NO_OVERLAY), p -> new HorizontalFacingEntityBlock(IEBlockEntities.TOOLBOX, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorBlockEntity>> CAPACITOR_LV = new BlockEntry<IEEntityBlock>("capacitor_lv", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock(IEBlockEntities.CAPACITOR_LV, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorBlockEntity>> CAPACITOR_MV = new BlockEntry<IEEntityBlock>("capacitor_mv", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock(IEBlockEntities.CAPACITOR_MV, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorBlockEntity>> CAPACITOR_HV = new BlockEntry<IEEntityBlock>("capacitor_hv", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock(IEBlockEntities.CAPACITOR_HV, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<CapacitorCreativeBlockEntity>> CAPACITOR_CREATIVE = new BlockEntry<IEEntityBlock>("capacitor_creative", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock(IEBlockEntities.CAPACITOR_CREATIVE, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<?>> BARREL = BlockEntry.barrel("metal_barrel", true);
        public static final BlockEntry<FluidPumpBlock> FLUID_PUMP = new BlockEntry<FluidPumpBlock>("fluid_pump", METAL_PROPERTIES_DYNAMIC, FluidPumpBlock::new);
        public static final BlockEntry<IEEntityBlock<FluidPlacerBlockEntity>> FLUID_PLACER = new BlockEntry<IEEntityBlock>("fluid_placer", METAL_PROPERTIES_NO_OCCLUSION, p -> new IEEntityBlock(IEBlockEntities.FLUID_PLACER, (BlockBehaviour.Properties)p));
        public static final BlockEntry<BlastFurnacePreheaterBlock> BLAST_FURNACE_PREHEATER = new BlockEntry<BlastFurnacePreheaterBlock>("blastfurnace_preheater", METAL_PROPERTIES_NO_OCCLUSION, BlastFurnacePreheaterBlock::new);
        public static final BlockEntry<FurnaceHeaterBlock> FURNACE_HEATER = new BlockEntry<FurnaceHeaterBlock>("furnace_heater", DEFAULT_METAL_PROPERTIES, FurnaceHeaterBlock::new);
        public static final BlockEntry<HorizontalFacingEntityBlock<DynamoBlockEntity>> DYNAMO = new BlockEntry<HorizontalFacingEntityBlock>("dynamo", DEFAULT_METAL_PROPERTIES, p -> new HorizontalFacingEntityBlock(IEBlockEntities.DYNAMO, (BlockBehaviour.Properties)p));
        public static final BlockEntry<IEEntityBlock<ThermoelectricGenBlockEntity>> THERMOELECTRIC_GEN = new BlockEntry<IEEntityBlock>("thermoelectric_generator", DEFAULT_METAL_PROPERTIES, p -> new IEEntityBlock(IEBlockEntities.THERMOELECTRIC_GEN, (BlockBehaviour.Properties)p));
        public static final BlockEntry<ElectricLanternBlock> ELECTRIC_LANTERN = new BlockEntry<ElectricLanternBlock>("electric_lantern", ElectricLanternBlock.PROPERTIES, ElectricLanternBlock::new);
        public static final BlockEntry<HorizontalFacingEntityBlock<ChargingStationBlockEntity>> CHARGING_STATION = new BlockEntry<HorizontalFacingEntityBlock>("charging_station", METAL_PROPERTIES_DYNAMIC, p -> new HorizontalFacingEntityBlock(IEBlockEntities.CHARGING_STATION, (BlockBehaviour.Properties)p));
        public static final BlockEntry<FluidPipeBlock> FLUID_PIPE = new BlockEntry<FluidPipeBlock>("fluid_pipe", METAL_PROPERTIES_DYNAMIC, FluidPipeBlock::new);
        public static final BlockEntry<SampleDrillBlock> SAMPLE_DRILL = new BlockEntry<SampleDrillBlock>("sample_drill", METAL_PROPERTIES_NO_OCCLUSION, SampleDrillBlock::new);
        public static final BlockEntry<TeslaCoilBlock> TESLA_COIL = new BlockEntry<TeslaCoilBlock>("tesla_coil", METAL_PROPERTIES_DYNAMIC, TeslaCoilBlock::new);
        public static final BlockEntry<FloodlightBlock> FLOODLIGHT = new BlockEntry<FloodlightBlock>("floodlight", FloodlightBlock.PROPERTIES, FloodlightBlock::new);
        public static final BlockEntry<TurretBlock<TurretChemBlockEntity>> TURRET_CHEM = new BlockEntry<TurretBlock>("turret_chem", METAL_PROPERTIES_DYNAMIC, p -> new TurretBlock<TurretChemBlockEntity>(IEBlockEntities.TURRET_CHEM, (BlockBehaviour.Properties)p));
        public static final BlockEntry<TurretBlock<TurretGunBlockEntity>> TURRET_GUN = new BlockEntry<TurretBlock>("turret_gun", METAL_PROPERTIES_DYNAMIC, p -> new TurretBlock<TurretGunBlockEntity>(IEBlockEntities.TURRET_GUN, (BlockBehaviour.Properties)p));
        public static final BlockEntry<ClocheBlock> CLOCHE = new BlockEntry<ClocheBlock>("cloche", METAL_PROPERTIES_NO_OCCLUSION, ClocheBlock::new);
        public static final Map<IConveyorType<?>, BlockEntry<ConveyorBlock>> CONVEYORS = new HashMap();
        public static final Map<EnumMetals, BlockEntry<ChuteBlock>> CHUTES = new EnumMap<EnumMetals, BlockEntry<ChuteBlock>>(EnumMetals.class);
        public static final Map<DyeColor, BlockEntry<ChuteBlock>> DYED_CHUTES = new EnumMap<DyeColor, BlockEntry<ChuteBlock>>(DyeColor.class);
        public static final BlockEntry<AnyFacingEntityBlock<ElectromagnetBlockEntity>> ELECTROMAGNET = new BlockEntry<AnyFacingEntityBlock>("electromagnet", DEFAULT_METAL_PROPERTIES, p -> new AnyFacingEntityBlock(IEBlockEntities.ELECTROMAGNET, (BlockBehaviour.Properties)p));
        public static final BlockEntry<PipeValveBlock> PIPE_VALVE = new BlockEntry<PipeValveBlock>("pipe_valve", METAL_PROPERTIES_NO_OCCLUSION, PipeValveBlock::new);

        private static void init() {
            for (EnumMetals enumMetals : new EnumMetals[]{EnumMetals.IRON, EnumMetals.STEEL, EnumMetals.ALUMINUM, EnumMetals.COPPER}) {
                CHUTES.put(enumMetals, new BlockEntry<ChuteBlock>("chute_" + enumMetals.tagName(), METAL_PROPERTIES_DYNAMIC, ChuteBlock::new));
            }
            for (EnumMetals enumMetals : DyeColor.values()) {
                DYED_CHUTES.put((DyeColor)enumMetals, new BlockEntry<ChuteBlock>("chute_colored_" + enumMetals.getName(), METAL_PROPERTIES_DYNAMIC, ChuteBlock::new));
            }
        }

        public static void initConveyors() {
            Preconditions.checkState((boolean)CONVEYORS.isEmpty());
            for (IConveyorType<?> type : ConveyorHandler.getConveyorTypes()) {
                ResourceLocation rl = type.getId();
                BlockEntry<ConveyorBlock> blockEntry = new BlockEntry<ConveyorBlock>(ConveyorHandler.getRegistryNameFor(rl).getPath(), ConveyorBlock.PROPERTIES, p -> new ConveyorBlock(type, (BlockBehaviour.Properties)p));
                CONVEYORS.put(type, blockEntry);
                IEItems.REGISTER.register(blockEntry.getId().getPath(), () -> new BlockItemIE((Block)blockEntry.get()));
            }
        }
    }

    public static final class Connectors {
        public static final Map<Pair<String, Boolean>, BlockEntry<BasicConnectorBlock<?>>> ENERGY_CONNECTORS = new HashMap();
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_STRUCTURAL = new BlockEntry<BasicConnectorBlock>("connector_structural", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_STRUCTURAL));
        public static final BlockEntry<TransformerBlock> TRANSFORMER = new BlockEntry<TransformerBlock>("transformer", ConnectorBlock.PROPERTIES, TransformerBlock::new);
        public static final BlockEntry<PostTransformerBlock> POST_TRANSFORMER = new BlockEntry<PostTransformerBlock>("post_transformer", ConnectorBlock.PROPERTIES, PostTransformerBlock::new);
        public static final BlockEntry<TransformerHVBlock> TRANSFORMER_HV = new BlockEntry<TransformerHVBlock>("transformer_hv", ConnectorBlock.PROPERTIES, TransformerHVBlock::new);
        public static final BlockEntry<BreakerSwitchBlock<?>> BREAKER_SWITCH = new BlockEntry<BreakerSwitchBlock>("breaker_switch", ConnectorBlock.PROPERTIES, p -> new BreakerSwitchBlock((BlockBehaviour.Properties)p, IEBlockEntities.BREAKER_SWITCH));
        public static final BlockEntry<BreakerSwitchBlock<?>> REDSTONE_BREAKER = new BlockEntry<BreakerSwitchBlock>("redstone_breaker", ConnectorBlock.PROPERTIES, p -> new BreakerSwitchBlock((BlockBehaviour.Properties)p, IEBlockEntities.REDSTONE_BREAKER));
        public static final BlockEntry<EnergyMeterBlock> CURRENT_TRANSFORMER = new BlockEntry<EnergyMeterBlock>("current_transformer", ConnectorBlock.PROPERTIES, EnergyMeterBlock::new);
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_REDSTONE = new BlockEntry<BasicConnectorBlock>("connector_redstone", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_REDSTONE));
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_PROBE = new BlockEntry<BasicConnectorBlock>("connector_probe", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_PROBE));
        public static final BlockEntry<BasicConnectorBlock<?>> CONNECTOR_BUNDLED = new BlockEntry<BasicConnectorBlock>("connector_bundled", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock((BlockBehaviour.Properties)p, IEBlockEntities.CONNECTOR_BUNDLED));
        public static final BlockEntry<BasicConnectorBlock<?>> REDSTONE_STATE_CELL = new BlockEntry<BasicConnectorBlock>("redstone_state_cell", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock((BlockBehaviour.Properties)p, IEBlockEntities.REDSTONE_STATE_CELL));
        public static final BlockEntry<BasicConnectorBlock<?>> REDSTONE_TIMER = new BlockEntry<BasicConnectorBlock>("redstone_timer", ConnectorBlock.PROPERTIES, p -> new BasicConnectorBlock((BlockBehaviour.Properties)p, IEBlockEntities.REDSTONE_TIMER));
        public static final BlockEntry<HorizontalFacingEntityBlock<?>> REDSTONE_SWITCHBOARD = new BlockEntry<HorizontalFacingEntityBlock>("redstone_switchboard", ConnectorBlock.PROPERTIES, p -> new HorizontalFacingEntityBlock(IEBlockEntities.REDSTONE_SWITCHBOARD, (BlockBehaviour.Properties)p));
        public static final BlockEntry<AnyFacingEntityBlock<?>> SIREN = new BlockEntry<AnyFacingEntityBlock>("siren", ConnectorBlock.PROPERTIES, p -> new AnyFacingEntityBlock(IEBlockEntities.SIREN, (BlockBehaviour.Properties)p));
        public static final BlockEntry<FeedthroughBlock> FEEDTHROUGH = new BlockEntry<FeedthroughBlock>("feedthrough", FeedthroughBlock.PROPERTIES, FeedthroughBlock::new);

        public static BlockEntry<BasicConnectorBlock<?>> getEnergyConnector(String cat, boolean relay) {
            return ENERGY_CONNECTORS.get(Pair.of((Object)cat, (Object)relay));
        }

        private static void init() {
            for (String cat : new String[]{"LV", "MV", "HV"}) {
                ENERGY_CONNECTORS.put((Pair<String, Boolean>)Pair.of((Object)cat, (Object)false), BasicConnectorBlock.forPower(cat, false));
                ENERGY_CONNECTORS.put((Pair<String, Boolean>)Pair.of((Object)cat, (Object)true), BasicConnectorBlock.forPower(cat, true));
            }
        }
    }

    public static final class Cloth {
        public static final BlockEntry<CushionBlock> CUSHION = new BlockEntry<CushionBlock>("cushion", CushionBlock.PROPERTIES, CushionBlock::new);
        public static final BlockEntry<BalloonBlock> BALLOON = new BlockEntry<BalloonBlock>("balloon", BalloonBlock.PROPERTIES, BalloonBlock::new);
        public static final BlockEntry<StripCurtainBlock> STRIP_CURTAIN = new BlockEntry<StripCurtainBlock>("strip_curtain", StripCurtainBlock.PROPERTIES, StripCurtainBlock::new);
        public static final BlockEntry<ShaderBannerStandingBlock> SHADER_BANNER = new BlockEntry<ShaderBannerStandingBlock>("shader_banner", ShaderBannerBlock.PROPERTIES, ShaderBannerStandingBlock::new);
        public static final BlockEntry<ShaderBannerWallBlock> SHADER_BANNER_WALL = new BlockEntry<ShaderBannerWallBlock>("shader_banner_wall", ShaderBannerBlock.PROPERTIES, ShaderBannerWallBlock::new);

        private static void init() {
        }
    }

    public static final class Misc {
        public static final BlockEntry<HempBlock> HEMP_PLANT = new BlockEntry<HempBlock>("hemp", HempBlock.PROPERTIES, HempBlock::new);
        public static final BlockEntry<PottedHempBlock> POTTED_HEMP = new BlockEntry<PottedHempBlock>("potted_hemp", PottedHempBlock.PROPERTIES, PottedHempBlock::new);
        public static final BlockEntry<FakeLightBlock> FAKE_LIGHT = new BlockEntry<FakeLightBlock>("fake_light", FakeLightBlock.PROPERTIES, FakeLightBlock::new);

        private static void init() {
        }
    }

    public record SignHolder(String baseName, BlockEntry<IESignBlocks.Standing> sign, BlockEntry<IESignBlocks.Wall> wall, BlockEntry<IESignBlocks.Hanging> hanging, BlockEntry<IESignBlocks.WallHanging> wallHanging) {
        public static SignHolder of(WoodType wood, float strength, MapColor mapColor, NoteBlockInstrument nbi, boolean ignite) {
            String baseName = ResourceLocation.parse((String)wood.name()).getPath();
            BlockEntry<IESignBlocks.Standing> sign = new BlockEntry<IESignBlocks.Standing>(baseName + "_sign", SignHolder.buildProperties(strength, mapColor, nbi, ignite, null), blockProps -> new IESignBlocks.Standing(wood, (BlockBehaviour.Properties)blockProps));
            BlockEntry<IESignBlocks.Wall> wall = new BlockEntry<IESignBlocks.Wall>(baseName + "_wall_sign", SignHolder.buildProperties(strength, mapColor, nbi, ignite, sign::get), blockProps -> new IESignBlocks.Wall(wood, (BlockBehaviour.Properties)blockProps));
            BlockEntry<IESignBlocks.Hanging> hanging = new BlockEntry<IESignBlocks.Hanging>(baseName + "_hanging_sign", SignHolder.buildProperties(strength, mapColor, nbi, ignite, null), blockProps -> new IESignBlocks.Hanging(wood, (BlockBehaviour.Properties)blockProps));
            BlockEntry<IESignBlocks.WallHanging> wallHanging = new BlockEntry<IESignBlocks.WallHanging>(baseName + "_wall_hanging_sign", SignHolder.buildProperties(strength, mapColor, nbi, ignite, hanging::get), blockProps -> new IESignBlocks.WallHanging(wood, (BlockBehaviour.Properties)blockProps));
            return new SignHolder(baseName, sign, wall, hanging, wallHanging);
        }

        private static Supplier<BlockBehaviour.Properties> buildProperties(float strength, MapColor mapColor, NoteBlockInstrument nbi, boolean ignite, Supplier<Block> dropsLike) {
            return () -> {
                BlockBehaviour.Properties props = BlockBehaviour.Properties.of().mapColor(mapColor).instrument(nbi).strength(strength).forceSolidOn().noCollission();
                if (ignite) {
                    props.ignitedByLava();
                }
                if (dropsLike != null) {
                    props.dropsLike((Block)dropsLike.get());
                }
                return props;
            };
        }

        public void registerItems(DeferredRegister<Item> register) {
            register.register(this.baseName + "_sign", () -> new SignItem(new Item.Properties().stacksTo(16), (Block)this.sign().get(), (Block)this.wall().get()));
            register.register(this.baseName + "_hanging_sign", () -> new HangingSignItem((Block)this.hanging().get(), (Block)this.wallHanging.get(), new Item.Properties().stacksTo(16)));
        }

        public boolean matchesEntries(BlockEntry<?> entry) {
            return entry == this.sign() || entry == this.wall() || entry == this.hanging() || entry == this.wallHanging();
        }

        public List<BlockEntry<?>> getEntries() {
            return Arrays.asList(this.sign, this.wall, this.hanging, this.wallHanging);
        }

        public void mapMultiSign(Consumer<BlockEntry<?>> consumer) {
            consumer.accept(this.sign());
            consumer.accept(this.wall());
        }

        public void mapMultiHanging(Consumer<BlockEntry<?>> consumer) {
            consumer.accept(this.hanging());
            consumer.accept(this.wallHanging());
        }
    }
}

