/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;

public class PacketUtils {
    public static <T> List<T> readList(FriendlyByteBuf buffer, Function<FriendlyByteBuf, T> readElement) {
        int numElements = buffer.readVarInt();
        ArrayList<T> result = new ArrayList<T>(numElements);
        for (int i = 0; i < numElements; ++i) {
            result.add(readElement.apply(buffer));
        }
        return result;
    }

    public static <T> void writeListReverse(FriendlyByteBuf buffer, List<T> toWrite, BiConsumer<FriendlyByteBuf, T> writeElement) {
        PacketUtils.writeList(buffer, toWrite, (t, buf) -> writeElement.accept((FriendlyByteBuf)buf, (Object)t));
    }

    public static <T> void writeList(FriendlyByteBuf buffer, List<T> toWrite, BiConsumer<T, FriendlyByteBuf> writeElement) {
        buffer.writeVarInt(toWrite.size());
        for (T element : toWrite) {
            writeElement.accept(element, buffer);
        }
    }

    public static <T> T readRegistryElement(FriendlyByteBuf buffer, Registry<T> registry) {
        ResourceKey key = buffer.readResourceKey(registry.key());
        return (T)registry.get(key);
    }

    public static <T> void writeRegistryElement(FriendlyByteBuf buffer, Registry<T> registry, T entry) {
        ResourceKey key = (ResourceKey)registry.getResourceKey(entry).orElseThrow();
        buffer.writeResourceKey(key);
    }
}

