/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.HammerItem;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.common.Tags;

public class WirecutterItem
extends IEBaseItem {
    public WirecutterItem() {
        super(new Item.Properties().durability(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return IEServerConfig.getOrDefault(IEServerConfig.TOOLS.cutterDurabiliy);
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(@Nonnull ItemStack stack) {
        return ItemUtils.damageCopy(stack, 1);
    }

    public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 14;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        ItemEnchantments enchantments = (ItemEnchantments)book.get(DataComponents.ENCHANTMENTS);
        return enchantments.keySet().stream().allMatch(HammerItem::canApplyAtEnchantingTable);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Tags.Items.INGOTS_IRON);
    }

    public boolean mineBlock(ItemStack itemstack, Level pLevel, BlockState state, BlockPos pPos, LivingEntity pEntityLiving) {
        boolean effective = state.is(IETags.wirecutterHarvestable);
        if (pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            itemstack.hurtAndBreak(1, serverLevel, null, i -> {});
        }
        return effective;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.isCorrectToolForDrops(stack, state)) {
            return 6.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(IETags.wirecutterHarvestable);
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return toolAction == Lib.WIRECUTTER_DIG;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity tileEntity = world.getBlockEntity(pos);
        TargetingInfo target = new TargetingInfo(context.getClickedFace(), (float)context.getClickLocation().x, (float)context.getClickLocation().y, (float)context.getClickLocation().z);
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player != null && tileEntity instanceof IImmersiveConnectable) {
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, target);
            if (!((tileEntity = world.getBlockEntity(masterPos)) instanceof IImmersiveConnectable)) {
                return InteractionResult.PASS;
            }
            if (!world.isClientSide) {
                IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                AtomicBoolean cut = new AtomicBoolean(false);
                net.removeAllConnectionsAt(nodeHere, conn -> {
                    ItemStack coil = conn.type.getWireCoil((Connection)conn);
                    if (world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                        world.addFreshEntity((Entity)new ItemEntity(world, player.getX(), player.getY(), player.getZ(), coil, 0.0, 0.0, 0.0));
                    }
                    cut.set(true);
                });
                if (cut.get() && !player.hasInfiniteMaterials()) {
                    ItemUtils.damageDirect(stack, 1);
                }
            }
        } else if (player != null) {
            return this.use(world, player, context.getHand()).getResult();
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        double reachDistance;
        Connection target;
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && (target = WireUtils.getTargetConnection(world, player, null, reachDistance = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE))) != null) {
            GlobalWireNetwork.getNetwork(world).removeInsertAndDropConnection(target, player, world);
            if (!player.hasInfiniteMaterials()) {
                ItemUtils.damageDirect(stack, 1);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

