/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.upgrade.IUpgrade;
import blusunrize.immersiveengineering.api.tool.upgrade.IUpgradeableTool;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeData;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public abstract class UpgradeableToolItem
extends InternalStorageItem
implements IUpgradeableTool {
    private String upgradeType;

    public UpgradeableToolItem(Item.Properties props, String upgradeType, int slotCount) {
        super(props, slotCount);
        this.upgradeType = upgradeType;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemStack.matches((ItemStack)oldStack, (ItemStack)newStack);
    }

    @Override
    public final UpgradeData getUpgrades(ItemStack stack) {
        return UpgradeableToolItem.getUpgradesStatic(stack);
    }

    public static UpgradeData getUpgradesStatic(ItemStack stack) {
        return (UpgradeData)stack.getOrDefault(IEDataComponents.UPGRADE_DATA, (Object)UpgradeData.EMPTY);
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        stack.remove(IEDataComponents.UPGRADE_DATA);
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack, RegistryAccess registries) {
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
        if (w.isClientSide) {
            return;
        }
        this.clearUpgrades(stack);
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (inv != null) {
            UpgradeData upgrades = this.getUpgradeBase(stack);
            for (int i = 0; i < inv.getSlots(); ++i) {
                IUpgrade upg;
                Item item;
                ItemStack u = inv.getStackInSlot(i);
                if (u.isEmpty() || !((item = u.getItem()) instanceof IUpgrade) || !(upg = (IUpgrade)item).getUpgradeTypes(u).contains(this.upgradeType) || !upg.canApplyUpgrades(upgrades, u)) continue;
                upgrades = upg.applyUpgrades(upgrades, u);
            }
            stack.set(IEDataComponents.UPGRADE_DATA, (Object)upgrades);
            this.finishUpgradeRecalculation(stack, w.registryAccess());
        }
    }

    public UpgradeData getUpgradeBase(ItemStack stack) {
        return UpgradeData.EMPTY;
    }

    @Override
    public boolean canTakeFromWorkbench(ItemStack stack) {
        return true;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
    }
}

