/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

public class IEBaseItem
extends Item {
    private int burnTime = 0;
    private boolean isHidden = false;

    public IEBaseItem() {
        this(new Item.Properties());
    }

    public IEBaseItem(Item.Properties props) {
        super(props);
    }

    public IEBaseItem setBurnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    public int getBurnTime(ItemStack itemStack, RecipeType<?> type) {
        return this.burnTime;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    protected void openGui(Player player, InteractionHand hand) {
        this.openGui(player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
    }

    public void fillCreativeTab(CreativeModeTab.Output out) {
        out.accept((ItemLike)this);
    }

    protected void openGui(Player player, EquipmentSlot slot) {
        ItemStack stack = player.getItemBySlot(slot);
        IEMenuTypes.ItemContainerTypeNew<?> typeNew = this.getContainerTypeNew();
        if (typeNew != null) {
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> typeNew.create(id, inv, slot, stack), (Component)Component.empty()));
        } else {
            IEMenuTypes.ItemContainerType<?> typeOld = this.getContainerType();
            if (typeOld != null) {
                player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> typeOld.create(id, inv, player.level(), slot, stack), (Component)Component.empty()), buffer -> buffer.writeInt(slot.ordinal()));
            }
        }
    }

    public boolean isRepairable(@Nonnull ItemStack stack) {
        return false;
    }

    public boolean isIERepairable(@Nonnull ItemStack stack) {
        return super.isRepairable(stack);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @Nullable
    protected IEMenuTypes.ItemContainerType<?> getContainerType() {
        return null;
    }

    @Nullable
    protected IEMenuTypes.ItemContainerTypeNew<?> getContainerTypeNew() {
        return null;
    }

    public int getBarColor(ItemStack pStack) {
        return Mth.hsvToRgb((float)(Math.max(0.0f, (float)this.getBarWidth(pStack) / 13.0f) / 3.0f), (float)1.0f, (float)1.0f);
    }
}

