/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.utils.Color4;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.entities.FluorescentTubeEntity;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import malte0811.dualcodecs.DualCodec;
import malte0811.dualcodecs.DualCodecs;
import malte0811.dualcodecs.DualCompositeCodecs;
import malte0811.dualcodecs.DualMapCodec;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FluorescentTubeItem
extends IEBaseItem
implements IConfigurableTool,
IElectricEquipment,
IEItemInterfaces.IColouredItem {
    public FluorescentTubeItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Direction side = ctx.getClickedFace();
        Level world = ctx.getLevel();
        Player player = ctx.getPlayer();
        if (side == Direction.UP && player != null) {
            if (!world.isClientSide) {
                ItemStack stack = ctx.getItemInHand();
                Vec3 look = player.getLookAngle();
                float angle = (float)Math.toDegrees(Math.atan2(look.x, look.z));
                FluorescentTubeEntity tube = new FluorescentTubeEntity(world, stack.copy(), angle);
                tube.setPos(ctx.getClickLocation().x, ctx.getClickLocation().y + 1.5, ctx.getClickLocation().z);
                world.addFreshEntity((Entity)tube);
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(ctx);
    }

    public static Color4 getRGB(ItemStack s) {
        return (Color4)s.getOrDefault(IEDataComponents.COLOR, (Object)Color4.WHITE);
    }

    public static void setRGB(ItemStack s, Color4 color) {
        s.set(IEDataComponents.COLOR, (Object)color);
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigBoolean[0];
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigFloat[] ret = new IConfigurableTool.ToolConfig.ToolConfigFloat[3];
        Color4 rgb = FluorescentTubeItem.getRGB(stack);
        ret[0] = new IConfigurableTool.ToolConfig.ToolConfigFloat("red", 60, 20, rgb.r());
        ret[1] = new IConfigurableTool.ToolConfig.ToolConfigFloat("green", 60, 40, rgb.g());
        ret[2] = new IConfigurableTool.ToolConfig.ToolConfigFloat("blue", 60, 60, rgb.b());
        return ret;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        Color4 rgb = FluorescentTubeItem.getRGB(stack);
        switch (key) {
            case "red": {
                rgb = new Color4(((Float)value).floatValue(), rgb.g(), rgb.b(), rgb.a());
                break;
            }
            case "green": {
                rgb = new Color4(rgb.r(), ((Float)value).floatValue(), rgb.b(), rgb.a());
                break;
            }
            case "blue": {
                rgb = new Color4(rgb.r(), rgb.g(), ((Float)value).floatValue(), rgb.a());
            }
        }
        FluorescentTubeItem.setRGB(stack, rgb);
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return config.name;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        int color = FluorescentTubeItem.getRGBInt(stack, 1.0f);
        list.add((Component)FontUtils.withAppendColoredColour(Component.translatable((String)"desc.immersiveengineering.info.colour").withStyle(ChatFormatting.GRAY), color));
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        if (pass == 0) {
            return FluorescentTubeItem.getRGBInt(stack, 1.0f);
        }
        return -1;
    }

    public static float[] getRGBFloat(ItemStack stack, float factor) {
        Color4 fRGB = FluorescentTubeItem.getRGB(stack);
        return new float[]{fRGB.r() * factor, fRGB.g() * factor, fRGB.b() * factor, 1.0f};
    }

    public static int getRGBInt(ItemStack stack, float factor) {
        float[] scaled = FluorescentTubeItem.getRGBFloat(stack, factor);
        return ((int)(scaled[0] * 255.0f) << 16) + ((int)(scaled[1] * 255.0f) << 8) + (int)(scaled[2] * 255.0f);
    }

    public static boolean isLit(ItemStack stack) {
        return stack.has(IEDataComponents.FLUORESCENT_TUBE_LIT);
    }

    public static void setLit(ItemStack stack, float strength) {
        stack.set(IEDataComponents.FLUORESCENT_TUBE_LIT, (Object)new LitState(Mth.clamp((float)strength, (float)0.0f, (float)1.0f), 35));
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlot eqSlot, LivingEntity owner, Map<String, Object> cache, DamageSource dmg, IElectricEquipment.ElectricSource eSource) {
        FluorescentTubeItem.setLit(equipped, eSource.level);
    }

    public void inventoryTick(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
        LitState state = (LitState)stack.get(IEDataComponents.FLUORESCENT_TUBE_LIT);
        if (!worldIn.isClientSide && state != null) {
            if (state.time > 1) {
                stack.set(IEDataComponents.FLUORESCENT_TUBE_LIT, (Object)new LitState(state.strength, state.time - 1));
            } else {
                stack.remove(IEDataComponents.FLUORESCENT_TUBE_LIT);
            }
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return !ItemStack.isSameItem((ItemStack)oldStack, (ItemStack)newStack) || !Objects.equals(FluorescentTubeItem.getRGB(oldStack), FluorescentTubeItem.getRGB(newStack));
    }

    public record LitState(float strength, int time) {
        public static final DualCodec<ByteBuf, LitState> CODECS = DualCompositeCodecs.composite((DualMapCodec)DualCodecs.FLOAT.fieldOf("strength"), LitState::strength, (DualMapCodec)DualCodecs.INT.fieldOf("time"), LitState::time, LitState::new);
    }
}

