/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class FertilizerItem
extends IEBaseItem {
    public FertilizerItem() {
        super(new Item.Properties());
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Level level = pContext.getLevel();
        BlockPos clickedPos = pContext.getClickedPos();
        BlockPos offsetPos = clickedPos.relative(pContext.getClickedFace());
        if (BoneMealItem.applyBonemeal((ItemStack)pContext.getItemInHand(), (Level)level, (BlockPos)clickedPos, (Player)pContext.getPlayer())) {
            if (!level.isClientSide) {
                level.levelEvent(1505, clickedPos, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockState blockstate = level.getBlockState(clickedPos);
        boolean isSturdy = blockstate.isFaceSturdy((BlockGetter)level, clickedPos, pContext.getClickedFace());
        if (isSturdy && BoneMealItem.growWaterPlant((ItemStack)pContext.getItemInHand(), (Level)level, (BlockPos)offsetPos, (Direction)pContext.getClickedFace())) {
            if (!level.isClientSide) {
                level.levelEvent(1505, offsetPos, 0);
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }
}

