/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.Tags;

public class DrillheadItem
extends IEBaseItem
implements IDrillHead {
    public static final DrillHeadPerm STEEL = new DrillHeadPerm("steel", IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot, 3, 1, (Tier)Tiers.DIAMOND, 10.0f, 7, 10000, ImmersiveEngineering.rl("item/drill_diesel"));
    public static final DrillHeadPerm IRON = new DrillHeadPerm("iron", (TagKey<Item>)Tags.Items.INGOTS_IRON, 2, 1, (Tier)Tiers.IRON, 9.0f, 6, 6000, ImmersiveEngineering.rl("item/drill_iron"));
    public DrillHeadPerm perms;

    public DrillheadItem(DrillHeadPerm perms) {
        super(new Item.Properties().stacksTo(1).component(DataComponents.DAMAGE, (Object)0));
        this.perms = perms;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drillhead.size", (Object[])new Object[]{this.perms.drillSize, this.perms.drillDepth}).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drillhead.level", (Object[])new Object[]{Utils.getHarvestLevelName(this.getMiningLevel(stack))}).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drillhead.speed", (Object[])new Object[]{Utils.formatDouble(this.getMiningSpeed(stack), "0.###")}).withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drillhead.damage", (Object[])new Object[]{Utils.formatDouble(this.getAttackDamage(stack), "0.###")}).withStyle(ChatFormatting.GRAY));
        int maxDmg = this.getMaximumHeadDamage(stack);
        int dmg = maxDmg - this.getHeadDamage(stack);
        float quote = (float)dmg / (float)maxDmg;
        ChatFormatting status = (double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.durability").withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(this.getMaximumHeadDamage(stack) - this.getHeadDamage(stack) + "/" + this.getMaximumHeadDamage(stack))).withStyle(status)));
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack material) {
        return material.is(this.perms.repairMaterial);
    }

    @Override
    public boolean beforeBlockbreak(ItemStack drill, ItemStack head, Player player) {
        return false;
    }

    @Override
    public void afterBlockbreak(ItemStack drill, ItemStack head, Player player) {
    }

    @Override
    public Tier getMiningLevel(ItemStack head) {
        return this.perms.drillLevel;
    }

    @Override
    public float getMiningSpeed(ItemStack head) {
        return this.perms.drillSpeed;
    }

    @Override
    public float getAttackDamage(ItemStack head) {
        return this.perms.drillAttack;
    }

    @Override
    public int getHeadDamage(ItemStack head) {
        return (Integer)head.get(DataComponents.DAMAGE);
    }

    @Override
    public int getMaximumHeadDamage(ItemStack head) {
        return this.perms.maxDamage;
    }

    @Override
    public void damageHead(ItemStack head, int dmg) {
        DrillheadItem.setHeadDamage(head, this.getHeadDamage(head) + dmg);
    }

    public static void setHeadDamage(ItemStack head, int totalDamage) {
        head.set(DataComponents.DAMAGE, (Object)totalDamage);
    }

    @Override
    public ResourceLocation getDrillTexture(ItemStack drill, ItemStack head) {
        return this.perms.texture;
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)this.getHeadDamage(stack) / (float)this.getMaximumHeadDamage(stack)));
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    @Override
    public ImmutableList<BlockPos> getExtraBlocksDug(ItemStack head, Level world, Player player, HitResult rtr) {
        if (!(rtr instanceof BlockHitResult)) {
            return ImmutableList.of();
        }
        BlockHitResult brtr = (BlockHitResult)rtr;
        Direction side = brtr.getDirection();
        int diameter = this.perms.drillSize;
        int depth = this.perms.drillDepth;
        BlockPos startPos = brtr.getBlockPos();
        BlockState state = world.getBlockState(startPos);
        float maxHardness = 1.0f;
        if (!state.isAir()) {
            maxHardness = state.getDestroyProgress(player, (BlockGetter)world, startPos) * 0.4f;
        }
        if (maxHardness < 0.0f) {
            maxHardness = 0.0f;
        }
        if (diameter % 2 == 0) {
            float hx = (float)brtr.getLocation().x - (float)brtr.getBlockPos().getX();
            float hy = (float)brtr.getLocation().y - (float)brtr.getBlockPos().getY();
            float hz = (float)brtr.getLocation().z - (float)brtr.getBlockPos().getZ();
            if (side.getAxis() == Direction.Axis.Y && (double)hx < 0.5 || side.getAxis() == Direction.Axis.Z && (double)hx < 0.5) {
                startPos = startPos.offset(-diameter / 2, 0, 0);
            }
            if (side.getAxis() != Direction.Axis.Y && (double)hy < 0.5) {
                startPos = startPos.offset(0, -diameter / 2, 0);
            }
            if (side.getAxis() == Direction.Axis.Y && (double)hz < 0.5 || side.getAxis() == Direction.Axis.X && (double)hz < 0.5) {
                startPos = startPos.offset(0, 0, -diameter / 2);
            }
        } else {
            startPos = startPos.offset(-(side.getAxis() == Direction.Axis.X ? 0 : diameter / 2), -(side.getAxis() == Direction.Axis.Y ? 0 : diameter / 2), -(side.getAxis() == Direction.Axis.Z ? 0 : diameter / 2));
        }
        ImmutableList.Builder b = ImmutableList.builder();
        for (int dd = 0; dd < depth; ++dd) {
            for (int dw = 0; dw < diameter; ++dw) {
                for (int dh = 0; dh < diameter; ++dh) {
                    boolean hardness;
                    BlockPos pos = startPos.offset(side.getAxis() == Direction.Axis.X ? dd : dw, side.getAxis() == Direction.Axis.Y ? dd : dh, side.getAxis() == Direction.Axis.Y ? dh : (side.getAxis() == Direction.Axis.X ? dw : dd));
                    if (pos.equals((Object)brtr.getBlockPos()) || (state = world.getBlockState(pos)).isAir()) continue;
                    Block block = state.getBlock();
                    float h = state.getDestroyProgress(player, (BlockGetter)world, pos);
                    boolean canHarvest = block.canHarvestBlock(world.getBlockState(pos), (BlockGetter)world, pos, player);
                    boolean drillMat = IEItems.Tools.DRILL.get().isEffective(ItemStack.EMPTY, state);
                    boolean bl = hardness = h >= maxHardness;
                    if (!canHarvest || !drillMat || !hardness) continue;
                    b.add((Object)pos);
                }
            }
        }
        return b.build();
    }

    public static class DrillHeadPerm {
        final String name;
        final TagKey<Item> repairMaterial;
        final int drillSize;
        final int drillDepth;
        final Tier drillLevel;
        final float drillSpeed;
        final float drillAttack;
        final int maxDamage;
        public final ResourceLocation texture;

        public DrillHeadPerm(String name, TagKey<Item> repairMaterial, int drillSize, int drillDepth, Tier drillLevel, float drillSpeed, int drillAttack, int maxDamage, ResourceLocation texture) {
            this.name = name;
            this.repairMaterial = repairMaterial;
            this.drillSize = drillSize;
            this.drillDepth = drillDepth;
            this.drillLevel = drillLevel;
            this.drillSpeed = drillSpeed;
            this.drillAttack = drillAttack;
            this.maxDamage = maxDamage;
            this.texture = texture;
        }
    }
}

