/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.fluidaware;

import blusunrize.immersiveengineering.common.crafting.fluidaware.AbstractFluidAwareRecipe;
import blusunrize.immersiveengineering.common.util.RecipeSerializers;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class ShapelessFluidAwareRecipe
extends AbstractFluidAwareRecipe<MatchLocation> {
    public ShapelessFluidAwareRecipe(String groupIn, NonNullList<Ingredient> recipeItemsIn, ItemStack recipeOutputIn) {
        super(groupIn, recipeItemsIn, recipeOutputIn);
    }

    public ShapelessFluidAwareRecipe(ShapelessRecipe in) {
        this(in.getGroup(), (NonNullList<Ingredient>)in.getIngredients(), in.getResultItem(null));
    }

    @Override
    @Nullable
    public MatchLocation findMatch(CraftingInput inv) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int[] slotToInput = new int[inv.size()];
        Arrays.fill(slotToInput, -1);
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            slotToInput[i] = inputs.size();
            inputs.add(itemstack);
        }
        if (inputs.size() != this.getIngredients().size()) {
            return null;
        }
        int[] matchMap = RecipeMatcher.findMatches(inputs, this.getIngredients());
        if (matchMap == null) {
            return null;
        }
        int[][] slotToIngredient = new int[inv.width()][inv.height()];
        for (int x = 0; x < inv.width(); ++x) {
            for (int y = 0; y < inv.height(); ++y) {
                int inputId = slotToInput[x + inv.width() * y];
                slotToIngredient[x][y] = inputId >= 0 ? matchMap[inputId] : -1;
            }
        }
        return new MatchLocation(slotToIngredient);
    }

    public ShapelessRecipe toVanilla() {
        return new ShapelessRecipe(this.getGroup(), this.category(), this.getResultItem(null), this.getIngredients());
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.getIngredients().size();
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return RecipeSerializers.IE_SHAPELESS_SERIALIZER.get();
    }

    public static class MatchLocation
    implements AbstractFluidAwareRecipe.IMatchLocation {
        private final int[][] map;

        public MatchLocation(int[][] map) {
            this.map = map;
        }

        @Override
        public int getListIndex(int x, int y) {
            return this.map[x][y];
        }
    }
}

