/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.crafting.ArcFurnaceRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MBInventoryUtils;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace.ArcFurnaceInputHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.arcfurnace.ArcFurnaceProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.ArcFurnaceSelectionShapes;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.ArcFurnaceShapes;
import blusunrize.immersiveengineering.common.register.IEParticles;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.inventory.WrappingItemHandler;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ArcFurnaceLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    private static final Set<CapabilityPosition> ENERGY_INPUTS = Set.of(new CapabilityPosition(1, 1, 0, RelativeBlockFace.FRONT), new CapabilityPosition(2, 1, 0, RelativeBlockFace.FRONT), new CapabilityPosition(3, 1, 0, RelativeBlockFace.FRONT));
    private static final List<Vec3> ELECTRODE_OFFSETS = List.of(new Vec3(2.5, 3.9, 2.75), new Vec3(2.125, 3.9, 2.25), new Vec3(2.875, 3.9, 2.25));
    private static final Vec3 SMOKE_OFFSET = new Vec3(2.5, 3.9, 2.5);
    private static final double[] PARTICLE_Y_SPEEDS = new double[]{0.025, 0.05};
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 4);
    private static final BlockPos ELECTRODE_COMPARATOR_POS = new BlockPos(2, 4, 2);
    public static final int FIRST_IN_SLOT = 0;
    public static final int IN_SLOT_COUNT = 12;
    public static final int FIRST_ADDITIVE_SLOT = 12;
    public static final int ADDITIVE_SLOT_COUNT = 4;
    public static final int FIRST_OUT_SLOT = 16;
    public static final int OUT_SLOT_COUNT = 6;
    public static final int SLAG_SLOT = 22;
    public static final int FIRST_ELECTRODE_SLOT = 23;
    public static final int ELECTRODE_COUNT = 3;
    private static final MultiblockFace SLAG_OUT_POS = new MultiblockFace(2, 0, -1, RelativeBlockFace.BACK);
    private static final MultiblockFace MAIN_OUT_POS = new MultiblockFace(2, 0, 5, RelativeBlockFace.FRONT);
    private static final CapabilityPosition SLAG_CAP_POS = CapabilityPosition.opposing(SLAG_OUT_POS);
    private static final CapabilityPosition MAIN_CAP_POS = CapabilityPosition.opposing(MAIN_OUT_POS);
    private static final int[] OUTPUT_SLOTS = (int[])Util.make((Object)new int[6], slots -> {
        for (int i = 0; i < 6; ++i) {
            slots[i] = 16 + i;
        }
    });
    public static final int NUM_SLOTS = 26;
    public static final int ENERGY_CAPACITY = 64000;
    public static ResourceLocation MIF_CONDITION_ADDITIVES = IEApi.ieLoc("arc_furnace/additives");
    public static ResourceLocation MIF_CONDITION_SLAG = IEApi.ieLoc("arc_furnace/slag");
    public static ResourceLocation MIF_CONDITION_ELECTRODES = IEApi.ieLoc("arc_furnace/electrodes");

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        boolean canWork;
        IMultiblockLevel level;
        State state = context.getState();
        boolean tickedAny = state.processor.tickServer(state, level = context.getLevel(), canWork = state.rsControl.isEnabled(context));
        if (state.active != tickedAny || state.updateElectrodePresence()) {
            state.active = tickedAny;
            context.requestMasterBESync();
        }
        if (!canWork || state.energy.getEnergyStored() <= 0) {
            return;
        }
        if (tickedAny) {
            for (int i = 23; i < 26; ++i) {
                ItemUtils.damageStackableItem(state.inventory.getStackInSlot(i), level.getRawLevel(), 1);
            }
        }
        if (state.processor.getQueueSize() < state.processor.getMaxQueueSize()) {
            this.enqueueProcesses(state, level.getRawLevel());
        }
        if (level.shouldTickModulo(8)) {
            this.outputItems(state);
        }
        if (tickedAny && ApiUtils.RANDOM.nextInt(10) == 0) {
            Level rawLevel = level.getRawLevel();
            Vec3 soundPos = level.toAbsolute(new Vec3(1.5, 1.5, 1.5));
            rawLevel.playSound(null, soundPos.x, soundPos.y, soundPos.z, SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.BLOCKS, 0.6f + ApiUtils.RANDOM.nextFloat() * 0.4f, 1.0f);
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (state.pouringMetal > 0) {
            --state.pouringMetal;
        }
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(2.5, 3.0, 2.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.active, context.isValid(), soundPos, IESounds.arcFurnace, 0.375f);
        }
        if (!state.active) {
            return;
        }
        IMultiblockLevel level = context.getLevel();
        Level rawLevel = level.getRawLevel();
        int i = 0;
        while ((double)i < Math.max(1.0, (double)state.queueSize * 0.51)) {
            if (ApiUtils.RANDOM.nextInt(6) == 0) {
                for (Vec3 offset : ELECTRODE_OFFSETS) {
                    Vec3 absPos = level.toAbsolute(offset);
                    for (double ySpeed : PARTICLE_Y_SPEEDS) {
                        rawLevel.addAlwaysVisibleParticle((ParticleOptions)IEParticles.SPARKS.get(), absPos.x, absPos.y, absPos.z, ArcFurnaceLogic.particleSpeed(0.025), ySpeed, ArcFurnaceLogic.particleSpeed(0.025));
                    }
                }
            }
            Vec3 smokePos = level.toAbsolute(SMOKE_OFFSET);
            rawLevel.addAlwaysVisibleParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, smokePos.x, smokePos.y, smokePos.z, ArcFurnaceLogic.particleSpeed(0.009375), 0.0625, ArcFurnaceLogic.particleSpeed(0.009375));
            ++i;
        }
    }

    private static double particleSpeed(double max) {
        return ApiUtils.RANDOM.nextDouble(-max, max);
    }

    private void enqueueProcesses(State state, Level level) {
        Int2IntOpenHashMap usedInvSlots = new Int2IntOpenHashMap();
        for (MultiblockProcess process : state.processor.getQueue()) {
            if (!(process instanceof ArcFurnaceProcess)) continue;
            ArcFurnaceProcess arcProcess = (ArcFurnaceProcess)process;
            int[] inputSlots = arcProcess.getInputSlots();
            int[] inputAmounts = arcProcess.getInputAmounts();
            if (inputAmounts == null) continue;
            for (int i = 0; i < inputSlots.length; ++i) {
                if (inputAmounts[i] <= 0) continue;
                usedInvSlots.addTo(inputSlots[i], inputAmounts[i]);
            }
        }
        NonNullList additives = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
        for (int i = 0; i < 4; ++i) {
            ItemStack additive = state.inventory.getStackInSlot(12 + i);
            if (additive.isEmpty()) continue;
            additives.set(i, (Object)additive.copy());
            if (!usedInvSlots.containsKey(12 + i)) continue;
            ((ItemStack)additives.get(i)).shrink(usedInvSlots.get(12 + i));
        }
        for (int slot = 0; slot < 12; ++slot) {
            int[] consumedAdditives;
            ArcFurnaceProcess process;
            RecipeHolder<ArcFurnaceRecipe> recipe;
            ItemStack stack;
            if (usedInvSlots.containsKey(slot) || (stack = state.inventory.getStackInSlot(slot)).isEmpty() || (recipe = ArcFurnaceRecipe.findRecipe(level, stack, (NonNullList<ItemStack>)additives)) == null || !state.processor.addProcessToQueue(process = new ArcFurnaceProcess(recipe, ApiUtils.RANDOM.nextLong(), slot, 12, 13, 14, 15), level, false) || (consumedAdditives = ((ArcFurnaceRecipe)recipe.value()).getConsumedAdditives((NonNullList<ItemStack>)additives, true)) == null) continue;
            process.setInputAmounts(((ArcFurnaceRecipe)recipe.value()).input.getCount(), consumedAdditives[0], consumedAdditives[1], consumedAdditives[2], consumedAdditives[3]);
        }
    }

    private void outputItems(State state) {
        ItemStack slagStack;
        IItemHandler outputHandler = state.output.get();
        if (outputHandler != null) {
            for (int j : OUTPUT_SLOTS) {
                ItemStack nextStack = state.inventory.getStackInSlot(j);
                if (nextStack.isEmpty()) continue;
                ItemStack stack = nextStack.copyWithCount(1);
                if (!(stack = ItemHandlerHelper.insertItem((IItemHandler)outputHandler, (ItemStack)stack, (boolean)false)).isEmpty()) continue;
                nextStack.shrink(1);
            }
        }
        if ((slagStack = state.inventory.getStackInSlot(22)).isEmpty()) {
            return;
        }
        IItemHandler slagOutputHandler = state.slagOutput.get();
        if (slagOutputHandler != null) {
            int out = Math.min(slagStack.getCount(), 16);
            ItemStack stack = slagStack.copyWithCount(out);
            stack = ItemHandlerHelper.insertItem((IItemHandler)slagOutputHandler, (ItemStack)stack, (boolean)false);
            slagStack.shrink(out -= stack.getCount());
        }
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.register(Capabilities.EnergyStorage.BLOCK, (state, pos) -> pos.side() == null || ENERGY_INPUTS.contains(pos) ? state.energy : null);
        register.register(Capabilities.ItemHandler.BLOCK, (state, pos) -> {
            if (MAIN_CAP_POS.equals(pos)) {
                return state.outputHandler;
            }
            if (SLAG_CAP_POS.equals(pos)) {
                return state.slagHandler;
            }
            if (new BlockPos(1, 3, 2).equals((Object)pos.posInMultiblock())) {
                return state.insertionHandler;
            }
            if (new BlockPos(3, 3, 2).equals((Object)pos.posInMultiblock())) {
                return state.additiveHandler;
            }
            return null;
        });
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public void dropExtraItems(State state, Consumer<ItemStack> drop) {
        MBInventoryUtils.dropItems((IItemHandlerModifiable)state.inventory, drop);
    }

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        if (forType == ShapeType.SELECTION) {
            return ArcFurnaceSelectionShapes.SHAPE_GETTER;
        }
        return ArcFurnaceShapes.SHAPE_GETTER;
    }

    public static ComparatorManager<State> makeInventoryComparator() {
        return ComparatorManager.makeSimple(state -> Utils.calcRedstoneFromInventory(12, (IItemHandler)state.inventory), REDSTONE_POS);
    }

    public static ComparatorManager<State> makeElectrodeComparator() {
        return ComparatorManager.makeSimple(state -> Mth.ceil((float)(Math.max(state.getElectrodeComparatorValue(), 0.0f) * 15.0f)), ELECTRODE_COMPARATOR_POS);
    }

    static {
        MachineInterfaceHandler.copyOptions(MIF_CONDITION_ADDITIVES, MachineInterfaceHandler.BASIC_ITEM_IN);
        MachineInterfaceHandler.copyOptions(MIF_CONDITION_SLAG, MachineInterfaceHandler.BASIC_ITEM_OUT);
        MachineInterfaceHandler.register(MIF_CONDITION_ELECTRODES, MachineInterfaceHandler.buildComparativeConditions(State::getElectrodeComparatorValue));
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInMachine<ArcFurnaceRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(64000);
        public ItemStackHandler inventory = new ItemStackHandler(this, 26){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
        private final MultiblockProcessor.InMachineProcessor<ArcFurnaceRecipe> processor;
        private final Supplier<@Nullable IItemHandler> output;
        private final Supplier<@Nullable IItemHandler> slagOutput;
        private final IItemHandler insertionHandler;
        private final IItemHandler additiveHandler;
        private final IItemHandler outputHandler;
        private final IItemHandler slagHandler;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;
        public final RedstoneControl.RSState rsControl = RedstoneControl.RSState.enabledByDefault();
        private boolean active;
        public byte electrodePresence;
        private int queueSize;
        public int pouringMetal = 0;
        private BooleanSupplier isPlayingSound = () -> false;

        public State(IInitialMultiblockContext<State> ctx) {
            this.processor = new MultiblockProcessor.InMachineProcessor<ArcFurnaceRecipe>(12, $ -> 0.0, 12, ctx.getMarkDirtyRunnable(), ctx.getSyncRunnable(), ArcFurnaceRecipe.RECIPES::getById);
            this.output = ctx.getCapabilityAt(Capabilities.ItemHandler.BLOCK, MAIN_OUT_POS);
            this.slagOutput = ctx.getCapabilityAt(Capabilities.ItemHandler.BLOCK, SLAG_OUT_POS);
            this.insertionHandler = new ArcFurnaceInputHandler((IItemHandlerModifiable)this.inventory, ctx.getMarkDirtyRunnable());
            this.additiveHandler = new WrappingItemHandler((IItemHandler)this.inventory, true, false, new WrappingItemHandler.IntRange(12, 16));
            this.outputHandler = new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(16, 22));
            this.slagHandler = new WrappingItemHandler((IItemHandler)this.inventory, false, true, new WrappingItemHandler.IntRange(22, 23));
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.active, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.insertionHandler, MachineInterfaceHandler.BASIC_ITEM_IN), new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.additiveHandler, MIF_CONDITION_ADDITIVES), new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.outputHandler, MachineInterfaceHandler.BASIC_ITEM_OUT), new MachineInterfaceHandler.MachineCheckImplementation<IItemHandler>(this.slagHandler, MIF_CONDITION_SLAG), new MachineInterfaceHandler.MachineCheckImplementation<AveragingEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY), new MachineInterfaceHandler.MachineCheckImplementation<State>(this, MIF_CONDITION_ELECTRODES)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.put("inventory", (Tag)this.inventory.serializeNBT(provider));
            nbt.put("processor", this.processor.toNBT(provider));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.energy.deserializeNBT(provider, nbt.get("energy"));
            this.inventory.deserializeNBT(provider, nbt.getCompound("inventory"));
            this.processor.fromNBT(nbt.get("processor"), (getRecipe, data, p) -> new ArcFurnaceProcess(getRecipe, data), provider);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putByte("electrodeMask", this.electrodePresence);
            nbt.putBoolean("active", this.active);
            nbt.putInt("pouringMetal", this.pouringMetal);
            nbt.putInt("queueSize", this.processor.getQueueSize());
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.electrodePresence = nbt.getByte("electrodeMask");
            this.active = nbt.getBoolean("active");
            this.pouringMetal = nbt.getInt("pouringMetal");
            this.queueSize = nbt.getInt("queueSize");
        }

        private boolean updateElectrodePresence() {
            byte electrodePresence = 0;
            for (int i = 0; i < 3; ++i) {
                if (this.inventory.getStackInSlot(i + 23).isEmpty()) continue;
                electrodePresence = (byte)(electrodePresence | (byte)(1 << i));
            }
            if (electrodePresence != this.electrodePresence) {
                this.electrodePresence = electrodePresence;
                return true;
            }
            return false;
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public ItemStackHandler getInventory() {
            return this.inventory;
        }

        @Override
        public int[] getOutputSlots() {
            return OUTPUT_SLOTS;
        }

        public boolean isClientActive() {
            return this.active;
        }

        public List<MultiblockProcess<ArcFurnaceRecipe, ProcessContext.ProcessContextInMachine<ArcFurnaceRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }

        private float getElectrodeComparatorValue() {
            return (float)IntStream.range(0, 3).mapToDouble(i -> {
                ItemStack electrode = this.inventory.getStackInSlot(23 + i);
                if (electrode.isEmpty()) {
                    return 0.0;
                }
                return 1.0f - (float)electrode.getDamageValue() / (float)electrode.getMaxDamage();
            }).min().orElse(0.0);
        }

        public boolean hasElectrodes() {
            for (int i = 23; i < 26; ++i) {
                if (!this.inventory.getStackInSlot(i).isEmpty()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean additionalCanProcessCheck(MultiblockProcess<ArcFurnaceRecipe, ?> process, Level level) {
            if (!this.hasElectrodes()) {
                return false;
            }
            ArcFurnaceRecipe recipe = process.getRecipe(level);
            if (recipe == null || recipe.slag.get().isEmpty()) {
                return true;
            }
            ItemStack slag = this.inventory.getStackInSlot(22);
            if (slag.isEmpty()) {
                return true;
            }
            return ItemStack.isSameItemSameComponents((ItemStack)slag, (ItemStack)recipe.slag.get()) && slag.getCount() + recipe.slag.get().getCount() <= 64;
        }

        @Override
        public void onProcessFinish(MultiblockProcess<ArcFurnaceRecipe, ?> process, Level level) {
            ArcFurnaceRecipe recipe = process.getRecipe(level);
            if (recipe == null || recipe.slag.get().isEmpty()) {
                return;
            }
            ItemStack slag = this.inventory.getStackInSlot(22);
            if (slag.isEmpty()) {
                this.inventory.setStackInSlot(22, recipe.slag.get().copy());
            } else if (ItemStack.isSameItemSameComponents((ItemStack)slag, (ItemStack)recipe.slag.get())) {
                slag.grow(recipe.slag.get().getCount());
            }
        }
    }
}

