/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistration;
import blusunrize.immersiveengineering.api.multiblocks.blocks.MultiblockRegistrationBuilder;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.multiblocks.component.MultiblockGui;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.neoforged.bus.api.IEventBus;

public class IEMultiblockBuilder<S extends IMultiblockState>
extends MultiblockRegistrationBuilder<S, IEMultiblockBuilder<S>> {
    private static final List<Consumer<IEventBus>> LAZY_MOD_BUS_REGISTRATION = new ArrayList<Consumer<IEventBus>>();

    public IEMultiblockBuilder(IMultiblockLogic<S> logic, String name) {
        super(logic, ImmersiveEngineering.rl(name));
    }

    public IEMultiblockBuilder<S> gui(IEMenuTypes.MultiblockContainer<S, ?> menu) {
        return (IEMultiblockBuilder)this.component(new MultiblockGui<S>(menu));
    }

    public IEMultiblockBuilder<S> redstoneNoComputer(IMultiblockComponent.StateWrapper<S, RedstoneControl.RSState> getState, BlockPos ... positions) {
        this.redstoneAware();
        return this.selfWrappingComponent(new RedstoneControl<S>(getState, false, positions));
    }

    public IEMultiblockBuilder<S> redstone(IMultiblockComponent.StateWrapper<S, RedstoneControl.RSState> getState, BlockPos ... positions) {
        this.redstoneAware();
        return this.selfWrappingComponent(new RedstoneControl<S>(getState, positions));
    }

    public IEMultiblockBuilder<S> comparator(ComparatorManager<S> comparator) {
        this.withComparator();
        return (IEMultiblockBuilder)super.selfWrappingComponent(comparator);
    }

    public MultiblockRegistration<S> build() {
        return super.build(LAZY_MOD_BUS_REGISTRATION::add);
    }

    @Override
    public <CS, C extends IMultiblockComponent<CS> & IMultiblockComponent.StateWrapper<S, CS>> IEMultiblockBuilder<S> selfWrappingComponent(C extraComponent) {
        Preconditions.checkArgument((!(extraComponent instanceof ComparatorManager) ? 1 : 0) != 0);
        return (IEMultiblockBuilder)super.selfWrappingComponent(extraComponent);
    }

    @Override
    protected IEMultiblockBuilder<S> self() {
        return this;
    }

    public static void handleModBusRegistrations(IEventBus modBus) {
        LAZY_MOD_BUS_REGISTRATION.forEach(registration -> registration.accept(modBus));
    }
}

