/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.multiblocks.logic;

import blusunrize.immersiveengineering.api.crafting.CrusherRecipe;
import blusunrize.immersiveengineering.api.energy.AveragingEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.ComparatorManager;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IClientTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IMultiblockComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.IServerTickableComponent;
import blusunrize.immersiveengineering.api.multiblocks.blocks.component.RedstoneControl;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IInitialMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockLevel;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockLogic;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.CapabilityPosition;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.MultiblockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.RelativeBlockFace;
import blusunrize.immersiveengineering.api.multiblocks.blocks.util.ShapeType;
import blusunrize.immersiveengineering.api.tool.MachineInterfaceHandler;
import blusunrize.immersiveengineering.common.EventHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.DirectProcessingItemHandler;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcess;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessInWorld;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.MultiblockProcessor;
import blusunrize.immersiveengineering.common.blocks.multiblocks.process.ProcessContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.shapes.CrusherShapes;
import blusunrize.immersiveengineering.common.util.DroppingMultiblockOutput;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.sound.MultiblockSound;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class CrusherLogic
implements IMultiblockLogic<State>,
IServerTickableComponent<State>,
IClientTickableComponent<State> {
    public static final BlockPos MASTER_OFFSET = new BlockPos(2, 1, 1);
    public static final BlockPos REDSTONE_POS = new BlockPos(0, 1, 2);
    private static final MultiblockFace OUTPUT_POS = new MultiblockFace(2, 0, 3, RelativeBlockFace.FRONT);
    private static final CapabilityPosition ENERGY_INPUT = new CapabilityPosition(4, 1, 1, RelativeBlockFace.UP);
    private static final Vec3[] PARTICLE_POSITIONS = new Vec3[]{new Vec3(2.0, 2.125, 1.5), new Vec3(2.5, 2.125, 1.5), new Vec3(3.0, 2.125, 1.5)};

    @Override
    public State createInitialState(IInitialMultiblockContext<State> capabilitySource) {
        return new State(capabilitySource);
    }

    @Override
    public void tickServer(IMultiblockContext<State> context) {
        State state = context.getState();
        boolean wasActive = state.renderAsActive;
        state.renderAsActive = state.processor.tickServer(state, context.getLevel(), state.rsState.isEnabled(context));
        if (wasActive != state.renderAsActive) {
            context.requestMasterBESync();
        }
        if (state.renderAsActive) {
            this.spawnParticles(context.getLevel(), state);
        }
    }

    public void spawnParticles(IMultiblockLevel level, State state) {
        MultiblockProcessInWorld inWorld;
        ServerLevel serverLevel;
        block6: {
            block5: {
                Level level2;
                if (state.processor.getQueueSize() == 0 || !((level2 = level.getRawLevel()) instanceof ServerLevel)) {
                    return;
                }
                serverLevel = (ServerLevel)level2;
                MultiblockProcess<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>> particleProcess = state.processor.getQueue().get(0);
                if (!(particleProcess instanceof MultiblockProcessInWorld)) break block5;
                inWorld = (MultiblockProcessInWorld)particleProcess;
                if (!inWorld.inputItems.isEmpty()) break block6;
            }
            return;
        }
        ItemStack particleStack = (ItemStack)inWorld.inputItems.get(0);
        ItemParticleOption particleData = new ItemParticleOption(ParticleTypes.ITEM, particleStack);
        for (Vec3 relativeOffset : PARTICLE_POSITIONS) {
            Vec3 absolutePos = level.toAbsolute(relativeOffset);
            serverLevel.sendParticles((ParticleOptions)particleData, absolutePos.x, absolutePos.y, absolutePos.z, 8, 0.125, 0.75, 0.125, 0.0625);
        }
    }

    @Override
    public void tickClient(IMultiblockContext<State> context) {
        State state = context.getState();
        if (state.renderAsActive) {
            state.barrelAngle = (state.barrelAngle + 18.0f) % 360.0f;
        }
        if (!state.isPlayingSound.getAsBoolean()) {
            Vec3 soundPos = context.getLevel().toAbsolute(new Vec3(2.5, 1.5, 1.5));
            state.isPlayingSound = MultiblockSound.startSound(() -> state.renderAsActive, context.isValid(), soundPos, IESounds.crusher, 0.5f);
        }
    }

    @Override
    public void registerCapabilities(IMultiblockComponent.CapabilityRegistrar<State> register) {
        register.registerAtOrNull(Capabilities.EnergyStorage.BLOCK, ENERGY_INPUT, state -> state.energy);
        register.register(Capabilities.ItemHandler.BLOCK, (state, position) -> {
            if (CrusherLogic.isInInput(position.posInMultiblock(), false)) {
                return state.insertionHandler;
            }
            return null;
        });
        register.registerAtBlockPos(MachineInterfaceHandler.IMachineInterfaceConnection.CAPABILITY, REDSTONE_POS, state -> state.mifHandler);
    }

    @Override
    public Function<BlockPos, VoxelShape> shapeGetter(ShapeType forType) {
        return CrusherShapes.SHAPE_GETTER;
    }

    private static boolean isInInput(BlockPos posInMultiblock, boolean allowMiddleLayer) {
        if (posInMultiblock.getY() == 2 || allowMiddleLayer && posInMultiblock.getY() == 1) {
            return posInMultiblock.getX() > 0 && posInMultiblock.getX() < 4;
        }
        return false;
    }

    @Override
    public void onEntityCollision(IMultiblockContext<State> ctx, BlockPos posInMultiblock, Entity collided) {
        block11: {
            int consumed;
            IMultiblockLevel level;
            State state;
            block12: {
                block10: {
                    if (collided.level().isClientSide || !CrusherLogic.isInInput(posInMultiblock, true)) {
                        return;
                    }
                    state = ctx.getState();
                    if (!collided.isAlive() || !state.rsState.isEnabled(ctx)) {
                        return;
                    }
                    level = ctx.getLevel();
                    AABB internalBB = new AABB(1.4375, 1.25, 0.4375, 3.5625, 2.5, 2.5625);
                    AABB crusherInternal = level.toAbsolute(internalBB);
                    if (!collided.getBoundingBox().intersects(crusherInternal)) {
                        return;
                    }
                    if (!(collided instanceof ItemEntity)) break block10;
                    ItemEntity itemEntity = (ItemEntity)collided;
                    ItemStack stack = itemEntity.getItem();
                    if (stack.isEmpty()) {
                        return;
                    }
                    ItemStack remaining = state.insertionHandler.insertItem(0, stack, false);
                    if (remaining.isEmpty()) {
                        itemEntity.discard();
                    } else {
                        itemEntity.setItem(remaining);
                    }
                    break block11;
                }
                if (!(collided instanceof LivingEntity)) break block11;
                if (!(collided instanceof Player)) break block12;
                Player player = (Player)collided;
                if (player.getAbilities().invulnerable) break block11;
            }
            if ((consumed = state.energy.extractEnergy(80, false)) > 0) {
                EventHandler.crusherMap.put(collided.getUUID(), s -> state.doProcessOutput((ItemStack)s, level));
                collided.hurt(IEDamageSources.crusher(collided.level()), (float)consumed / 20.0f);
            }
        }
    }

    public static ComparatorManager<State> makeComparator() {
        return ComparatorManager.makeSimple(state -> {
            float fill = (float)state.processor.getQueueSize() / (float)state.processor.getMaxQueueSize();
            return Mth.ceil((float)(fill * 14.0f)) + (fill > 0.0f ? 1 : 0);
        }, REDSTONE_POS);
    }

    public static class State
    implements IMultiblockState,
    ProcessContext.ProcessContextInWorld<CrusherRecipe> {
        private final AveragingEnergyStorage energy = new AveragingEnergyStorage(32000);
        private final MultiblockProcessor<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>> processor;
        private boolean renderAsActive;
        private float barrelAngle;
        public final RedstoneControl.RSState rsState = RedstoneControl.RSState.enabledByDefault();
        private final DroppingMultiblockOutput output;
        private final IItemHandler insertionHandler;
        private BooleanSupplier isPlayingSound = () -> false;
        private final MachineInterfaceHandler.IMachineInterfaceConnection mifHandler;

        public State(IInitialMultiblockContext<State> ctx) {
            this.output = new DroppingMultiblockOutput(OUTPUT_POS, ctx);
            this.processor = new MultiblockProcessor(2048, 0.0f, 1, ctx.getMarkDirtyRunnable(), CrusherRecipe.RECIPES::getById);
            this.insertionHandler = new DirectProcessingItemHandler<CrusherRecipe>(ctx.levelSupplier(), this.processor, CrusherRecipe::findRecipe).setProcessStacking(true);
            this.mifHandler = () -> new MachineInterfaceHandler.MachineCheckImplementation[]{new MachineInterfaceHandler.MachineCheckImplementation<BooleanSupplier>(() -> this.renderAsActive, MachineInterfaceHandler.BASIC_ACTIVE), new MachineInterfaceHandler.MachineCheckImplementation<MultiblockProcessor<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>>>(this.processor, MachineInterfaceHandler.BASIC_ITEM_IN, this.processor.getMachineInterfaceOptions(true)), new MachineInterfaceHandler.MachineCheckImplementation<AveragingEnergyStorage>(this.energy, MachineInterfaceHandler.BASIC_ENERGY)};
        }

        @Override
        public void writeSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.put("energy", this.energy.serializeNBT(provider));
            nbt.put("processor", this.processor.toNBT(provider));
        }

        @Override
        public void readSaveNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.energy.deserializeNBT(provider, nbt.get("energy"));
            this.processor.fromNBT(nbt.get("processor"), MultiblockProcessInWorld::new, provider);
        }

        @Override
        public void writeSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            nbt.putBoolean("renderActive", this.renderAsActive);
        }

        @Override
        public void readSyncNBT(CompoundTag nbt, HolderLookup.Provider provider) {
            this.renderAsActive = nbt.getBoolean("renderActive");
        }

        @Override
        public void doProcessOutput(ItemStack output, IMultiblockLevel level) {
            this.output.insertOrDrop(output, level);
        }

        @Override
        public AveragingEnergyStorage getEnergy() {
            return this.energy;
        }

        public boolean shouldRenderActive() {
            return this.renderAsActive;
        }

        public float getBarrelAngle() {
            return this.barrelAngle;
        }

        public List<MultiblockProcess<CrusherRecipe, ProcessContext.ProcessContextInWorld<CrusherRecipe>>> getProcessQueue() {
            return this.processor.getQueue();
        }
    }
}

