/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.api.energy.NullEnergyStorage;
import blusunrize.immersiveengineering.api.energy.ThermoelectricSource;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.BlockCapabilityRegistration;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.CachedRecipe;
import blusunrize.immersiveengineering.common.util.IEBlockCapabilityCaches;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class ThermoelectricGenBlockEntity
extends IEBaseBlockEntity
implements IEServerTickableBE {
    private int energyOutput = -1;
    private final Map<Direction, IEBlockCapabilityCaches.IEBlockCapabilityCache<IEnergyStorage>> energyWrappers = IEBlockCapabilityCaches.allNeighbors(Capabilities.EnergyStorage.BLOCK, this);
    private final Map<Direction, BiFunction<Level, Block, Integer>> temperatureGetters = new EnumMap<Direction, BiFunction<Level, Block, Integer>>(Direction.class);

    public ThermoelectricGenBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)IEBlockEntities.THERMOELECTRIC_GEN.get(), pos, state);
        for (Direction d : DirectionUtils.VALUES) {
            this.temperatureGetters.put(d, CachedRecipe.cached(ThermoelectricSource::getSource).andThen(source -> source == null ? -1 : source.getTemperature()));
        }
    }

    @Override
    public void tickServer() {
        if (this.level.getGameTime() % 1024L == (long)((this.getBlockPos().getX() ^ this.getBlockPos().getZ()) & 0x3FF)) {
            this.recalculateEnergyOutput();
        }
        if (this.energyOutput > 0) {
            this.outputEnergy(this.energyOutput);
        }
    }

    public void outputEnergy(int amount) {
        for (Direction fd : DirectionUtils.VALUES) {
            IEnergyStorage forSide = this.energyWrappers.get(fd).getCapability();
            if (forSide == null || (amount -= forSide.receiveEnergy(amount, false)) > 0) continue;
            return;
        }
    }

    @Override
    public void onNeighborBlockChange(BlockPos pos) {
        super.onNeighborBlockChange(pos);
        this.recalculateEnergyOutput();
    }

    private void recalculateEnergyOutput() {
        int energy = 0;
        for (Direction fd : new Direction[]{Direction.DOWN, Direction.NORTH, Direction.WEST}) {
            if (this.level.isEmptyBlock(this.getBlockPos().relative(fd)) || this.level.isEmptyBlock(this.getBlockPos().relative(fd.getOpposite()))) continue;
            int temp0 = this.getTemperature(fd);
            int temp1 = this.getTemperature(fd.getOpposite());
            if (temp0 <= -1 || temp1 <= -1) continue;
            int diff = Math.abs(temp0 - temp1);
            energy += (int)(Math.sqrt(diff) / 2.0 * (Double)IEServerConfig.MACHINES.thermoelectric_output.get());
        }
        this.energyOutput = energy == 0 ? -1 : energy;
    }

    private int getTemperature(Direction offset) {
        BlockPos pos = this.worldPosition.relative(offset);
        BlockState state = this.level.getBlockState(pos);
        FluidState f = state.getFluidState();
        if (!f.isEmpty()) {
            return f.getFluidType().getTemperature(f, (BlockAndTintGetter)this.level, pos);
        }
        return this.temperatureGetters.get(offset).apply(this.level, state.getBlock());
    }

    @Override
    public void readCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        this.energyOutput = nbt.getInt("enegyOutput");
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        nbt.putInt("enegyOutput", this.energyOutput);
    }

    public static void registerCapabilities(BlockCapabilityRegistration.BECapabilityRegistrar<ThermoelectricGenBlockEntity> registrar) {
        registrar.registerAllContexts(Capabilities.EnergyStorage.BLOCK, $ -> NullEnergyStorage.INSTANCE);
    }
}

