/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEEnums;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.utils.SafeChunkUtils;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.redstone.IRedstoneConnector;
import blusunrize.immersiveengineering.api.wires.redstone.RedstoneNetworkHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.PlacementLimitation;
import blusunrize.immersiveengineering.common.blocks.generic.ConnectorBlock;
import blusunrize.immersiveengineering.common.blocks.generic.ImmersiveConnectableBlockEntity;
import blusunrize.immersiveengineering.common.blocks.metal.EnergyConnectorBlockEntity;
import blusunrize.immersiveengineering.common.blocks.ticking.IEServerTickableBE;
import blusunrize.immersiveengineering.common.register.IEBlockEntities;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ConnectorRedstoneBlockEntity
extends ImmersiveConnectableBlockEntity
implements IEServerTickableBE,
IEBlockInterfaces.IStateBasedDirectional,
IEBlockInterfaces.IRedstoneOutput,
IEBlockInterfaces.IScrewdriverInteraction,
IEBlockInterfaces.IBlockBounds,
IEBlockInterfaces.IBlockOverlayText,
IRedstoneConnector {
    public IEEnums.IOSideConfig ioMode = IEEnums.IOSideConfig.INPUT;
    public DyeColor redstoneChannel = DyeColor.WHITE;
    public boolean rsDirty = false;
    protected int output;

    public ConnectorRedstoneBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType<? extends ConnectorRedstoneBlockEntity>)((BlockEntityType)IEBlockEntities.CONNECTOR_REDSTONE.get()), pos, state);
    }

    public ConnectorRedstoneBlockEntity(BlockEntityType<? extends ConnectorRedstoneBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tickServer() {
        if (this.rsDirty) {
            this.globalNet.getLocalNet(this.worldPosition).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
        }
    }

    @Override
    public int getStrongRSOutput(@Nonnull Direction side) {
        if (side == this.getFacing().getOpposite()) {
            return this.getWeakRSOutput(side);
        }
        return 0;
    }

    @Override
    public int getWeakRSOutput(@Nonnull Direction side) {
        if (!this.isRSOutput() || side == this.getFacing()) {
            return 0;
        }
        return this.output;
    }

    @Override
    public boolean canConnectRedstone(@Nonnull Direction side) {
        return side != this.getFacing().getOpposite();
    }

    @Override
    public void onChange(ConnectionPoint cp, RedstoneNetworkHandler handler) {
        if (!this.level.isClientSide && SafeChunkUtils.isChunkSafe((LevelAccessor)this.level, this.worldPosition)) {
            this.output = handler.getValue(this.redstoneChannel.getId());
            if (!this.isRemoved() && this.isRSOutput()) {
                this.setChanged();
                this.markContainingBlockForUpdate(this.getBlockState());
                BlockPos offsetPos = this.worldPosition.relative(this.getFacing());
                this.level.updateNeighborsAt(offsetPos, this.level.getBlockState(offsetPos).getBlock());
            }
        }
    }

    public boolean isRSInput() {
        return this.ioMode == IEEnums.IOSideConfig.INPUT;
    }

    @Override
    public void updateInput(byte[] signals, ConnectionPoint cp) {
        if (this.isRSInput()) {
            signals[this.redstoneChannel.getId()] = (byte)this.getMaxRSInput();
        }
        this.rsDirty = false;
    }

    protected boolean acceptSignalFrom(Direction side) {
        BlockPos offset = this.worldPosition.relative(side);
        BlockEntity te = SafeChunkUtils.getSafeBE((LevelAccessor)this.level, offset);
        if (!(te instanceof ConnectorRedstoneBlockEntity)) {
            return true;
        }
        ConnectorRedstoneBlockEntity rsConnector = (ConnectorRedstoneBlockEntity)te;
        if (!this.getLocalNet(0).getConnectors().contains(offset)) {
            return true;
        }
        return rsConnector.redstoneChannel != this.redstoneChannel;
    }

    @Override
    protected int getRSInput(Direction from) {
        if (this.acceptSignalFrom(from)) {
            return super.getRSInput(from);
        }
        return 0;
    }

    public boolean isRSOutput() {
        return this.ioMode == IEEnums.IOSideConfig.OUTPUT;
    }

    @Override
    public ItemInteractionResult screwdriverUseSide(Direction side, Player player, InteractionHand hand, Vec3 hitVec) {
        if (this.level.isClientSide) {
            ImmersiveEngineering.proxy.openTileScreen("redstoneconnector", this);
        }
        return ItemInteractionResult.SUCCESS;
    }

    protected void updateAfterConfigure() {
        this.setChanged();
        this.globalNet.getLocalNet(this.worldPosition).getHandler(RedstoneNetworkHandler.ID, RedstoneNetworkHandler.class).updateValues();
        this.markContainingBlockForUpdate(null);
        this.level.blockEvent(this.getBlockPos(), this.getBlockState().getBlock(), 254, 0);
    }

    @Override
    public boolean canConnectCable(WireType cableType, ConnectionPoint target, Vec3i offset) {
        return "REDSTONE".equals(cableType.getCategory());
    }

    @Override
    public Property<Direction> getFacingProperty() {
        return ConnectorBlock.DEFAULT_FACING_PROP;
    }

    @Override
    public PlacementLimitation getFacingLimitation() {
        return PlacementLimitation.SIDE_CLICKED;
    }

    @Override
    public boolean mirrorFacingOnPlacement(LivingEntity placer) {
        return true;
    }

    @Override
    public boolean canHammerRotate(Direction side, Vec3 hit, LivingEntity entity) {
        return false;
    }

    @Override
    public void receiveMessageFromClient(CompoundTag message) {
        if (message.contains("ioMode")) {
            this.ioMode = IEEnums.IOSideConfig.VALUES[message.getInt("ioMode")];
        }
        if (message.contains("redstoneChannel")) {
            this.redstoneChannel = DyeColor.byId((int)message.getInt("redstoneChannel"));
        }
        this.updateAfterConfigure();
    }

    @Override
    public void writeCustomNBT(CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.writeCustomNBT(nbt, descPacket, provider);
        nbt.putInt("ioMode", this.ioMode.ordinal());
        nbt.putInt("redstoneChannel", this.redstoneChannel.getId());
        nbt.putInt("output", this.output);
    }

    @Override
    public void readCustomNBT(@Nonnull CompoundTag nbt, boolean descPacket, HolderLookup.Provider provider) {
        super.readCustomNBT(nbt, descPacket, provider);
        this.ioMode = IEEnums.IOSideConfig.VALUES[nbt.getInt("ioMode")];
        this.redstoneChannel = DyeColor.byId((int)nbt.getInt("redstoneChannel"));
        this.output = nbt.getInt("output");
    }

    @Override
    public Vec3 getConnectionOffset(ConnectionPoint here, ConnectionPoint other, WireType type) {
        Direction side = this.getFacing().getOpposite();
        double conRadius = type.getRenderDiameter() / 2.0;
        return new Vec3(0.5 - conRadius * (double)side.getStepX(), 0.5 - conRadius * (double)side.getStepY(), 0.5 - conRadius * (double)side.getStepZ());
    }

    @Override
    public VoxelShape getBlockBounds(@Nullable CollisionContext ctx) {
        return EnergyConnectorBlockEntity.getConnectorBounds(this.getFacing(), 0.625f);
    }

    @Override
    public Component[] getOverlayText(Player player, HitResult mop, boolean hammer) {
        if (!Utils.isScrewdriver(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            return null;
        }
        return new Component[]{ConnectorRedstoneBlockEntity.getChannelComponent("", this.redstoneChannel), Component.translatable((String)("desc.immersiveengineering.info.blockSide.io." + this.ioMode.getSerializedName()))};
    }

    protected static Component getChannelComponent(String subtype, DyeColor channel) {
        return Component.empty().append((Component)Component.translatable((String)("gui.immersiveengineering.config.redstone_color" + subtype))).append((Component)Component.literal((String)" ")).append((Component)Lib.getRedstoneColorComponent(channel));
    }

    @Override
    public boolean useNixieFont(Player player, HitResult mop) {
        return false;
    }

    @Override
    public Collection<ResourceLocation> getRequestedHandlers() {
        return ImmutableList.of((Object)RedstoneNetworkHandler.ID);
    }

    @Override
    public void onNeighborBlockChange(BlockPos otherPos) {
        int oldRSIn = this.getMaxRSInput();
        super.onNeighborBlockChange(otherPos);
        if (this.isRSInput() && oldRSIn != this.getMaxRSInput()) {
            this.rsDirty = true;
        }
    }
}

