/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.api.tool.upgrade.UpgradeEffect;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.metal.RazorWireBlockEntity;
import blusunrize.immersiveengineering.common.entities.illager.EngineerIllager;
import blusunrize.immersiveengineering.common.items.DrillItem;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.items.ManualItem;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.items.components.AttachedItem;
import blusunrize.immersiveengineering.common.network.MessageMinecartShaderSync;
import blusunrize.immersiveengineering.common.network.MessageOpenManual;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import blusunrize.immersiveengineering.common.register.IEDataComponents;
import blusunrize.immersiveengineering.common.register.IEEntityTypes;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.register.IEPotions;
import blusunrize.immersiveengineering.common.register.IEStats;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.level.NoteBlockEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

public class EventHandler {
    public static final Queue<Runnable> SERVER_TASKS = new ArrayDeque<Runnable>();
    public static Map<UUID, Consumer<ItemStack>> crusherMap = new HashMap<UUID, Consumer<ItemStack>>();
    private static final LoadingCache<UUID, int[]> RESONANZ_NOTES_HEARD = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(30L, TimeUnit.SECONDS).build(CacheLoader.from(() -> new int[]{-1, -1, -1}));
    private static final int[] RESONANZ_TARGET = new int[]{5, 11, 15};
    private static final List<IllagerUpgrade> ILLAGER_UPGRADES = List.of(new IllagerUpgrade((EntityType<? extends Raider>)EntityType.PILLAGER, (EntityType<? extends Raider>)((EntityType)IEEntityTypes.FUSILIER.get()), 0.5f), new IllagerUpgrade((EntityType<? extends Raider>)EntityType.VINDICATOR, (EntityType<? extends Raider>)((EntityType)IEEntityTypes.BULWARK.get()), 0.1f), new IllagerUpgrade((EntityType<? extends Raider>)EntityType.VINDICATOR, (EntityType<? extends Raider>)((EntityType)IEEntityTypes.COMMANDO.get()), 0.33f), new IllagerUpgrade((EntityType<? extends Raider>)EntityType.RAVAGER, (EntityType<? extends Raider>)((EntityType)IEEntityTypes.BULWARK.get()), 0.2f), new IllagerUpgrade((EntityType<? extends Raider>)EntityType.EVOKER, (EntityType<? extends Raider>)((EntityType)IEEntityTypes.COMMANDO.get()), 0.33f));
    private static final Function<Raid, Predicate<ServerPlayer>> canTriggerEngineerRaid = raid -> serverPlayer -> {
        ServerLevel level = serverPlayer.serverLevel();
        ServerAdvancementManager manager = level.getServer().getAdvancements();
        AdvancementHolder advancement = manager.get(IEApi.ieLoc("main/kill_illager"));
        return level.getRaidAt(serverPlayer.blockPosition()) == raid && advancement != null && serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone();
    };

    @SubscribeEvent
    public void onLoad(LevelEvent.Load event) {
        ImmersiveEngineering.proxy.onWorldLoad();
    }

    @SubscribeEvent
    public void onMinecartInteraction(PlayerInteractEvent.EntityInteractSpecific event) {
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        if (!(entity instanceof AbstractMinecart)) {
            return;
        }
        AbstractMinecart cart = (AbstractMinecart)entity;
        Item item = stack.getItem();
        if (item instanceof IShaderItem) {
            IShaderItem shaderItem = (IShaderItem)item;
            CapabilityShader.ShaderWrapper wrapper = (CapabilityShader.ShaderWrapper)cart.getData(IEDataAttachments.MINECART_SHADER);
            if (wrapper != null && !event.getLevel().isClientSide) {
                wrapper.setShader(shaderItem.getShaderName());
                PacketDistributor.sendToPlayersTrackingEntity((Entity)cart, (CustomPacketPayload)new MessageMinecartShaderSync(cart.getId(), Optional.ofNullable(wrapper.getShader())), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.SUCCESS);
        }
    }

    @SubscribeEvent
    public void onItemPickup(ItemEntityPickupEvent.Post event) {
        Player player = event.getPlayer();
        ItemStack stack = event.getItemEntity().getItem();
        if (!stack.isEmpty() && stack.getItem() instanceof IShaderItem) {
            ResourceLocation shader = ((IShaderItem)stack.getItem()).getShaderName();
            ShaderRegistry.markShaderReceived(player.getUUID(), shader);
        }
    }

    @SubscribeEvent
    public void onWorldTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (level.isClientSide) {
            return;
        }
        GlobalWireNetwork.getNetwork(level).update(level);
        int numToRun = SERVER_TASKS.size();
        for (int i = 0; i < numToRun; ++i) {
            Runnable next = SERVER_TASKS.poll();
            if (next == null) continue;
            next.run();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsLowest(LivingDropsEvent event) {
        Consumer<ItemStack> crusher;
        if (!event.isCanceled() && event.getSource().is(Lib.DamageTypes.CRUSHER) && (crusher = crusherMap.get(event.getEntity().getUUID())) != null) {
            for (ItemEntity item : event.getDrops()) {
                if (item == null || item.getItem().isEmpty()) continue;
                crusher.accept(item.getItem());
            }
            crusherMap.remove(event.getEntity().getUUID());
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        if (!event.isCanceled()) {
            boolean isBoss = event.getEntity().getType().is(Tags.EntityTypes.BOSSES);
            if (!isBoss || event.getEntity().getType().is(IETags.shaderbagBlacklist)) {
                return;
            }
            ItemStack bag = new ItemStack((ItemLike)IEItems.Misc.SHADER_BAG.get(Rarity.EPIC));
            event.getDrops().add(new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), bag));
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingDamageEvent.Pre event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            IEnergyStorage packStorage;
            LivingEntity attacker;
            Entity entity;
            Player player = (Player)livingEntity;
            ItemStack activeStack = player.getUseItem();
            if (!activeStack.isEmpty() && activeStack.getItem() instanceof IEShieldItem && event.getOriginalDamage() >= 3.0f && Utils.canBlockDamageSource((LivingEntity)player, event.getSource())) {
                float amount = event.getOriginalDamage();
                ((IEShieldItem)activeStack.getItem()).hitShield(activeStack, player, event.getSource(), amount, event);
            }
            RandomSource rng = player.getRandom();
            ItemStack powerpack = PowerpackItem.POWERPACK_GETTER.getFrom((LivingEntity)player);
            if (!powerpack.isEmpty() && PowerpackItem.getUpgradesStatic(powerpack).has(UpgradeEffect.TESLA) && (entity = event.getSource().getEntity()) instanceof LivingEntity && (attacker = (LivingEntity)entity).distanceToSqr((Entity)player) < 4.0 && (packStorage = (IEnergyStorage)powerpack.getCapability(Capabilities.EnergyStorage.ITEM)) != null && packStorage.extractEnergy(1024, true) == 1024) {
                packStorage.extractEnergy(1024, false);
                IEDamageSources.ElectricDamageSource dmgsrc = IEDamageSources.causeTeslaDamage(player.level(), 2 + player.getRandom().nextInt(4), true);
                if (dmgsrc.apply((Entity)attacker)) {
                    attacker.addEffect(new MobEffectInstance(IEPotions.STUNNED, 60));
                }
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)IESounds.spark.value(), SoundSource.BLOCKS, 2.5f, 0.5f + rng.nextFloat());
            }
        }
        if (event.getSource().is(DamageTypeTags.IS_FIRE) && event.getEntity().getEffect(IEPotions.FLAMMABLE) != null) {
            int amp = event.getEntity().getEffect(IEPotions.FLAMMABLE).getAmplifier();
            float mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setNewDamage(event.getNewDamage() * mod);
        }
        if (("flux".equals(event.getSource().getMsgId()) || event.getSource().is(Lib.DamageTypes.RAZOR_SHOCK) || event.getSource() instanceof IEDamageSources.ElectricDamageSource) && event.getEntity().getEffect(IEPotions.CONDUCTIVE) != null) {
            int amp = event.getEntity().getEffect(IEPotions.CONDUCTIVE).getAmplifier();
            float mod = 1.5f + (float)(amp * amp) * 0.5f;
            event.setNewDamage(event.getNewDamage() * mod);
        }
        if (event.getNewDamage() >= event.getEntity().getHealth() && event.getSource().getEntity() instanceof Player && ((Player)event.getSource().getEntity()).getItemInHand(InteractionHand.MAIN_HAND).getItem() instanceof DrillItem) {
            Utils.unlockIEAdvancement((Player)event.getSource().getEntity(), "tools/secret_drillbreak");
        }
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Vec3 motion = event.getEntity().getDeltaMovement();
        if (event.getEntity().getEffect(IEPotions.STICKY) != null) {
            motion = motion.subtract(0.0, (double)((float)(event.getEntity().getEffect(IEPotions.STICKY).getAmplifier() + 1) * 0.2f), 0.0);
        } else if (event.getEntity().getEffect(IEPotions.CONCRETE_FEET) != null) {
            motion = Vec3.ZERO;
        }
        event.getEntity().setDeltaMovement(motion);
    }

    @SubscribeEvent
    public void onLivingUpdate(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack chestplate = player.getItemBySlot(EquipmentSlot.CHEST);
        AttachedItem powerpack = (AttachedItem)chestplate.get(IEDataComponents.CONTAINED_POWERPACK);
        if (powerpack != null) {
            ItemStack newPack = powerpack.attached().copy();
            PowerpackItem.tickWornPack(newPack, player.level(), player);
            chestplate.set(IEDataComponents.CONTAINED_POWERPACK, (Object)new AttachedItem(newPack));
        }
    }

    @SubscribeEvent
    public void digSpeedEvent(PlayerEvent.BreakSpeed event) {
        BlockEntity te;
        ItemStack current = event.getEntity().getItemInHand(InteractionHand.MAIN_HAND);
        if (!current.isEmpty() && current.getItem() == IEItems.Tools.DRILL.get() && event.getEntity().isEyeInFluid(FluidTags.WATER)) {
            if (IEItems.Tools.DRILL.get().getUpgrades(current).has(UpgradeEffect.WATERPROOF)) {
                event.setNewSpeed(event.getOriginalSpeed() * 5.0f);
            } else {
                event.setCanceled(true);
            }
        }
        if (event.getState().is(IETags.wirecutterHarvestable) && !current.canPerformAction(Lib.WIRECUTTER_DIG)) {
            event.setCanceled(true);
            if (event.getEntity().getRandom().nextInt(4) == 0) {
                RazorWireBlockEntity.applyDamage((LivingEntity)event.getEntity());
            }
        }
        if (event.getPosition().isPresent() && (te = event.getEntity().getCommandSenderWorld().getBlockEntity((BlockPos)event.getPosition().get())) instanceof IEBlockInterfaces.IEntityProof && !((IEBlockInterfaces.IEntityProof)te).canEntityDestroy((Entity)event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAnvilChange(AnvilUpdateEvent event) {
        if (!event.getLeft().isEmpty() && event.getLeft().getItem() instanceof IDrillHead && ((IDrillHead)event.getLeft().getItem()).getHeadDamage(event.getLeft()) > 0 && !event.getRight().isEmpty() && event.getLeft().getItem().isValidRepairItem(event.getLeft(), event.getRight())) {
            int cost;
            event.setOutput(event.getLeft().copy());
            int repair = Math.min(((IDrillHead)event.getOutput().getItem()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().getItem()).getMaximumHeadDamage(event.getOutput()) / 4);
            for (cost = 0; repair > 0 && cost < event.getRight().getCount(); ++cost) {
                ((IDrillHead)event.getOutput().getItem()).damageHead(event.getOutput(), -repair);
                event.setCost((long)Math.max(1, repair / 200));
                repair = Math.min(((IDrillHead)event.getOutput().getItem()).getHeadDamage(event.getOutput()), ((IDrillHead)event.getOutput().getItem()).getMaximumHeadDamage(event.getOutput()) / 4);
            }
            event.setMaterialCost(cost);
            if (event.getName() == null || event.getName().isEmpty()) {
                if (event.getLeft().has(DataComponents.CUSTOM_NAME)) {
                    event.setCost(event.getCost() + 5L);
                    event.getOutput().remove(DataComponents.CUSTOM_NAME);
                }
            } else if (!event.getName().equals(event.getLeft().getHoverName().getString())) {
                event.setCost(event.getCost() + 5L);
                if (event.getLeft().has(DataComponents.CUSTOM_NAME)) {
                    event.setCost(event.getCost() + 2L);
                }
                event.getOutput().set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)event.getName()));
            }
        }
    }

    @SubscribeEvent
    public void onNoteBlockPlay(NoteBlockEvent.Play event) {
        LevelAccessor levelAccessor;
        if (event.getInstrument().worksAboveNoteBlock() || !((levelAccessor = event.getLevel()) instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        BlockPos pos = event.getPos();
        if (!level.getBlockState(pos.below()).is((Block)IEBlocks.MetalDecoration.ENGINEERING_RESONANZ.get())) {
            return;
        }
        event.setCanceled(true);
        int note = event.getVanillaNoteId();
        float pitch = NoteBlock.getPitchFromNote((int)note);
        level.addParticle((ParticleOptions)ParticleTypes.NOTE, (double)pos.getX() + 0.5, (double)pos.getY() + 1.2, (double)pos.getZ() + 0.5, (double)note / 24.0, 0.0, 0.0);
        level.playSeededSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, IESounds.note_block_resonanz, SoundSource.RECORDS, 3.0f, pitch, level.random.nextLong());
        if (level instanceof ServerLevel) {
            level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos).inflate(48.0), p -> !Utils.hasIEAdvancement((Player)p, "main/secret_achtung")).forEach(player -> {
                int[] lastHeard = (int[])RESONANZ_NOTES_HEARD.getUnchecked((Object)player.getUUID());
                boolean written = false;
                for (int i = 0; i < lastHeard.length; ++i) {
                    if (lastHeard[i] >= 0) continue;
                    lastHeard[i] = note;
                    written = true;
                    break;
                }
                if (!written) {
                    lastHeard = new int[]{note, -1, -1};
                }
                if (Arrays.equals(lastHeard, RESONANZ_TARGET)) {
                    Utils.unlockIEAdvancement((Player)player, "main/secret_achtung");
                }
                RESONANZ_NOTES_HEARD.put((Object)player.getUUID(), (Object)lastHeard);
            });
        }
    }

    @SubscribeEvent
    public void onBlockRightclick(PlayerInteractEvent.RightClickBlock event) {
        LecternBlockEntity lectern;
        if (event.getLevel().isClientSide) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = event.getLevel().getBlockState(pos);
        if (!(state.getBlock() instanceof LecternBlock) || event.getEntity() == null) {
            return;
        }
        BlockEntity tile = event.getLevel().getBlockEntity(pos);
        if (tile instanceof LecternBlockEntity && (lectern = (LecternBlockEntity)tile).getBook().getItem() instanceof ManualItem) {
            if (!event.getEntity().isShiftKeyDown()) {
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new MessageOpenManual(), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                Direction direction = (Direction)state.getValue((Property)LecternBlock.FACING);
                ItemStack itemstack = ((LecternBlockEntity)tile).getBook().copy();
                float f = 0.25f * (float)direction.getStepX();
                float f1 = 0.25f * (float)direction.getStepZ();
                ItemEntity itementity = new ItemEntity(event.getLevel(), (double)pos.getX() + 0.5 + (double)f, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5 + (double)f1, itemstack);
                itementity.setDefaultPickUpDelay();
                event.getLevel().addFreshEntity((Entity)itementity);
                lectern.clearContent();
                LecternBlock.resetBookState(null, (Level)event.getLevel(), (BlockPos)pos, (BlockState)state, (boolean)false);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (!(event.getSource() instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
        serverPlayer.awardStat((ResourceLocation)IEStats.WIRE_DEATHS.value());
        if (serverPlayer.getAbilities().flying || serverPlayer.isFallFlying()) {
            Utils.unlockIEAdvancement((Player)serverPlayer, "main/secret_friedbird");
        }
    }

    @SubscribeEvent
    public void onMobSpawn(EntityJoinLevelEvent event) {
        Raider raider;
        if (event.isCanceled() || event.loadedFromDisk()) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof Raider && (raider = (Raider)entity).hasActiveRaid() && (entity = event.getLevel()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)entity;
            if (raider instanceof EngineerIllager) {
                return;
            }
            Raid raid = raider.getCurrentRaid();
            if (level.players().stream().anyMatch(canTriggerEngineerRaid.apply(raid))) {
                for (IllagerUpgrade upgrade : ILLAGER_UPGRADES) {
                    if (!upgrade.shouldUpgrade(raider)) continue;
                    int wave = raider.getWave();
                    BlockPos pos = raider.blockPosition();
                    Raider replacement = (Raider)upgrade.replacement.create((Level)level);
                    if (raider.isPatrolLeader() && replacement.canBeLeader()) {
                        replacement.setPatrolLeader(true);
                        raid.setLeader(wave, replacement);
                    }
                    raid.joinRaid(wave, replacement, pos, false);
                    raid.removeFromRaid(raider, true);
                    event.setCanceled(true);
                }
            }
        }
    }

    record IllagerUpgrade(EntityType<? extends Raider> type, EntityType<? extends Raider> replacement, float chance) {
        boolean shouldUpgrade(Raider target) {
            return this.type == target.getType() && target.getRandom().nextFloat() <= this.chance;
        }
    }
}

